/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.sitenode;

import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.sitenode.SiteNodeRequestContext;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Document;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;

public class SiteNodePresentationManager
implements PresentationManager {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/sitenode/SiteNodePresentationManager.java#15 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$sitenode$SiteNodePresentationManager == null ? (class$com$arsdigita$sitenode$SiteNodePresentationManager = SiteNodePresentationManager.class$("com.arsdigita.sitenode.SiteNodePresentationManager")) : class$com$arsdigita$sitenode$SiteNodePresentationManager));
    private Map m_stylesheet_map = new HashMap();
    private static SiteNodePresentationManager s_instance = new SiteNodePresentationManager();
    static /* synthetic */ Class class$com$arsdigita$sitenode$SiteNodePresentationManager;

    public static PresentationManager getInstance() {
        return s_instance;
    }

    private Stylesheet getStylesheet(SiteNode sn, Locale l, String outputType) {
        Stylesheet[] ssSet = sn.getStylesheets(l, outputType);
        return Stylesheet.combineStylesheets(ssSet);
    }

    protected Stylesheet getComposedStylesheet(SiteNodeRequestContext rctx) {
        return this.getComposedStylesheet(rctx.getSiteNode(), rctx.getLocale(), rctx.getOutputType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Stylesheet getComposedStylesheet(SiteNode sn, Locale l, String outputType) {
        String mapKey = sn.getNodeId() + "|" + l.toString() + "|" + outputType;
        Stylesheet stylesheet = (Stylesheet)this.m_stylesheet_map.get(mapKey);
        if (stylesheet != null && stylesheet.isValid()) {
            return stylesheet;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            stylesheet = this.rebuildComposedStylesheet(sn, l, outputType);
            this.m_stylesheet_map.put(mapKey, stylesheet);
        }
        return stylesheet;
    }

    private Stylesheet rebuildComposedStylesheet(SiteNode sn, Locale l, String outputType) {
        TransactionContext tctx = SessionManager.getSession().getTransactionContext();
        boolean callerStartedTransaction = tctx.inTxn();
        if (!callerStartedTransaction) {
            tctx.beginTxn();
        }
        Stylesheet thisStyle = this.getStylesheet(sn, l, outputType);
        Stylesheet parentStyle = null;
        for (SiteNode parent = sn.getParent(); parent != null; parent = parent.getParent()) {
            parentStyle = this.getStylesheet(parent, l, outputType);
            thisStyle = thisStyle != null ? thisStyle.composeStylesheet(parentStyle) : parentStyle;
        }
        Stylesheet packageStyles = this.rebuildDefaultStyles(sn, l, outputType);
        thisStyle = thisStyle != null ? thisStyle.composeStylesheet(packageStyles) : packageStyles;
        if (!callerStartedTransaction) {
            tctx.commitTxn();
        }
        return thisStyle;
    }

    private Stylesheet rebuildDefaultStyles(SiteNode sn, Locale l, String outputType) {
        Stylesheet thisStyle = null;
        List remainingPackages = PackageType.getAllPackageKeys();
        for (SiteNode parent = sn; parent != null; parent = parent.getParent()) {
            PackageInstance pi = sn.getPackageInstance();
            int idx = remainingPackages.indexOf(pi.getType().getKey());
            if (idx <= -1) continue;
            remainingPackages.remove(idx);
            Stylesheet thisPackage = this.getDefaultStylesheet(pi.getType(), l, outputType);
            thisStyle = thisStyle != null ? thisStyle.composeStylesheet(thisPackage) : thisPackage;
        }
        for (int i = 0; i < remainingPackages.size(); ++i) {
            PackageType pType = null;
            pType = new PackageType();
            pType.setKey((String)remainingPackages.get(i));
            Stylesheet pkgSS = this.getDefaultStylesheet(pType, l, outputType);
            thisStyle = thisStyle == null ? pkgSS : thisStyle.composeStylesheet(pkgSS);
        }
        return thisStyle;
    }

    private Stylesheet getDefaultStylesheet(PackageType pkg, Locale l, String outputType) {
        Stylesheet[] ssSet = pkg.getStylesheets(l, outputType);
        return Stylesheet.combineStylesheets(ssSet);
    }

    public void invalidateStylesheet(SiteNode sn) {
        Iterator keys = this.m_stylesheet_map.keySet().iterator();
        while (keys.hasNext()) {
            Stylesheet stylesheet;
            String key = (String)keys.next();
            if (!key.startsWith(sn.getNodeId() + "|") || (stylesheet = (Stylesheet)this.m_stylesheet_map.get(key)) == null) continue;
            stylesheet.invalidate();
        }
    }

    public void servePage(Document doc, HttpServletRequest req, HttpServletResponse resp) {
        this.servePage(doc, req, resp, null);
    }

    public void servePage(Document doc, HttpServletRequest req, HttpServletResponse resp, Map params) {
        RequestContext ctx = DispatcherHelper.getRequestContext(req);
        PrintWriter writer = null;
        try {
            DeveloperSupport.startStage("PresMgr get stylesheet");
            Stylesheet ss = this.getComposedStylesheet((SiteNodeRequestContext)ctx);
            Transformer xf = null;
            if (ss != null) {
                xf = ss.newTransformer();
            }
            if (ss == null || xf == null) {
                throw new ServletException("No stylesheet available for request!");
            }
            DeveloperSupport.endStage("PresMgr get stylesheet");
            this.completeTransaction(req);
            DeveloperSupport.startStage("PresMgr transform");
            if (ctx.getDebuggingXML()) {
                resp.setContentType("text/xml");
                writer = resp.getWriter();
                writer.println(doc.toString(true));
            } else if (ctx.getDebuggingXSL()) {
                resp.setContentType("text/xml");
                writer = resp.getWriter();
                writer.println(ss.toString());
            } else {
                resp.setContentType(ctx.getOutputType());
                writer = resp.getWriter();
                xf.transform(new DOMSource(doc.getInternalDocument()), new StreamResult(writer));
            }
            DeveloperSupport.endStage("PresMgr transform");
        }
        catch (TransformerConfigurationException e) {
            throw new UncheckedWrapperException(e);
        }
        catch (TransformerException e) {
            throw new UncheckedWrapperException(e);
        }
        catch (ClassCastException cce) {
            throw new UncheckedWrapperException(cce);
        }
        catch (ServletException ex) {
            throw new UncheckedWrapperException(ex);
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException(ex);
        }
    }

    private void completeTransaction(HttpServletRequest req) {
        String JSP_EXCEPTION_ATTRIBUTE = "javax.servlet.jsp.jspException";
        Session sess = SessionManager.getSession();
        TransactionContext txc = sess.getTransactionContext();
        if (req.getAttribute("javax.servlet.jsp.jspException") == null) {
            s_log.debug((Object)"trying to commit");
            txc.commitTxn();
            s_log.debug((Object)"request over, committing transaction");
        } else {
            s_log.debug((Object)"trying to abort");
            txc.abortTxn();
            s_log.debug((Object)"request over, aborting transaction");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

