/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.sitenode;

import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.globalization.ApplicationLocaleProvider;
import com.arsdigita.globalization.ClientLocaleProvider;
import com.arsdigita.globalization.LocaleNegotiator;
import com.arsdigita.kernel.KernelRequestContext;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.SiteNode;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SiteNodeRequestContext
extends KernelRequestContext {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/sitenode/SiteNodeRequestContext.java#13 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$sitenode$SiteNodeRequestContext == null ? (class$com$arsdigita$sitenode$SiteNodeRequestContext = SiteNodeRequestContext.class$("com.arsdigita.sitenode.SiteNodeRequestContext")) : class$com$arsdigita$sitenode$SiteNodeRequestContext));
    private SiteNode m_sn;
    private LocaleNegotiator m_ln;
    static /* synthetic */ Class class$com$arsdigita$sitenode$SiteNodeRequestContext;

    protected SiteNodeRequestContext(SiteNodeRequestContext that) {
        super(that);
        this.m_sn = that.m_sn;
        this.m_ln = that.m_ln;
    }

    public SiteNodeRequestContext(HttpServletRequest req, RequestContext parent, SiteNode sn, String pathPrefix) {
        super((KernelRequestContext)parent);
        s_log.debug((Object)"Constructing a SiteNodeRequestContext");
        String snURL = sn.getURL("");
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Using site node URL '" + snURL + "'"));
            s_log.debug((Object)("pathPrefix == '" + pathPrefix + "'"));
            s_log.debug((Object)("getServletPath() -> '" + req.getServletPath() + "'"));
            s_log.debug((Object)("getContextPath() -> '" + req.getContextPath() + "'"));
            s_log.debug((Object)("parent.getRemainingURLPart() -> '" + parent.getRemainingURLPart() + "'"));
            s_log.debug((Object)("parent.getProcessedURLPart() -> '" + parent.getProcessedURLPart() + "'"));
        }
        int startidx = pathPrefix.length();
        String remainingUrl = parent.getRemainingURLPart();
        remainingUrl = remainingUrl.length() >= startidx ? remainingUrl.substring(startidx) : "";
        if (snURL.endsWith("/") && !parent.getOriginalURL().endsWith("/") && remainingUrl.length() == 0) {
            snURL = snURL.substring(0, startidx - 1);
        }
        String processedUrl = parent.getProcessedURLPart() + snURL;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Setting processed URL part to '" + processedUrl + "'"));
        }
        this.setProcessedURLPart(processedUrl);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Setting remaining URL part to '" + remainingUrl + "'"));
        }
        this.setRemainingURLPart(remainingUrl);
        this.m_sn = sn;
        PackageInstance pkg = this.m_sn.getPackageInstance();
        if (pkg != null) {
            ClientLocaleProvider clp;
            ApplicationLocaleProvider alp = (ApplicationLocaleProvider)LocaleNegotiator.getApplicationLocaleProvider();
            if (alp != null) {
                alp.setLocale(pkg.getLocale());
            }
            if ((clp = (ClientLocaleProvider)LocaleNegotiator.getClientLocaleProvider()) != null) {
                clp.setTargetBundle(pkg.getTargetBundle());
                clp.setAcceptLanguages(req.getHeader("Accept-Language"));
            }
            this.m_ln = new LocaleNegotiator(pkg.getTargetBundle(), null, req.getHeader("Accept-Charset"), null);
        }
    }

    public SiteNode getSiteNode() {
        return this.m_sn;
    }

    public Locale getLocale() {
        if (this.m_ln != null) {
            return this.m_ln.getLocale();
        }
        return Locale.getDefault();
    }

    public ResourceBundle getResourceBundle() {
        if (this.m_ln != null) {
            return this.m_ln.getBundle();
        }
        return null;
    }

    public String getPageBase() {
        return "/packages/" + this.m_sn.getPackageInstance().getKey() + "/www/";
    }

    public PackageInstance getPackageInstance() {
        return this.getSiteNode().getPackageInstance();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

