/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.templating;

import com.arsdigita.bebop.Bebop;
import com.arsdigita.caching.CacheTable;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.templating.LoggingErrorListener;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.templating.TemplatingConfig;
import com.arsdigita.templating.XSLTemplate;
import com.arsdigita.util.Assert;
import com.arsdigita.util.ExceptionUnwrapper;
import com.arsdigita.util.Exceptions;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.servlet.HttpHost;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;

public class Templating {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/templating/Templating.java#15 $$Author: dan $$DateTime: 2004/05/10 07:15:14 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$templating$Templating == null ? (class$com$arsdigita$templating$Templating = Templating.class$("com.arsdigita.templating.Templating")) : class$com$arsdigita$templating$Templating));
    public static final Class DEFAULT_PRESENTATION_MANAGER = class$com$arsdigita$templating$SimplePresentationManager == null ? (class$com$arsdigita$templating$SimplePresentationManager = Templating.class$("com.arsdigita.templating.SimplePresentationManager")) : class$com$arsdigita$templating$SimplePresentationManager;
    public static final String FANCY_ERROR_COLLECTION = "fancyErrorCollection";
    private static CacheTable s_templates = new CacheTable("templating", 50, 259200);
    private static final TemplatingConfig s_config = new TemplatingConfig();
    static /* synthetic */ Class class$com$arsdigita$templating$Templating;
    static /* synthetic */ Class class$com$arsdigita$templating$SimplePresentationManager;
    static /* synthetic */ Class class$javax$xml$transform$TransformerException;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;

    public static TemplatingConfig getConfig() {
        return s_config;
    }

    public static PresentationManager getPresentationManager() {
        return Bebop.getConfig().getPresentationManager();
    }

    public static synchronized XSLTemplate getTemplate(URL source) {
        return Templating.getTemplate(source, false, true);
    }

    public static synchronized XSLTemplate getTemplate(URL source, boolean fancyErrors, boolean useCache) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Getting template for URL " + source));
        }
        Assert.exists(source, class$java$net$URL == null ? (class$java$net$URL = Templating.class$("java.net.URL")) : class$java$net$URL);
        XSLTemplate template = null;
        if (useCache) {
            template = (XSLTemplate)s_templates.get(source.toString());
        }
        if (template == null) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("The template for URL " + source + " is not " + "cached; creating and caching it now"));
            }
            if (fancyErrors) {
                LoggingErrorListener listener = new LoggingErrorListener();
                Web.getRequest().setAttribute(FANCY_ERROR_COLLECTION, (Object)listener.getErrors());
                template = new XSLTemplate(source, listener);
            } else {
                template = new XSLTemplate(source);
            }
            if (useCache) {
                s_templates.put(source.toString(), (Object)template);
            }
        } else if (Kernel.getConfig().isDebugEnabled() && template.isModified()) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Template " + template + " has been modified; " + "recreating it from scratch"));
            }
            if (fancyErrors) {
                LoggingErrorListener listener = new LoggingErrorListener();
                Web.getRequest().setAttribute(FANCY_ERROR_COLLECTION, (Object)listener.getErrors());
                template = new XSLTemplate(source, listener);
            } else {
                template = new XSLTemplate(source);
            }
            s_templates.put(source.toString(), (Object)template);
        }
        return template;
    }

    public static XSLTemplate getTemplate(HttpServletRequest sreq) {
        return Templating.getTemplate(sreq, false, true);
    }

    public static XSLTemplate getTemplate(HttpServletRequest sreq, boolean fancyErrors, boolean useCache) {
        Assert.exists(sreq, class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = Templating.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest);
        URL sheet = Templating.getConfig().getStylesheetResolver().resolve(sreq);
        Assert.exists(sheet, class$java$net$URL == null ? (class$java$net$URL = Templating.class$("java.net.URL")) : class$java$net$URL);
        return Templating.getTemplate(sheet, fancyErrors, useCache);
    }

    public static synchronized void purgeTemplate(URL source) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Purging cached template for URL " + source));
        }
        Assert.exists(source, class$java$net$URL == null ? (class$java$net$URL = Templating.class$("java.net.URL")) : class$java$net$URL);
        s_templates.remove(source.toString());
    }

    public static synchronized void purgeTemplates() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Purging all cached templates");
        }
        s_templates.removeAll();
    }

    public static InputStream multiplexXSLFiles(Iterator paths) {
        StringBuffer buf = new StringBuffer();
        Element root = new Element("xsl:stylesheet", "http://www.w3.org/1999/XSL/Transform");
        root.addAttribute("version", "1.0");
        while (paths.hasNext()) {
            URL path = (URL)paths.next();
            Element imp = root.newChildElement("xsl:import", "http://www.w3.org/1999/XSL/Transform");
            imp.addAttribute("href", path.toString());
            if (!s_log.isInfoEnabled()) continue;
            s_log.info((Object)("Adding import for " + path.toString()));
        }
        Document doc = null;
        try {
            doc = new Document(root);
        }
        catch (ParserConfigurationException ex) {
            throw new UncheckedWrapperException("cannot build document", ex);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("XSL is " + doc.toString(true)));
        }
        return new ByteArrayInputStream(doc.toString(true).getBytes());
    }

    static URL transformURL(URL url) {
        HttpHost self = Web.getConfig().getHost();
        String path = url.getPath();
        if (self.getName().equals(url.getHost()) && (self.getPort() == url.getPort() || url.getPort() == -1 && self.getPort() == 80)) {
            if (path.startsWith("/resource")) {
                path = path.substring("/resource".length());
                URL newURL = Web.findResource(path);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Transforming resource " + url + " to " + newURL));
                }
                return newURL;
            }
            String filename = Web.getServletContext().getRealPath(path);
            File file = new File(filename);
            if (file.exists()) {
                try {
                    URL newURL = file.toURL();
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Transforming resource " + url + " to " + newURL));
                    }
                    return newURL;
                }
                catch (MalformedURLException ex) {
                    throw new UncheckedWrapperException(ex);
                }
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("File " + filename + " doesn't exist on disk"));
            }
        } else if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("URL " + url + " is not local"));
        }
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_config.load("ccm-core/templating.properties");
        Exceptions.registerUnwrapper(class$javax$xml$transform$TransformerException == null ? (class$javax$xml$transform$TransformerException = Templating.class$("javax.xml.transform.TransformerException")) : class$javax$xml$transform$TransformerException, new ExceptionUnwrapper(){

            public Throwable unwrap(Throwable t) {
                TransformerException ex = (TransformerException)t;
                return ex.getCause();
            }
        });
    }
}

