/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.templating;

import com.arsdigita.templating.SimpleURIResolver;
import com.arsdigita.templating.Templating;
import com.arsdigita.templating.WrappedTransformerException;
import com.arsdigita.util.Assert;
import com.arsdigita.util.IO;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Document;

public final class XSLTemplate {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/templating/XSLTemplate.java#14 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$templating$XSLTemplate == null ? (class$com$arsdigita$templating$XSLTemplate = XSLTemplate.class$("com.arsdigita.templating.XSLTemplate")) : class$com$arsdigita$templating$XSLTemplate));
    private final URL m_source;
    private final Templates m_templates;
    private final List m_dependents;
    private final Date m_created;
    static /* synthetic */ Class class$com$arsdigita$templating$XSLTemplate;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$javax$xml$transform$ErrorListener;
    static /* synthetic */ Class class$javax$xml$transform$Source;
    static /* synthetic */ Class class$javax$xml$transform$Result;
    static /* synthetic */ Class class$org$w3c$dom$Document;
    static /* synthetic */ Class class$java$io$PrintWriter;

    public XSLTemplate(URL source, ErrorListener listener) {
        if (Assert.isEnabled()) {
            Assert.exists(source, class$java$net$URL == null ? (class$java$net$URL = XSLTemplate.class$("java.net.URL")) : class$java$net$URL);
            Assert.exists(listener, class$javax$xml$transform$ErrorListener == null ? (class$javax$xml$transform$ErrorListener = XSLTemplate.class$("javax.xml.transform.ErrorListener")) : class$javax$xml$transform$ErrorListener);
        }
        this.m_source = source;
        SimpleURIResolver resolver = new SimpleURIResolver();
        try {
            s_log.debug((Object)"Getting new templates object");
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setURIResolver(resolver);
            factory.setErrorListener(listener);
            this.m_templates = factory.newTemplates(resolver.resolve(this.m_source.toString(), null));
            s_log.debug((Object)"Done getting new templates");
        }
        catch (TransformerConfigurationException ex) {
            throw new WrappedTransformerException(ex);
        }
        catch (TransformerException ex) {
            throw new WrappedTransformerException(ex);
        }
        this.m_dependents = resolver.getStylesheetURIs();
        this.m_created = new Date();
    }

    public XSLTemplate(URL source) {
        this(source, new Log4JErrorListener());
    }

    public final URL getSource() {
        return this.m_source;
    }

    public final List getDependents() {
        return this.m_dependents;
    }

    public final synchronized Transformer newTransformer() {
        s_log.debug((Object)"Generating new transformer");
        try {
            return this.m_templates.newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            throw new WrappedTransformerException(tce);
        }
    }

    public final void transform(Source source, Result result, ErrorListener listener) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Transforming " + source + " and sending it to " + result + " using error listener " + listener));
        }
        if (Assert.isEnabled()) {
            Assert.exists(source, class$javax$xml$transform$Source == null ? (class$javax$xml$transform$Source = XSLTemplate.class$("javax.xml.transform.Source")) : class$javax$xml$transform$Source);
            Assert.exists(result, class$javax$xml$transform$Result == null ? (class$javax$xml$transform$Result = XSLTemplate.class$("javax.xml.transform.Result")) : class$javax$xml$transform$Result);
            Assert.exists(listener, class$javax$xml$transform$ErrorListener == null ? (class$javax$xml$transform$ErrorListener = XSLTemplate.class$("javax.xml.transform.ErrorListener")) : class$javax$xml$transform$ErrorListener);
        }
        try {
            Transformer transformer = this.newTransformer();
            transformer.setErrorListener(listener);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Transforming the XML source document");
            }
            transformer.transform(source, result);
            s_log.debug((Object)"Finished transforming");
        }
        catch (TransformerConfigurationException tce) {
            throw new WrappedTransformerException(tce);
        }
        catch (TransformerException te) {
            throw new WrappedTransformerException(te);
        }
    }

    public final void transform(Source source, Result result) {
        this.transform(source, result, (ErrorListener)new Log4JErrorListener());
    }

    public final void transform(Document doc, PrintWriter writer, ErrorListener listener) {
        if (Assert.isEnabled()) {
            Assert.exists(doc, class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = XSLTemplate.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document);
            Assert.exists(writer, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = XSLTemplate.class$("java.io.PrintWriter")) : class$java$io$PrintWriter);
            Assert.exists(listener, class$javax$xml$transform$ErrorListener == null ? (class$javax$xml$transform$ErrorListener = XSLTemplate.class$("javax.xml.transform.ErrorListener")) : class$javax$xml$transform$ErrorListener);
        }
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(writer);
        this.transform(source, result, listener);
    }

    public final void transform(Document doc, PrintWriter writer) {
        this.transform(doc, writer, (ErrorListener)new Log4JErrorListener());
    }

    public final boolean isModified() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Checking if the XSL files for " + this + " " + "have been modified and need to be re-read"));
        }
        Iterator iter = this.m_dependents.iterator();
        while (iter.hasNext()) {
            URL url = Templating.transformURL((URL)iter.next());
            Assert.exists(url, class$java$net$URL == null ? XSLTemplate.class$("java.net.URL") : class$java$net$URL);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getPath());
                if (file.lastModified() <= this.m_created.getTime()) continue;
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("File " + file + " was modified " + file.lastModified()));
                }
                return true;
            }
            if (!s_log.isDebugEnabled()) continue;
            s_log.debug((Object)("The URL is not to a file; assuming " + url + " is not modified"));
        }
        s_log.debug((Object)"No files were modified");
        return false;
    }

    public void toZIP(OutputStream os, String base) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        URL src = this.getSource();
        String srcProto = src.getProtocol();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Outputting files for " + src));
        }
        Iterator sheets = this.getDependents().iterator();
        while (sheets.hasNext()) {
            URL xsl = (URL)sheets.next();
            if (xsl.getProtocol().equals(srcProto)) {
                String path;
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Outputting file " + xsl));
                }
                if ((path = xsl.getPath()).startsWith("/")) {
                    path = path.substring(1);
                }
                zos.putNextEntry(new ZipEntry(base + "/" + path));
                IO.copy(xsl.openStream(), zos);
                continue;
            }
            s_log.warn((Object)("Not outputting file " + xsl + " because its not under protocol " + srcProto));
        }
        zos.finish();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Log4JErrorListener
    implements ErrorListener {
        private Log4JErrorListener() {
        }

        public void warning(TransformerException e) throws TransformerException {
            Log4JErrorListener.log(Level.WARN, e);
        }

        public void error(TransformerException e) throws TransformerException {
            Log4JErrorListener.log(Level.ERROR, e);
        }

        public void fatalError(TransformerException e) throws TransformerException {
            Log4JErrorListener.log(Level.FATAL, e);
        }

        private static void log(Level level, TransformerException ex) {
            s_log.log((Priority)level, (Object)("Transformer " + level + ": " + ex.getLocationAsString() + ": " + ex.getMessage()), (Throwable)ex);
        }
    }
}

