/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.rebop;

import com.arsdigita.toolbox.rebop.ImageUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;

public class BorderPainter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/rebop/BorderPainter.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final int NORTHWEST = 0;
    public static final int NORTH = 1;
    public static final int NORTHEAST = 2;
    public static final int EAST = 3;
    public static final int SOUTHEAST = 4;
    public static final int SOUTH = 5;
    public static final int SOUTHWEST = 6;
    public static final int WEST = 7;
    private Rectangle[] m_rects;
    private Image m_borderImage;
    private ImageObserver m_obs;
    private Color m_bgColor = Color.blue;

    public BorderPainter(Image m_borderImage, Color m_bgColor, ImageObserver m_obs) {
        this.m_borderImage = m_borderImage;
        this.m_bgColor = m_bgColor;
        this.m_obs = m_obs;
        this.m_rects = new Rectangle[8];
        this.initRects(m_borderImage.getWidth(m_obs) / 3);
    }

    public int getBorderWidth() {
        return this.m_rects[0].width;
    }

    public int getBorderHeight() {
        return this.m_rects[0].height;
    }

    public void initRects(int m_rectsize) {
        this.m_rects[0] = new Rectangle(0, 0, m_rectsize, m_rectsize);
        this.m_rects[1] = new Rectangle(m_rectsize, 0, m_rectsize, m_rectsize);
        this.m_rects[2] = new Rectangle(m_rectsize * 2, 0, m_rectsize, m_rectsize);
        this.m_rects[3] = new Rectangle(m_rectsize * 2, m_rectsize, m_rectsize, m_rectsize);
        this.m_rects[4] = new Rectangle(m_rectsize * 2, m_rectsize * 2, m_rectsize, m_rectsize);
        this.m_rects[5] = new Rectangle(m_rectsize, m_rectsize * 2, m_rectsize, m_rectsize);
        this.m_rects[6] = new Rectangle(0, m_rectsize * 2, m_rectsize, m_rectsize);
        this.m_rects[7] = new Rectangle(0, m_rectsize, m_rectsize, m_rectsize);
    }

    public void paint(Graphics g, Dimension mySize) {
        this.paint(g, mySize, 0, 0);
    }

    public void paint(Graphics g, Dimension mySize, int x, int y) {
        int width = mySize.width - this.m_rects[0].width - this.m_rects[2].width;
        int height = mySize.height - this.m_rects[0].height - this.m_rects[6].height;
        if (null != this.m_bgColor) {
            g.setColor(this.m_bgColor);
            g.fillRect(x + this.m_rects[0].width, y + this.m_rects[0].height, mySize.width - this.m_rects[4].width, mySize.height - this.m_rects[4].height);
        }
        this.drawCorner(g, x, y, 0);
        ImageUtils.drawTiledImage(g, x + this.m_rects[0].width, y, this.m_rects[1], this.m_borderImage, width, this.m_rects[1].height, this.m_obs);
        this.drawCorner(g, x + (mySize.width - this.m_rects[2].width), y, 2);
        ImageUtils.drawTiledImage(g, x, y + this.m_rects[0].height, this.m_rects[7], this.m_borderImage, this.m_rects[7].width, height, this.m_obs);
        this.drawCorner(g, x, y + (mySize.height - this.m_rects[6].height), 6);
        ImageUtils.drawTiledImage(g, x + this.m_rects[6].width, y + (mySize.height - this.m_rects[5].height), this.m_rects[5], this.m_borderImage, width, this.m_rects[5].height, this.m_obs);
        ImageUtils.drawTiledImage(g, x + mySize.width - this.m_rects[3].width, y + this.m_rects[2].height, this.m_rects[3], this.m_borderImage, this.m_rects[3].width, height, this.m_obs);
        this.drawCorner(g, x + (mySize.width - this.m_rects[4].width), y + (mySize.height - this.m_rects[4].height), 4);
    }

    protected void drawCorner(Graphics g, int currentX, int currentY, int rectIndex) {
        g.drawImage(this.m_borderImage, currentX, currentY, currentX + this.m_rects[rectIndex].width, currentY + this.m_rects[rectIndex].height, this.m_rects[rectIndex].x, this.m_rects[rectIndex].y, this.m_rects[rectIndex].x + this.m_rects[rectIndex].width, this.m_rects[rectIndex].y + this.m_rects[rectIndex].height, Color.white, this.m_obs);
    }
}

