/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.rebop;

import com.arsdigita.toolbox.rebop.WrappedRun;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.text.BreakIterator;
import java.util.Vector;

public class FormattedText {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/rebop/FormattedText.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Font m_font = null;
    private Color m_color = null;
    private String m_string = null;

    public FormattedText() {
    }

    public FormattedText(String text) {
        this.m_string = text;
    }

    public FormattedText(Font font, Color color, String string) {
        this.m_font = font;
        this.m_color = color;
        this.m_string = string;
    }

    public void updateGraphics(Graphics g) {
        if (null != this.m_font) {
            g.setFont(this.m_font);
        }
        if (null != this.m_color) {
            g.setColor(this.m_color);
        }
    }

    public String getString() {
        return this.m_string;
    }

    public void setString(String string) {
        this.m_string = string;
    }

    public Font getFont() {
        return this.m_font;
    }

    public void setFont(Font font) {
        this.m_font = font;
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public void draw(Graphics g, int x, int y, int width, int height) {
        this.updateGraphics(g);
        Point startPoint = new Point(x, y);
        Dimension preferredDimension = new Dimension(0, 0);
        FormattedText.drawWrappedText(g, this.m_string, new Dimension(width, height), x, false, startPoint, preferredDimension, null);
    }

    public static void drawWrappedText(Graphics g, String text, Dimension size, int leftMargin, boolean measureOnly, Point startPoint, Dimension preferredDimension, Vector wrappedRuns) {
        String substring;
        int end;
        int y;
        if (null == text) {
            return;
        }
        int x = startPoint.x;
        int initialY = y = startPoint.y;
        BreakIterator bi = BreakIterator.getLineInstance();
        bi.setText(text);
        FontMetrics fm = g.getFontMetrics();
        int lineHeight = fm.getHeight();
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        int start = 0;
        int stop = end = bi.next();
        String currentString = text;
        int maxX = size.width;
        int width = 0;
        int strLen = text.length();
        Font currentFont = null;
        Color currentColor = null;
        if (null != wrappedRuns) {
            currentFont = g.getFont();
            currentColor = g.getColor();
        }
        while (-1 != end) {
            currentString = text.substring(start, end);
            boolean bNewLine = false;
            int newlineIndex = currentString.indexOf("\n");
            if (newlineIndex > 0) {
                bNewLine = true;
            }
            if (0 == newlineIndex) {
                currentString = text.substring(++start, end);
            }
            width = fm.stringWidth(currentString);
            int currentX = width + x;
            if (!bNewLine && currentX < maxX && end < strLen) {
                stop = end;
                end = bi.next();
                continue;
            }
            if (currentX <= maxX) {
                stop = end;
            }
            if (bNewLine) {
                stop = end - 1;
                end = bi.next();
            }
            if (!measureOnly) {
                substring = text.substring(start, stop).replace('\r', ' ');
                substring = substring.replace('\n', ' ');
                g.drawString(substring, x, y + ascent);
                if (null != wrappedRuns) {
                    wrappedRuns.addElement(new WrappedRun(currentFont, currentColor, substring, x, y + ascent));
                }
            }
            if (currentX > maxX || bNewLine) {
                x = leftMargin;
                y += lineHeight;
            } else {
                x += width;
            }
            start = stop;
            end = bi.next();
        }
        substring = text.substring(start);
        if (!measureOnly && substring.length() > 0) {
            g.drawString(substring, x, y + ascent);
            if (null != wrappedRuns) {
                wrappedRuns.addElement(new WrappedRun(currentFont, currentColor, substring, x, y + ascent));
            }
        }
        startPoint.x = x += fm.stringWidth(substring);
        startPoint.y = y;
        preferredDimension.width = size.width;
        preferredDimension.height = startPoint.y - initialY + descent + ascent;
    }
}

