/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.rebop;

import com.arsdigita.toolbox.rebop.GenericDrawable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class GenericComponent
extends Container
implements MouseListener,
GenericDrawable {
    private Color m_foregroundColor = Color.black;
    private GenericDrawable m_drawable = null;
    private static boolean s_debugPaint = false;
    private Image m_backBuffer = null;
    private boolean m_doubleBuffer = false;
    private boolean m_revalidate = true;
    private int m_xOffset = 0;
    private int m_yOffset = 0;

    public void setDrawable(GenericDrawable drawable) {
        this.m_drawable = drawable;
    }

    public GenericDrawable getDrawable() {
        return this.m_drawable;
    }

    public void setDoubleBuffered(boolean db) {
        this.m_doubleBuffer = db;
        if (this.m_doubleBuffer) {
            this.updateBackBuffer(this.getSize());
        }
    }

    public boolean getDoubleBuffered() {
        return this.m_doubleBuffer;
    }

    public void addNotify() {
        super.addNotify();
        this.updateBackBuffer(this.getSize());
    }

    public void setBounds(int x, int y, int width, int height) {
        this.componentReshape(x, y, width, height);
    }

    public void reshape(int x, int y, int width, int height) {
        this.componentReshape(x, y, width, height);
    }

    public void componentReshape(int x, int y, int width, int height) {
        this.forceInvalid();
        super.reshape(x, y, width, height);
        this.updateBackBuffer(width, height);
    }

    public void paint(Graphics g) {
        if (this.m_doubleBuffer) {
            Graphics off = this.m_backBuffer.getGraphics();
            this.draw(off);
            super.paint(off);
            g.drawImage(this.m_backBuffer, 0, 0, this);
            off.dispose();
        } else {
            this.draw(g);
            super.paint(g);
        }
    }

    protected void validateTree() {
        if (this.m_revalidate) {
            super.validateTree();
            this.m_revalidate = false;
        }
    }

    public void forceInvalid() {
        this.m_revalidate = true;
    }

    private void updateBackBuffer(Dimension size) {
        this.updateBackBuffer(size.width, size.height);
    }

    private void updateBackBuffer(int width, int height) {
        if (this.m_doubleBuffer && width > 0 && height > 0) {
            this.m_backBuffer = this.createImage(width, height);
        }
    }

    protected void draw(Graphics g) {
        if (null != this.m_drawable) {
            this.m_drawable.draw(g, 0, 0, this.getSize().width, this.getSize().height);
        }
        this.drawDebug(g);
    }

    public void draw(Graphics g, int x, int y, int width, int height) {
        g.translate(x + this.m_xOffset, y + this.m_yOffset);
        boolean vis = this.isVisible();
        if (!vis) {
            this.setVisible(true);
        }
        this.setSize(width, height);
        this.doLayout();
        boolean tmpDb = this.m_doubleBuffer;
        this.m_doubleBuffer = false;
        this.paint(g);
        this.m_doubleBuffer = tmpDb;
        this.setVisible(vis);
    }

    public void setXOffset(int xOffset) {
        this.m_xOffset = xOffset;
    }

    public int getXOffset() {
        return this.m_xOffset;
    }

    public int getYOffset() {
        return this.m_yOffset;
    }

    public void setYOffset(int yOffset) {
        this.m_yOffset = yOffset;
    }

    protected void drawDebug(Graphics g) {
        if (s_debugPaint) {
            g.setColor(Color.red);
            g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            Dimension prefSize = this.getPreferredSize();
            g.setColor(Color.blue);
            g.drawRect(0, 0, prefSize.width - 1, prefSize.height - 1);
        }
    }

    public static void setDebugPaint(boolean debug) {
        s_debugPaint = debug;
    }

    public static boolean getDebugPaint() {
        return s_debugPaint;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

