/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.rebop;

import com.arsdigita.toolbox.rebop.GenericComponent;
import com.arsdigita.toolbox.rebop.GenericDrawable;
import com.arsdigita.toolbox.rebop.ImageUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class GenericImage
extends GenericComponent
implements GenericDrawable {
    private static final Dimension s_noSize = new Dimension(0, 0);
    private Image m_image = null;
    private Image m_tiledImage = null;
    private boolean m_tiled = false;
    private boolean m_useOffset = false;
    private int m_xOffset = 0;
    private int m_yOffset = 0;

    public GenericImage() {
    }

    public GenericImage(Image image) {
        this.m_image = image;
    }

    public void setImage(Image image) {
        this.m_image = image;
    }

    public Image getImage() {
        return this.m_image;
    }

    public void setTiled(boolean tiled) {
        this.m_tiled = tiled;
    }

    public boolean getTiled() {
        return this.m_tiled;
    }

    public Dimension getPreferredSize() {
        if (null == this.m_image) {
            return s_noSize;
        }
        return new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this));
    }

    public void draw(Graphics g, int x, int y, int width, int height) {
        int xPos = x;
        int yPos = y;
        if (this.m_useOffset) {
            xPos += this.getXOffset();
            yPos += this.getYOffset();
        }
        if (this.m_tiled && null != this.m_image) {
            ImageUtils.drawTiledImage(g, xPos, yPos, new Rectangle(this.m_image.getWidth(this), this.m_image.getHeight(this)), this.m_image, width, height, this);
            return;
        }
        if (null != this.m_image) {
            g.drawImage(this.m_image, xPos, yPos, this);
        }
    }

    private void updateTiledImage(int width, int height) {
        this.m_tiledImage = ImageUtils.createTiledImage(this.m_image, width, height, this);
    }

    public void setXOffset(int xOffset) {
        this.m_xOffset = xOffset;
    }

    public int getXOffset() {
        return this.m_xOffset;
    }

    public int getYOffset() {
        return this.m_yOffset;
    }

    public void setYOffset(int yOffset) {
        this.m_yOffset = yOffset;
    }

    public void setUseOffset(boolean useOffset) {
        this.m_useOffset = useOffset;
    }

    public void paint(Graphics g) {
        this.draw(g, 0, 0, -1, -1);
        super.paint(g);
    }
}

