/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.rebop;

import com.arsdigita.toolbox.rebop.BevelBox;
import com.arsdigita.toolbox.rebop.GenericComponent;
import com.arsdigita.toolbox.rebop.GenericDrawable;
import com.arsdigita.toolbox.rebop.GenericListItem;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class GenericList
extends GenericComponent
implements AdjustmentListener,
ActionListener,
ItemSelectable {
    private Scrollbar m_verticalScrollBar = null;
    private GenericComponent m_componentPane = new GenericComponent();
    private ItemListener m_itemListener = null;
    private boolean m_multiSelect = false;
    private GenericListItem m_selectedItem = null;
    private int m_selectedIndex = -1;
    private Image m_defaultIcon = null;
    private int m_bevelSize;
    private int m_firstVisibleItemIndex = 0;
    private int m_topmostItemIndex = 0;
    private int m_dataItems = 0;
    private int m_maxItems = -1;
    private int m_scrollTop = 0;
    private int m_bottomElementEdge = 0;
    private GenericDrawable m_itemUpDrawable = null;
    private GenericDrawable m_itemDownDrawable = null;
    private GenericDrawable m_itemOverDrawable = null;
    private Font m_itemFont;
    private Color m_labelColor = Color.blue;
    private Color m_selectedLabelColor = Color.white;
    private Color m_rolloverLabelColor = Color.blue;
    private Color m_textColor = Color.black;
    private Color m_selectedTextColor = Color.black;
    private Color m_rolloverTextColor = Color.black;

    public GenericList() {
        this(2);
    }

    public GenericList(int bevelSize) {
        this.m_bevelSize = bevelSize;
        this.m_verticalScrollBar = new Scrollbar(1);
        this.m_verticalScrollBar.setVisible(false);
        this.m_verticalScrollBar.addAdjustmentListener(this);
        this.setLayout(null);
        this.add(this.m_componentPane);
        this.add(this.m_verticalScrollBar);
        this.m_componentPane.setLayout(new FlowLayout(0, 0, 0));
        this.setDrawable(new BevelBox(new Color(203442), new Color(0xAFBBFF), new Color(3417), this.m_bevelSize, true));
    }

    protected void draw(Graphics g) {
        Dimension mySize = this.getSize();
        int bevelReserve = this.m_bevelSize * 2;
        super.draw(g);
        g.setClip(this.m_bevelSize, this.m_bevelSize, mySize.width - bevelReserve, mySize.height - bevelReserve);
    }

    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.updateComponentBounds();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.reshape(x, y, width, height);
    }

    public void setFont(Font itemFont) {
        this.m_itemFont = itemFont;
    }

    public Font getFont() {
        return this.m_itemFont;
    }

    public void setTextColor(Color color) {
        this.m_textColor = color;
        this.updateItemColors();
    }

    public void setSelectedTextColor(Color color) {
        this.m_selectedTextColor = color;
        this.updateItemColors();
    }

    public void setRolloverTextColor(Color color) {
        this.m_rolloverTextColor = color;
        this.updateItemColors();
    }

    public void setLabelColor(Color color) {
        this.m_labelColor = color;
        this.updateItemColors();
    }

    public void setSelectedLabelColor(Color color) {
        this.m_selectedLabelColor = color;
        this.updateItemColors();
    }

    public void setRolloverLabelColor(Color color) {
        this.m_rolloverLabelColor = color;
        this.updateItemColors();
    }

    private void updateItemColors() {
    }

    public void setItemUpDrawable(GenericDrawable upDrawable) {
        this.m_itemUpDrawable = upDrawable;
    }

    public GenericDrawable getItemUpDrawable() {
        return this.m_itemUpDrawable;
    }

    public void setItemDownDrawable(GenericDrawable downDrawable) {
        this.m_itemDownDrawable = downDrawable;
    }

    public GenericDrawable getItemDownDrawable() {
        return this.m_itemDownDrawable;
    }

    public void setItemOverDrawable(GenericDrawable overDrawable) {
        this.m_itemOverDrawable = overDrawable;
    }

    public GenericDrawable getItemOverDrawable() {
        return this.m_itemOverDrawable;
    }

    private void updateScrollbarBounds() {
        Rectangle myBounds = this.getBounds();
        int scrollBarWidth = this.m_verticalScrollBar.getPreferredSize().width;
        this.m_verticalScrollBar.setBounds(new Rectangle(myBounds.width - this.m_bevelSize - scrollBarWidth, this.m_bevelSize, scrollBarWidth, myBounds.height - 2 * this.m_bevelSize));
    }

    public void addNotify() {
        this.forceInvalid();
        super.addNotify();
        this.initComponentBounds();
    }

    private void initComponentBounds() {
        this.forceInvalid();
        Rectangle myBounds = this.getBounds();
        boolean scrollBarWidth = false;
        Rectangle componentPaneBounds = new Rectangle(this.m_bevelSize, this.m_bevelSize, myBounds.width - 2 * this.m_bevelSize, myBounds.height * 2);
        this.m_componentPane.setBounds(componentPaneBounds);
    }

    private void updateComponentBounds() {
        int scrollBarSpace;
        this.forceInvalid();
        this.updateScrollbarBounds();
        Rectangle myBounds = this.getBounds();
        int scrollBarWidth = 0;
        if (this.m_verticalScrollBar.isVisible()) {
            scrollBarWidth = this.m_verticalScrollBar.getPreferredSize().width;
        }
        Rectangle currentComponentPaneBounds = this.m_componentPane.getBounds();
        int componentPaneHeight = currentComponentPaneBounds.height;
        int componentPaneWidth = currentComponentPaneBounds.width;
        boolean resizeComponentPane = true;
        if (myBounds.width != componentPaneWidth) {
            resizeComponentPane = true;
            componentPaneWidth = myBounds.width;
        }
        if (myBounds.height > componentPaneHeight) {
            resizeComponentPane = true;
            currentComponentPaneBounds.height = myBounds.height * 2;
        }
        if (scrollBarWidth > 0 && (scrollBarSpace = myBounds.width - componentPaneWidth) < scrollBarWidth) {
            resizeComponentPane = true;
        }
        if (resizeComponentPane) {
            Rectangle componentPaneBounds = new Rectangle(this.m_bevelSize, this.m_bevelSize, myBounds.width - (2 * this.m_bevelSize + scrollBarWidth), currentComponentPaneBounds.height);
            for (int i = 0; i < this.m_componentPane.getComponentCount(); ++i) {
                GenericListItem item = (GenericListItem)this.m_componentPane.getComponent(i);
                item.setSize(componentPaneBounds.width, 20);
                item.updateLabelSize();
            }
            this.m_componentPane.setBounds(componentPaneBounds);
        }
        this.m_componentPane.validate();
        this.m_componentPane.doLayout();
    }

    public void resize(Dimension size) {
        this.forceInvalid();
        super.resize(size);
        this.initComponentBounds();
        this.updateComponentBounds();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void actionPerformed(ActionEvent e) {
        GenericListItem item = (GenericListItem)e.getSource();
        int itemIndex = item.getCurrentIndex();
        if (0 > itemIndex || itemIndex >= this.m_dataItems) {
            System.out.println("Bad item index: " + itemIndex);
            return;
        }
        int id = 0;
        ItemEvent ie = new ItemEvent(this, id, item.getUserData(), 1);
        if (!this.m_multiSelect && null != this.m_selectedItem && item != this.m_selectedItem) {
            this.m_selectedItem.setSelected(false);
        }
        this.m_selectedIndex = itemIndex;
        this.m_selectedItem = item;
        this.processItemStateChanged(ie);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        int yLoc;
        this.m_scrollTop = yLoc = e.getValue() * -1;
        this.m_componentPane.setLocation(this.m_componentPane.getLocation().x, yLoc);
    }

    public void setDefaultItemIcon(Image icon) {
        this.m_defaultIcon = icon;
    }

    public Image getDefaultItemIcon() {
        return this.m_defaultIcon;
    }

    public void setMaxItems(int max) {
        this.m_maxItems = max;
    }

    public int getMaxItems() {
        return this.m_maxItems;
    }

    public void clear() {
        this.m_componentPane.removeAll();
        this.m_dataItems = 0;
        this.m_firstVisibleItemIndex = 0;
        this.m_topmostItemIndex = 0;
        this.updateComponentBounds();
        this.repaint();
    }

    public void removeElementAtUserData(Object userData) {
        int index = this.getUserDataIndex(userData);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public int getUserDataIndex(Object userData) {
        int index = -1;
        if (null == userData) {
            return index;
        }
        for (int i = 0; i < this.m_componentPane.getComponentCount(); ++i) {
            GenericListItem item = (GenericListItem)this.m_componentPane.getComponent(i);
            if (!userData.equals(item.getUserData())) continue;
            index = i;
            break;
        }
        return index;
    }

    public Object getUserDataAt(int itemIndex) {
        if (0 > itemIndex || itemIndex >= this.m_componentPane.getComponentCount()) {
            return null;
        }
        GenericListItem item = (GenericListItem)this.m_componentPane.getComponent(itemIndex);
        return item.getUserData();
    }

    public void remove(int itemIndexParam) {
        GenericListItem item;
        int itemIndex = itemIndexParam - this.m_topmostItemIndex;
        if (itemIndex >= this.m_dataItems || itemIndex < 0) {
            return;
        }
        this.m_componentPane.remove(itemIndex);
        --this.m_dataItems;
        for (int i = itemIndex; i < this.m_dataItems; ++i) {
            item = (GenericListItem)this.m_componentPane.getComponent(i);
            if (i == itemIndex) {
                this.m_selectedItem = item;
            }
            item.setCurrentIndex(i);
        }
        if (this.m_selectedIndex >= this.m_dataItems) {
            this.m_selectedIndex = -1;
            this.m_selectedItem = null;
        }
        if (itemIndex < this.m_firstVisibleItemIndex) {
            --this.m_firstVisibleItemIndex;
        }
        this.updateComponentBounds();
        int count = this.m_componentPane.getComponentCount();
        if (count > 0) {
            item = (GenericListItem)this.m_componentPane.getComponent(--count);
            Rectangle bounds = item.getBounds();
            this.m_bottomElementEdge = bounds.y + bounds.height;
            this.updateScrollBar();
        }
        this.repaint();
    }

    public int getSelectedIndex() {
        return this.m_selectedIndex;
    }

    public void setColors(Color unselectedColor, Color selectedColor) {
        this.setItemUpDrawable(new BevelBox(unselectedColor, null, null, 0, false));
        this.setItemOverDrawable(new BevelBox(unselectedColor.brighter(), null, null, 0, false));
        this.setItemDownDrawable(new BevelBox(selectedColor, null, null, 0, true));
    }

    public void add(String itemLabel) {
        this.add(itemLabel, "", null);
    }

    public void add(String itemLabel, String itemText, Object userData) {
        this.add(this.m_defaultIcon, itemLabel, itemText, userData);
    }

    protected GenericListItem makeListItem(Image icon, String itemLabel, String itemText, Object userData) {
        return new GenericListItem(icon, itemLabel, itemText, userData, this.getItemUpDrawable(), this.getItemDownDrawable(), this.getItemOverDrawable());
    }

    public void add(Image icon, String itemLabel, String itemText, Object userData) {
        ++this.m_dataItems;
        if (this.m_verticalScrollBar.isVisible()) {
            ++this.m_firstVisibleItemIndex;
        }
        GenericListItem listItem = this.makeListItem(icon, itemLabel, itemText, userData);
        listItem.setLabelColor(this.m_labelColor);
        listItem.setSelectedLabelColor(this.m_selectedLabelColor);
        listItem.setRolloverLabelColor(this.m_rolloverLabelColor);
        listItem.setTextColor(this.m_textColor);
        listItem.setSelectedTextColor(this.m_selectedTextColor);
        listItem.setRolloverTextColor(this.m_rolloverTextColor);
        listItem.setFont(this.m_itemFont);
        this.addComponent(listItem);
    }

    public GenericListItem getItemAt(int index) {
        GenericListItem item = (GenericListItem)this.m_componentPane.getComponent(index);
        return item;
    }

    private void updateScrollBar() {
        Rectangle myBounds = this.getBounds();
        Rectangle containerBounds = this.m_componentPane.getBounds();
        int pageCount = myBounds.height - this.m_bevelSize * 2;
        if (0 < pageCount) {
            this.m_verticalScrollBar.setValues(Math.abs(this.m_scrollTop), pageCount, 0, this.m_bottomElementEdge);
            this.m_verticalScrollBar.setBlockIncrement(pageCount);
        }
        this.showVerticalScrollbar(this.m_bottomElementEdge > myBounds.height, pageCount);
        if (this.m_verticalScrollBar.isVisible()) {
            int itemCount = this.m_componentPane.getComponentCount();
            int averageItemHeight = this.m_bottomElementEdge / itemCount;
            int unitScroll = averageItemHeight / 3;
            if (unitScroll <= 0) {
                unitScroll = 1;
            }
            this.m_verticalScrollBar.setUnitIncrement(unitScroll);
        }
    }

    private int getVisibleItemCount() {
        int count = this.m_componentPane.getComponentCount();
        if (0 == count) {
            return count;
        }
        Rectangle bounds = this.m_componentPane.getBounds();
        int bottom = bounds.height;
        int itemCount = 0;
        for (int i = this.m_firstVisibleItemIndex; i < count; ++i) {
            GenericListItem item = (GenericListItem)this.m_componentPane.getComponent(i);
            Rectangle itemBounds = item.getBounds();
            if (itemBounds.y + itemBounds.height >= bottom) {
                return itemCount;
            }
            ++itemCount;
        }
        return itemCount;
    }

    public GenericListItem getLastComponent() {
        int count = this.m_componentPane.getComponentCount();
        if (0 == count) {
            return null;
        }
        Rectangle bounds = this.m_componentPane.getBounds();
        int bottom = bounds.height;
        boolean index = false;
        GenericListItem candidate = null;
        for (int i = this.m_firstVisibleItemIndex; i < count; ++i) {
            GenericListItem item = (GenericListItem)this.m_componentPane.getComponent(i);
            if (null == candidate) {
                candidate = item;
            }
            Rectangle itemBounds = item.getBounds();
            if (itemBounds.y + itemBounds.height >= bottom) {
                return candidate;
            }
            candidate = item;
            if (i + 1 < count) continue;
            return candidate;
        }
        return null;
    }

    private void addComponent(GenericListItem component) {
        int relativeBottomEdge;
        int componentCount = this.m_componentPane.getComponentCount();
        if (0 >= componentCount) {
            this.forceInvalid();
            this.validateTree();
            this.initComponentBounds();
        }
        Rectangle containerBounds = this.m_componentPane.getBounds();
        int myHeight = this.getBounds().height - this.m_bevelSize * 2;
        component.setCurrentIndex(componentCount);
        int width = containerBounds.width;
        int bottom = containerBounds.height;
        component.setSize(width, 30);
        this.m_componentPane.add(component);
        Dimension prefSize = component.getPreferredSize();
        component.setSize(width, prefSize.height);
        component.addActionListener(this);
        component.validate();
        this.m_componentPane.doLayout();
        Rectangle componentBounds = component.getBounds();
        int componentHeight = componentBounds.height;
        this.m_bottomElementEdge = componentBounds.y + componentHeight;
        if (this.m_bottomElementEdge > bottom) {
            this.m_componentPane.setSize(containerBounds.width, containerBounds.height * 2);
            this.m_componentPane.doLayout();
            componentBounds = component.getBounds();
            this.m_bottomElementEdge = componentBounds.y + componentHeight;
        }
        if ((relativeBottomEdge = this.m_bottomElementEdge + this.m_scrollTop) > myHeight) {
            this.m_scrollTop = -(this.m_bottomElementEdge - myHeight);
            this.m_componentPane.setLocation(this.m_componentPane.getLocation().x, this.m_scrollTop);
        }
        this.updateScrollBar();
    }

    public void showVerticalScrollbar(boolean visible, int pageIncrement) {
        boolean changed;
        if (0 >= pageIncrement) {
            this.m_verticalScrollBar.setVisible(false);
            return;
        }
        boolean bl = changed = this.m_verticalScrollBar.isVisible() != visible;
        if (changed) {
            this.m_verticalScrollBar.setVisible(visible);
            this.updateComponentBounds();
        }
    }

    public void addItemListener(ItemListener l) {
        this.m_itemListener = AWTEventMulticaster.add(this.m_itemListener, l);
    }

    public Object[] getSelectedObjects() {
        return new Object[0];
    }

    public void removeItemListener(ItemListener l) {
        this.m_itemListener = AWTEventMulticaster.remove(this.m_itemListener, l);
    }

    public int getItemCount() {
        return this.m_dataItems;
    }

    protected void processItemStateChanged(ItemEvent e) {
        if (null != this.m_itemListener) {
            this.m_itemListener.itemStateChanged(e);
        }
    }
}

