/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.CompoundComponent;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.xml.Element;

public class PrivilegedComponentSelector
extends CompoundComponent {
    private PrivilegeDescriptor m_requiredPrivilege;
    private RequestLocal m_objectRL;
    private Component m_privilegedComponent;
    private Component m_unprivilegedComponent;

    public PrivilegedComponentSelector(PrivilegeDescriptor requiredPrivilege, RequestLocal objectRL, Component priviledgedComponent, Component unprivilegedComponent) {
        super(new SimpleContainer());
        this.getContainer().add(priviledgedComponent);
        this.getContainer().add(unprivilegedComponent);
        this.m_requiredPrivilege = requiredPrivilege;
        this.m_objectRL = objectRL;
        this.m_privilegedComponent = priviledgedComponent;
        this.m_unprivilegedComponent = unprivilegedComponent;
    }

    public void generateXML(PageState ps, Element parent) {
        ACSObject object = (ACSObject)this.m_objectRL.get(ps);
        Party party = Kernel.getContext().getParty();
        if (object == null || party == null) {
            this.m_privilegedComponent.setVisible(ps, false);
            this.m_unprivilegedComponent.setVisible(ps, true);
        } else {
            PermissionDescriptor perm = new PermissionDescriptor(this.m_requiredPrivilege, object, party);
            if (PermissionService.checkPermission(perm)) {
                this.m_privilegedComponent.setVisible(ps, true);
                this.m_unprivilegedComponent.setVisible(ps, false);
            } else {
                this.m_privilegedComponent.setVisible(ps, false);
                this.m_unprivilegedComponent.setVisible(ps, true);
            }
        }
        super.generateXML(ps, parent);
    }
}

