/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.ui.util.GlobalizationUtil;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;

public class DebugPanel
extends SimpleComponent {
    private static final GlobalizedMessage s_transformOn = GlobalizationUtil.globalize("ui.debug.transform.on");
    private static final GlobalizedMessage s_transformOff = GlobalizationUtil.globalize("ui.debug.transform.off");
    private static final GlobalizedMessage s_xml = GlobalizationUtil.globalize("ui.debug.xml");
    private static final GlobalizedMessage s_xsl = GlobalizationUtil.globalize("ui.debug.xsl");
    private static final String TYPE_GENERIC = "generic";
    private static final String TYPE_ENABLE = "add";
    private static final String TYPE_DISABLE = "delete";

    public void generateXML(PageState state, Element parent) {
        if (!Kernel.getConfig().isDebugEnabled()) {
            return;
        }
        Element content = parent.newChildElement("ui:debugPanel", "http://www.arsdigita.com/ui/1.0");
        this.exportAttributes(content);
        URL here = Web.getContext().getRequestURL();
        URL xmlURL = this.selfURL(state, here, "output", "xml");
        URL xslURL = this.selfURL(state, here, "output", "xsl");
        URL transformOnURL = this.selfURL(state, here, "debug", "transform");
        URL transformOffURL = this.selfURL(state, here, "debug", null);
        this.generateLinkXML(state, content, s_xml, xmlURL, TYPE_GENERIC);
        this.generateLinkXML(state, content, s_xsl, xslURL, TYPE_GENERIC);
        if (here.getParameter("debug") == null) {
            this.generateLinkXML(state, content, s_transformOn, transformOnURL, TYPE_ENABLE);
        } else {
            this.generateLinkXML(state, content, s_transformOff, transformOffURL, TYPE_DISABLE);
        }
    }

    private void generateLinkXML(PageState state, Element parent, GlobalizedMessage msg, URL url, String type) {
        Element link = parent.newChildElement("ui:debugLink", "http://www.arsdigita.com/ui/1.0");
        link.addAttribute("title", (String)msg.localize(state.getRequest()));
        link.addAttribute("url", url.toString());
        link.addAttribute("type", type);
    }

    private URL selfURL(PageState state, URL here, String name, String value) {
        ParameterMap params = new ParameterMap(here.getParameterMap());
        params.clearParameter(name);
        if (value != null) {
            params.setParameter(name, value);
        }
        return new URL(here.getScheme(), here.getServerName(), here.getServerPort(), here.getContextPath(), here.getServletPath(), here.getPathInfo(), params);
    }
}

