/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageFactory;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.AdminSplitPanel;
import com.arsdigita.ui.admin.CreateUserPane;
import com.arsdigita.ui.admin.GroupAdministrationTab;
import com.arsdigita.ui.admin.SubsiteDispatcher;
import com.arsdigita.ui.admin.UserBrowsePane;
import com.arsdigita.ui.admin.UserSearchPane;
import com.arsdigita.ui.admin.UserSummaryPane;
import com.arsdigita.ui.util.GlobalizationUtil;

public class AdminDispatcher
extends SubsiteDispatcher
implements AdminConstants {
    public AdminDispatcher() {
        this.addPage("", this.buildAdminIndexPage(), true);
        this.addPage("denied", this.buildDeniedPage());
    }

    private Page buildDeniedPage() {
        Page p = PageFactory.buildPage("admin", new Label(new GlobalizedMessage("ui.admin.dispatcher.accessDenied", "com.arsdigita.ui.admin.AdminResources")));
        Label label = new Label(GlobalizationUtil.globalize("ui.admin.access_denied"));
        label.setClassAttr("AccessDenied");
        p.add(label);
        p.lock();
        return p;
    }

    private Page buildAdminIndexPage() {
        Page p = PageFactory.buildPage("admin", AdminConstants.PAGE_TITLE_LABEL);
        p.addGlobalStateParam(AdminConstants.USER_ID_PARAM);
        p.addGlobalStateParam(AdminConstants.GROUP_ID_PARAM);
        AdminSplitPanel userSplitPanel = new AdminSplitPanel(AdminConstants.USER_NAVBAR_TITLE);
        UserBrowsePane browsePane = new UserBrowsePane();
        userSplitPanel.addTab(AdminConstants.USER_TAB_SUMMARY, new UserSummaryPane(userSplitPanel, browsePane));
        userSplitPanel.addTab(AdminConstants.USER_TAB_BROWSE, browsePane);
        userSplitPanel.addTab(AdminConstants.USER_TAB_SEARCH, new UserSearchPane(userSplitPanel, browsePane));
        userSplitPanel.addTab(AdminConstants.USER_TAB_CREATE_USER, new CreateUserPane(userSplitPanel));
        GroupAdministrationTab groupAdministrationTab = new GroupAdministrationTab();
        TabbedPane tb = new TabbedPane();
        tb.setIdAttr("page-body");
        tb.addTab(AdminConstants.USER_TAB_TITLE, (Component)userSplitPanel);
        tb.addTab(AdminConstants.GROUP_TAB_TITLE, (Component)groupAdministrationTab);
        browsePane.setTabbedPane(tb);
        browsePane.setGroupAdministrationTab(groupAdministrationTab);
        p.add(tb);
        p.lock();
        return p;
    }
}

