/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.xml.Element;
import java.util.ArrayList;

class AdminSplitPanel
extends BoxPanel
implements ChangeListener {
    private List m_list;
    private ArrayList m_componentList;
    private ArrayList m_keys;
    private GlobalizedMessage m_title;

    public AdminSplitPanel(GlobalizedMessage title) {
        this.m_title = title;
        this.setClassAttr("sidebarNavPanel");
        this.m_componentList = new ArrayList();
        this.m_keys = new ArrayList();
    }

    public void addTab(Label label, Component c) {
        Assert.assertNotLocked(this);
        this.m_componentList.add(c);
        c.setClassAttr("main");
        this.add(c);
        this.m_keys.add(label);
    }

    public void register(Page p) {
        Assert.assertNotLocked(this);
        this.m_list = new List(new GlobalizedTabModelBuilder());
        this.m_list.addChangeListener(this);
        this.m_list.setClassAttr("navbar");
        this.add(this.m_list);
        for (int i = 0; i < this.m_componentList.size(); ++i) {
            p.setVisibleDefault((Component)this.m_componentList.get(i), false);
        }
    }

    public void stateChanged(ChangeEvent e) {
        PageState ps = e.getPageState();
        int selectedIndex = Integer.parseInt((String)this.m_list.getSelectedKey(ps));
        this.setTab(selectedIndex, ps);
    }

    public void setTab(int index, PageState ps) {
        this.m_list.setSelectedKey(ps, String.valueOf(index));
        for (int i = 0; i < this.m_componentList.size(); ++i) {
            if (i == index) {
                ((Component)this.m_componentList.get(i)).setVisible(ps, true);
                ((Resettable)this.m_componentList.get(i)).reset(ps);
                continue;
            }
            ((Component)this.m_componentList.get(i)).setVisible(ps, false);
        }
    }

    public void generateXML(PageState ps, Element parent) {
        super.generateXML(ps, parent);
        Element child = (Element)parent.getChildren().get(0);
        child.addAttribute("navbar-title", (String)this.m_title.localize(ps.getRequest()));
    }

    private class TabNameListModel
    implements ListModel {
        private int m_index = -1;
        private PageState m_pageState;

        public TabNameListModel(PageState ps) {
            this.m_pageState = ps;
        }

        public Object getElement() {
            return ((Label)AdminSplitPanel.this.m_keys.get(this.m_index)).getLabel(this.m_pageState);
        }

        public String getKey() {
            return String.valueOf(this.m_index);
        }

        public boolean next() {
            return this.m_index++ < AdminSplitPanel.this.m_keys.size() - 1;
        }
    }

    private class GlobalizedTabModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        private GlobalizedTabModelBuilder() {
        }

        public ListModel makeModel(List l, PageState state) {
            return new TabNameListModel(state);
        }
    }
}

