/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.User;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;
import java.util.Iterator;

class EmailListModelBuilder
extends LockableImpl
implements ListModelBuilder,
AdminConstants {
    EmailListModelBuilder() {
    }

    public ListModel makeModel(List l, PageState state) {
        BigDecimal userID = (BigDecimal)state.getValue(AdminConstants.USER_ID_PARAM);
        if (userID == null) {
            return null;
        }
        User user = User.retrieve(userID);
        return new EmailListModel(user.getAlternateEmails());
    }

    private class EmailListModel
    implements ListModel {
        private Iterator m_emails;
        private EmailAddress m_currentEmail;

        public EmailListModel(Iterator emails) {
            this.m_emails = emails;
        }

        public boolean next() {
            if (this.m_emails.hasNext()) {
                this.m_currentEmail = (EmailAddress)this.m_emails.next();
                return true;
            }
            return false;
        }

        public String getKey() {
            return this.m_currentEmail.getEmailAddress();
        }

        public Object getElement() {
            return this.m_currentEmail.getEmailAddress();
        }
    }
}

