/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Group;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.GroupAdministrationTab;
import com.arsdigita.ui.admin.GroupForm;
import java.math.BigDecimal;
import javax.mail.internet.InternetAddress;

class GroupAddForm
extends GroupForm
implements AdminConstants,
FormProcessListener {
    private Tree m_groupTree;
    private GroupAdministrationTab m_groupTab;

    public GroupAddForm(Tree groupTree, GroupAdministrationTab tab) {
        super("group-add-form");
        this.addProcessListener(this);
        this.m_groupTree = groupTree;
        this.m_groupTab = tab;
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState ps = e.getPageState();
        String key = (String)this.m_groupTree.getSelectedKey(ps);
        Group parentGroup = null;
        if (key != null) {
            BigDecimal parentID = new BigDecimal(key);
            try {
                parentGroup = new Group(parentID);
            }
            catch (DataObjectNotFoundException exc) {
                // empty catch block
            }
        }
        Group group = new Group();
        String name = (String)this.m_name.getValue(ps);
        group.setName(name);
        InternetAddress email = (InternetAddress)this.m_email.getValue(ps);
        if (email != null) {
            group.setPrimaryEmail(new EmailAddress(email.getAddress()));
        } else {
            group.setPrimaryEmail(null);
        }
        group.save();
        if (parentGroup != null) {
            parentGroup.addSubgroup(group);
            parentGroup.save();
        }
        if (this.m_groupTab != null) {
            this.m_groupTab.setGroup(ps, group);
        }
    }
}

