/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.GroupCollection;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.GroupAddForm;
import com.arsdigita.ui.admin.GroupEditForm;
import com.arsdigita.ui.admin.GroupInfo;
import com.arsdigita.ui.admin.GroupTreeModel;
import com.arsdigita.ui.admin.SearchAndList;
import com.arsdigita.ui.admin.SubGroupListModelBuilder;
import com.arsdigita.ui.admin.SubMemberPanel;
import com.arsdigita.ui.admin.UserSearchAndListModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class GroupAdministrationTab
extends BoxPanel
implements AdminConstants,
ChangeListener {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$ui$admin$GroupAdministrationTab == null ? (class$com$arsdigita$ui$admin$GroupAdministrationTab = GroupAdministrationTab.class$("com.arsdigita.ui.admin.GroupAdministrationTab")) : class$com$arsdigita$ui$admin$GroupAdministrationTab));
    private Tree m_tree;
    private SearchAndList m_subMemberSearch;
    private ActionLink m_addSubmemberLink;
    private Component m_groupInfoPanel;
    private Component m_subGroupPanel;
    private Component m_subMemberPanel;
    private Component m_extremeActionPanel;
    private Component m_groupAddPanel;
    private Component m_groupEditPanel;
    private Component m_groupDeleteFailedPanel;
    private ArrayList m_panelList = new ArrayList();
    private RequestLocal m_group;
    static /* synthetic */ Class class$com$arsdigita$ui$admin$GroupAdministrationTab;

    public void register(Page p) {
        for (int i = 0; i < this.m_panelList.size(); ++i) {
            p.setVisibleDefault((Component)this.m_panelList.get(i), false);
        }
        p.setVisibleDefault(this.m_groupAddPanel, true);
    }

    public Group getGroup(PageState ps) {
        return (Group)this.m_group.get(ps);
    }

    public void setGroup(PageState ps, Group group) {
        String id = group.getID().toString();
        this.m_group.set(ps, (Object)group);
        this.m_tree.setSelectedKey(ps, id);
        if (!id.equals("-1")) {
            this.expandGroups(ps, group);
            this.m_tree.expand("-1", ps);
        }
    }

    private void expandGroups(PageState ps, Group group) {
        this.m_tree.expand(group.getID().toString(), ps);
        GroupCollection superGroups = group.getSupergroups();
        Group superGroup = null;
        while (superGroups.next()) {
            superGroup = (Group)superGroups.getDomainObject();
            this.expandGroups(ps, superGroup);
        }
    }

    public GroupAdministrationTab() {
        this.setClassAttr("sidebarNavPanel");
        this.setAttribute("navbar-title", "Groups");
        this.m_group = new RequestLocal(){

            protected Object initialValue(PageState ps) {
                String key = (String)GroupAdministrationTab.this.m_tree.getSelectedKey(ps);
                Group group = null;
                if (key != null) {
                    BigDecimal id = new BigDecimal(key);
                    try {
                        group = new Group(id);
                    }
                    catch (DataObjectNotFoundException exc) {
                        // empty catch block
                    }
                }
                return group;
            }
        };
        BoxPanel c = new BoxPanel();
        c.setClassAttr("navbar");
        this.m_tree = new Tree(new GroupTreeModel());
        this.m_tree.addChangeListener(this);
        c.add(this.m_tree);
        this.add(c);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        this.m_groupInfoPanel = this.buildGroupInfoPanel(rightSide);
        this.m_panelList.add(this.m_groupInfoPanel);
        this.m_groupEditPanel = this.buildGroupEditPanel(rightSide);
        this.m_panelList.add(this.m_groupEditPanel);
        this.m_subGroupPanel = this.buildSubGroupPanel(rightSide);
        this.m_panelList.add(this.m_subGroupPanel);
        this.m_groupAddPanel = this.buildGroupAddPanel(rightSide);
        this.m_panelList.add(this.m_groupAddPanel);
        this.m_subMemberPanel = this.buildMemberListPanel(rightSide);
        this.m_panelList.add(this.m_subMemberPanel);
        this.m_extremeActionPanel = this.buildExtremeActionPanel(rightSide);
        this.m_panelList.add(this.m_extremeActionPanel);
        this.m_groupDeleteFailedPanel = this.buildGroupDeleteFailedPanel(rightSide);
        this.m_panelList.add(this.m_groupDeleteFailedPanel);
        this.add(rightSide);
    }

    public void displayAddGroupPanel(PageState ps) {
        this.hideAll(ps);
        this.m_groupAddPanel.setVisible(ps, true);
    }

    public void displayEditPanel(PageState ps) {
        this.hideAll(ps);
        this.m_groupEditPanel.setVisible(ps, true);
    }

    public void displayGroupInfoPanel(PageState ps) {
        this.showAll(ps);
        this.m_groupEditPanel.setVisible(ps, false);
        this.m_groupAddPanel.setVisible(ps, false);
        this.m_groupDeleteFailedPanel.setVisible(ps, false);
    }

    public void displayDeleteFailedPanel(PageState ps) {
        this.hideAll(ps);
        this.m_groupDeleteFailedPanel.setVisible(ps, true);
    }

    public void stateChanged(ChangeEvent e) {
        PageState ps = e.getPageState();
        String key = (String)this.m_tree.getSelectedKey(ps);
        if (key == null || key.equals("-1")) {
            this.displayAddGroupPanel(ps);
        } else {
            this.displayGroupInfoPanel(ps);
        }
        ps.setValue(AdminConstants.GROUP_ID_PARAM, new BigDecimal(key));
    }

    private Component buildGroupInfoPanel(SegmentedPanel main) {
        BoxPanel body = new BoxPanel();
        body.add(new GroupInfo(this));
        ActionLink link = new ActionLink(AdminConstants.EDIT_GROUP_LABEL);
        link.setClassAttr("actionLink");
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                GroupAdministrationTab.this.displayEditPanel(ps);
            }
        });
        body.add(link);
        return main.addSegment(AdminConstants.GROUP_INFORMATION_HEADER, (Component)body);
    }

    private Component buildGroupEditPanel(SegmentedPanel main) {
        return main.addSegment(AdminConstants.GROUP_EDIT_HEADER, (Component)new GroupEditForm(this));
    }

    private Component buildSubGroupPanel(SegmentedPanel main) {
        BoxPanel body = new BoxPanel();
        BoxPanel labelStatus = new BoxPanel(1);
        labelStatus.add(AdminConstants.SUBGROUP_COUNT_LABEL);
        Label countLabel = new Label("");
        countLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState ps = e.getPageState();
                Label t = (Label)e.getTarget();
                Group g = GroupAdministrationTab.this.getGroup(ps);
                if (g != null) {
                    t.setLabel(String.valueOf(g.countSubgroups()));
                }
            }
        });
        ActionLink status = new ActionLink(countLabel);
        status.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                String key = (String)GroupAdministrationTab.this.m_tree.getSelectedKey(ps);
                GroupAdministrationTab.this.m_tree.expand(key, ps);
            }
        });
        labelStatus.add(status);
        body.add(labelStatus);
        List subGroupList = new List(new SubGroupListModelBuilder(this));
        subGroupList.setCellRenderer(new ListCellRenderer(){

            public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
                BoxPanel b = new BoxPanel(1);
                b.add(new Label(((Group)value).getName()));
                return b;
            }
        });
        body.add(subGroupList);
        ActionLink addLink = new ActionLink(AdminConstants.ADD_SUBGROUP_LABEL);
        addLink.setClassAttr("actionLink");
        addLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                GroupAdministrationTab.this.displayAddGroupPanel(ps);
            }
        });
        body.add(addLink);
        return main.addSegment(AdminConstants.SUBGROUP_HEADER, (Component)body);
    }

    private Component buildGroupAddPanel(SegmentedPanel main) {
        return main.addSegment(AdminConstants.ADD_GROUP_LABEL, (Component)new GroupAddForm(this.m_tree, this));
    }

    private Component buildMemberListPanel(SegmentedPanel main) {
        BoxPanel body = new BoxPanel(){

            public void register(Page p) {
                p.setVisibleDefault(GroupAdministrationTab.this.m_subMemberSearch, false);
            }
        };
        body.add(new SubMemberPanel(this));
        this.m_addSubmemberLink = new ActionLink(AdminConstants.ADD_SUBMEMBER_LABEL);
        this.m_addSubmemberLink.setClassAttr("actionLink");
        this.m_addSubmemberLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                GroupAdministrationTab.this.m_addSubmemberLink.setVisible(ps, false);
                GroupAdministrationTab.this.m_subMemberSearch.setVisible(ps, true);
            }
        });
        this.m_subMemberSearch = new SearchAndList("searchsubmember");
        this.m_subMemberSearch.setListModel(new UserSearchAndListModel());
        this.m_subMemberSearch.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState ps = e.getPageState();
                String key = (String)GroupAdministrationTab.this.m_subMemberSearch.getSelectedKey(ps);
                if (key != null) {
                    BigDecimal userID = new BigDecimal(key);
                    Group group = GroupAdministrationTab.this.getGroup(ps);
                    if (group != null) {
                        try {
                            User user = User.retrieve(userID);
                            group.addMember(user);
                            group.save();
                        }
                        catch (DataObjectNotFoundException exc) {
                        }
                        catch (PersistenceException pexc) {
                            // empty catch block
                        }
                    }
                }
                GroupAdministrationTab.this.m_subMemberSearch.reset(ps);
                GroupAdministrationTab.this.m_subMemberSearch.setVisible(ps, false);
                GroupAdministrationTab.this.m_addSubmemberLink.setVisible(ps, true);
            }
        });
        body.add(this.m_subMemberSearch);
        body.add(this.m_addSubmemberLink);
        return main.addSegment(AdminConstants.SUBMEMBER_HEADER, (Component)body);
    }

    private Component buildExtremeActionPanel(SegmentedPanel main) {
        BoxPanel body = new BoxPanel();
        ActionLink deleteLink = new ActionLink(AdminConstants.DELETE_GROUP_LABEL);
        deleteLink.setClassAttr("actionLink");
        deleteLink.setConfirmation("Are you sure you want to delete this group?");
        deleteLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                Group g = (Group)GroupAdministrationTab.this.m_group.get(ps);
                if (g != null) {
                    try {
                        g.delete();
                        GroupAdministrationTab.this.m_tree.setSelectedKey(ps, "-1");
                    }
                    catch (PersistenceException exc) {
                        s_log.warn((Object)"Error deleting subgroup", (Throwable)exc);
                        GroupAdministrationTab.this.displayDeleteFailedPanel(ps);
                    }
                }
            }
        });
        body.add(deleteLink);
        return main.addSegment(AdminConstants.GROUP_EXTREME_ACTIONS_HEADER, (Component)body);
    }

    private Component buildGroupDeleteFailedPanel(SegmentedPanel main) {
        ActionLink link = new ActionLink(AdminConstants.GROUP_ACTION_CONTINUE);
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                GroupAdministrationTab.this.displayGroupInfoPanel(ps);
            }
        });
        link.setClassAttr("actionLink");
        Label label = new Label(AdminConstants.GROUP_DELETE_FAILED_MSG);
        label.setClassAttr("deleteFailedMessage");
        BoxPanel p = new BoxPanel();
        p.add(label);
        p.add(link);
        return main.addSegment(AdminConstants.GROUP_DELETE_FAILED_HEADER, (Component)p);
    }

    private void hideAll(PageState ps) {
        for (int i = 0; i < this.m_panelList.size(); ++i) {
            ((Component)this.m_panelList.get(i)).setVisible(ps, false);
        }
    }

    private void showAll(PageState ps) {
        for (int i = 0; i < this.m_panelList.size(); ++i) {
            ((Component)this.m_panelList.get(i)).setVisible(ps, true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

