/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.User;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.GroupAdministrationTab;
import com.arsdigita.ui.admin.SubMemberListModelBuilder;
import java.math.BigDecimal;

class SubMemberPanel
extends BoxPanel
implements AdminConstants {
    private List m_memberList;
    private GroupAdministrationTab m_mainTab;

    public SubMemberPanel(GroupAdministrationTab tab) {
        this.m_mainTab = tab;
        this.m_memberList = new List(new SubMemberListModelBuilder(tab));
        this.m_memberList.setCellRenderer(new ListCellRenderer(){

            public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
                BoxPanel p = new BoxPanel(1);
                Label l = new Label(((User)value).getDisplayName());
                p.add(l);
                ControlLink removeLink = new ControlLink(AdminConstants.REMOVE_SUBMEMBER_LABEL);
                removeLink.setClassAttr("actionLink");
                p.add(removeLink);
                return p;
            }
        });
        this.m_memberList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                String key = (String)SubMemberPanel.this.m_memberList.getSelectedKey(ps);
                if (key != null) {
                    BigDecimal userID = new BigDecimal(key);
                    try {
                        User user = User.retrieve(userID);
                        Group group = SubMemberPanel.this.m_mainTab.getGroup(ps);
                        if (group != null) {
                            group.removeMember(user);
                            group.save();
                        }
                    }
                    catch (DataObjectNotFoundException exc) {
                        // empty catch block
                    }
                }
            }
        });
        this.add(this.m_memberList);
    }
}

