/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.AdminSplitPanel;
import com.arsdigita.ui.admin.UserForm;
import javax.mail.internet.InternetAddress;

class UserAddForm
extends UserForm
implements FormProcessListener,
FormInitListener,
AdminConstants {
    private AdminSplitPanel m_adminPanel;

    public UserAddForm(AdminSplitPanel adminPanel) {
        super("user-add-form");
        this.m_adminPanel = adminPanel;
        this.addInitListener(this);
        this.addProcessListener(this);
        this.m_question.addValidationListener(new NotEmptyValidationListener());
        this.m_answer.addValidationListener(new NotEmptyValidationListener());
    }

    public void init(FormSectionEvent e) {
        PageState state = e.getPageState();
        this.showSecurityInfo(state);
        AdminConstants.USER_FORM_LABEL_ADDITIONAL_EMAIL_LIST.setVisible(state, false);
        this.m_emailList.setVisible(state, false);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        InternetAddress additional;
        PageState state = e.getPageState();
        User user = new User();
        String email = ((InternetAddress)this.m_primaryEmail.getValue(state)).getAddress();
        user.setPrimaryEmail(new EmailAddress(email));
        user.setScreenName((String)this.m_screenName.getValue(state));
        PersonName name = user.getPersonName();
        name.setGivenName((String)this.m_firstName.getValue(state));
        name.setFamilyName((String)this.m_lastName.getValue(state));
        String uri = (String)this.m_url.getValue(state);
        if (!uri.equals("http://") && !uri.equals("")) {
            user.setURI(uri);
        }
        if ((additional = (InternetAddress)this.m_additionalEmail.getValue(state)) != null) {
            user.addEmailAddress(new EmailAddress(additional.getAddress()));
        }
        user.save();
        UserAuthentication auth = UserAuthentication.createForUser(user);
        auth.setPassword((String)this.m_password.getValue(state));
        auth.setPasswordQuestion((String)this.m_question.getValue(state));
        auth.setPasswordAnswer((String)this.m_answer.getValue(state));
        auth.save();
        this.m_adminPanel.setTab(1, state);
    }
}

