/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.ui.admin.SearchAndListModel;
import com.arsdigita.ui.admin.Utilities;
import java.math.BigDecimal;

class UserSearchAndListModel
implements SearchAndListModel {
    private DataQuery m_query;
    private static final String USER_ID = "userID";
    private static final String SCREEN_NAME = "screenName";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private static final String EXCLUDE_GROUP_ID = "excludeGroupId";
    private static final String RETRIEVE_USERS = "com.arsdigita.kernel.RetrieveUsers";
    private BigDecimal m_excludedGroupId;

    UserSearchAndListModel() {
    }

    public void setExcludedGroupID(BigDecimal excludeId) {
        this.m_excludedGroupId = excludeId;
    }

    public void setQuery(String query) {
        StringBuffer sb = new StringBuffer();
        sb.append("searchName like lower('%");
        sb.append(Utilities.prepare(query));
        sb.append("%')");
        Session session = SessionManager.getSession();
        this.m_query = session.retrieveQuery(RETRIEVE_USERS);
        this.m_query.setParameter(EXCLUDE_GROUP_ID, this.m_excludedGroupId);
        this.m_query.addFilter(sb.toString());
    }

    public String getKey() {
        if (this.m_query == null) {
            return null;
        }
        return this.m_query.get(USER_ID).toString();
    }

    public Object getElement() {
        if (this.m_query == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_query.get(FIRST_NAME));
        sb.append(" ");
        sb.append(this.m_query.get(LAST_NAME));
        String screenName = (String)this.m_query.get(SCREEN_NAME);
        if (screenName != null) {
            sb.append(" -- ").append(screenName);
        }
        return sb.toString();
    }

    public boolean next() {
        if (this.m_query == null) {
            return false;
        }
        boolean ret = this.m_query.next();
        if (!ret) {
            this.m_query = null;
        }
        return ret;
    }
}

