/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.login;

import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.ui.login.LoginHelper;

public class PasswordValidationListener
extends NotNullValidationListener {
    public static final int MIN_LENGTH = 6;
    public static final int MIN_TYPES = 1;
    private static CharSet whites = new CharSet(){

        public boolean contains(char c) {
            return Character.isWhitespace(c);
        }
    };
    private static CharSet uppers = new CharSet(){

        public boolean contains(char c) {
            return Character.isLetter(c) && Character.isUpperCase(c);
        }
    };
    private static CharSet lowers = new CharSet(){

        public boolean contains(char c) {
            return Character.isLetter(c) && Character.isLowerCase(c);
        }
    };
    private static CharSet digits = new CharSet(){

        public boolean contains(char c) {
            return Character.isDigit(c);
        }
    };
    private static CharSet others = new CharSet(){

        public boolean contains(char c) {
            return !Character.isLetterOrDigit(c) && !Character.isISOControl(c) && !Character.isWhitespace(c);
        }
    };

    public PasswordValidationListener() {
    }

    public PasswordValidationListener(String label) {
        super(label);
    }

    public void validate(ParameterEvent e) {
        super.validate(e);
        ParameterData data = e.getParameterData();
        if (!data.isValid()) {
            return;
        }
        String password = data.getValue().toString();
        if (password.length() < 6) {
            data.addError(LoginHelper.getMessage("login.passwordValidation.minLengthError", new Object[]{new Integer(6)}));
            return;
        }
        if (PasswordValidationListener.contains(password, whites)) {
            data.addError(LoginHelper.getMessage("login.passwordValidation.whitespaceError"));
            return;
        }
        int charSets = 0;
        if (PasswordValidationListener.contains(password, uppers)) {
            ++charSets;
        }
        if (PasswordValidationListener.contains(password, lowers)) {
            ++charSets;
        }
        if (PasswordValidationListener.contains(password, digits)) {
            ++charSets;
        }
        if (PasswordValidationListener.contains(password, others)) {
            ++charSets;
        }
        if (charSets < 1) {
            data.addError(LoginHelper.getMessage("login.passwordValidation.minTypesError", new Object[]{new Integer(1)}));
            return;
        }
    }

    private static boolean contains(String s, CharSet set) {
        for (int i = 0; i < s.length(); ++i) {
            if (!set.contains(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static interface CharSet {
        public boolean contains(char var1);
    }
}

