/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.login;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.parameters.URLParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.ui.login.UserAuthenticationListener;
import com.arsdigita.ui.login.UserForm;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.ReturnSignal;
import com.arsdigita.web.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class UserEditForm
extends UserForm
implements FormProcessListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/login/UserEditForm.java#16 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$ui$login$UserEditForm == null ? (class$com$arsdigita$ui$login$UserEditForm = UserEditForm.class$("com.arsdigita.ui.login.UserEditForm")) : class$com$arsdigita$ui$login$UserEditForm));
    private UserAuthenticationListener m_listener = new UserAuthenticationListener();
    private Hidden m_returnURL;
    private RequestLocal m_user = new RequestLocal(){

        public Object initialValue(PageState ps) {
            User result;
            try {
                result = User.retrieve(UserEditForm.this.m_listener.getUser(ps).getOID());
            }
            catch (DataObjectNotFoundException e) {
                result = null;
            }
            return result;
        }
    };
    static /* synthetic */ Class class$com$arsdigita$ui$login$UserEditForm;

    public UserEditForm() {
        super("user-edit", new ColumnPanel(2), false);
        this.addProcessListener(this);
        this.m_returnURL = new Hidden(new URLParameter("return_url"));
        this.m_returnURL.setPassIn(true);
        this.add(this.m_returnURL);
    }

    public void register(Page p) {
        super.register(p);
        p.addRequestListener(this.m_listener);
    }

    protected User getUser(PageState state) throws DataObjectNotFoundException {
        return (User)this.m_user.get(state);
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        User user;
        FormData data = event.getFormData();
        PageState state = event.getPageState();
        try {
            user = this.getUser(state);
        }
        catch (DataObjectNotFoundException e) {
            throw new UncheckedWrapperException(e);
        }
        PersonName name = user.getPersonName();
        name.setGivenName((String)this.m_firstName.getValue(state));
        name.setFamilyName((String)this.m_lastName.getValue(state));
        user.setURI((String)this.m_url.getValue(state));
        user.setScreenName((String)this.m_screenName.getValue(state));
        EmailAddress oaddr = user.getPrimaryEmail();
        EmailAddress naddr = new EmailAddress(data.get("emailAddress").toString());
        if (!oaddr.equals(naddr)) {
            user.setPrimaryEmail(naddr);
            user.save();
            user.removeEmailAddress(oaddr);
        }
        user.save();
        HttpServletRequest req = state.getRequest();
        String path = Initializer.getFullURL(Initializer.WORKSPACE_PAGE_KEY, req);
        URL fallback = URL.there(req, path);
        throw new ReturnSignal(req, fallback);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

