/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.login;

import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.Password;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.EmailParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.URLParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.ui.login.LoginConstants;
import com.arsdigita.ui.login.LoginHelper;
import com.arsdigita.ui.login.PasswordValidationListener;
import com.arsdigita.util.UncheckedWrapperException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.log4j.Logger;

public abstract class UserForm
extends Form
implements LoginConstants,
FormInitListener,
FormValidationListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/login/UserForm.java#16 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$ui$login$UserForm == null ? (class$com$arsdigita$ui$login$UserForm = UserForm.class$("com.arsdigita.ui.login.UserForm")) : class$com$arsdigita$ui$login$UserForm).getName());
    private boolean m_newUser;
    protected TextField m_firstName;
    protected TextField m_lastName;
    protected TextField m_email;
    protected TextField m_screenName;
    protected Password m_password;
    protected Password m_confirm;
    protected TextField m_question;
    protected TextField m_answer;
    protected TextField m_url;
    static /* synthetic */ Class class$com$arsdigita$ui$login$UserForm;

    public UserForm(String name, Container panel, boolean newUser) {
        super(name, panel);
        this.m_newUser = newUser;
        this.setMethod("post");
        this.addInitListener(this);
        this.addValidationListener(this);
        if (this.m_newUser) {
            this.add(new Label(LoginHelper.getMessage("login.userNewForm.aboutYouSectionHeader"), false), 64);
        }
        this.m_firstName = new TextField(new StringParameter("firstname"));
        this.m_firstName.setMaxLength(60);
        this.m_firstName.setSize(20);
        this.m_firstName.addValidationListener(new NotEmptyValidationListener());
        this.m_firstName.addValidationListener(new StringLengthValidationListener(60));
        this.add(new Label(LoginConstants.FIRST_NAME));
        this.add(this.m_firstName);
        this.m_lastName = new TextField(new StringParameter("lastname"));
        this.m_lastName.setMaxLength(60);
        this.m_lastName.setSize(25);
        this.m_lastName.addValidationListener(new NotEmptyValidationListener());
        this.m_lastName.addValidationListener(new StringLengthValidationListener(60));
        this.add(new Label(LoginConstants.LAST_NAME));
        this.add(this.m_lastName);
        this.add(new Label(LoginConstants.SCREEN_NAME));
        this.m_screenName = new TextField(new StringParameter("screenName"));
        this.m_screenName.addValidationListener(new NotEmptyValidationListener());
        this.add(this.m_screenName);
        this.m_email = new TextField(new EmailParameter("emailAddress"));
        this.m_email.addValidationListener(new NotEmptyValidationListener());
        this.add(new Label(LoginConstants.PRIMARY_EMAIL));
        this.add(this.m_email);
        this.m_url = new TextField(new URLParameter("url"));
        this.m_url.setSize(50);
        this.m_url.setDefaultValue("http://");
        this.add(new Label(LoginConstants.URL));
        this.add(this.m_url);
        if (this.m_newUser) {
            this.add(new Label(LoginHelper.getMessage("login.userNewForm.securitySectionHeader"), false), 64);
            this.add(new Label(LoginHelper.getMessage("login.userNewForm.securityBlurb")), 64);
            this.add(new Label(LoginHelper.getMessage("login.userNewForm.passwordBlurb")), 64);
            this.m_password = new Password(new StringParameter("password"));
            this.m_password.addValidationListener(new PasswordValidationListener());
            this.add(new Label(LoginConstants.PASSWORD));
            this.add(this.m_password);
            this.m_confirm = new Password(new StringParameter("password_confirmation"));
            this.m_confirm.addValidationListener(new NotEmptyValidationListener());
            this.add(new Label(LoginConstants.PASSWORD_CONFIRMATION));
            this.add(this.m_confirm);
            this.add(new Label(LoginHelper.getMessage("login.userNewForm.questionBlurb")), 64);
            this.m_question = new TextField(new StringParameter("question"));
            this.m_question.setSize(30);
            this.m_question.addValidationListener(new NotEmptyValidationListener());
            this.add(new Label(LoginConstants.PASSWORD_QUESTION));
            this.add(this.m_question);
            this.m_answer = new TextField(new StringParameter("answer"));
            this.m_answer.setSize(30);
            this.m_answer.addValidationListener(new NotEmptyValidationListener());
            this.add(new Label(LoginConstants.PASSWORD_ANSWER));
            this.add(this.m_answer);
        }
        this.add(new Submit(LoginConstants.SUBMIT), 66);
    }

    public void init(FormSectionEvent event) throws FormProcessException {
        InternetAddress address;
        PageState state = event.getPageState();
        User user = null;
        try {
            user = this.getUser(state);
        }
        catch (DataObjectNotFoundException e) {
            throw new FormProcessException("Could not load User", e);
        }
        if (user == null) {
            return;
        }
        PersonName name = user.getPersonName();
        this.m_firstName.setValue(state, name.getGivenName());
        this.m_lastName.setValue(state, name.getFamilyName());
        try {
            address = new InternetAddress(user.getPrimaryEmail().toString());
        }
        catch (AddressException e) {
            throw new FormProcessException("Email address is bad: " + user.getPrimaryEmail());
        }
        this.m_email.setValue(state, address);
        this.m_screenName.setValue(state, user.getScreenName());
        this.m_url.setValue(state, user.getURI());
    }

    protected abstract User getUser(PageState var1) throws DataObjectNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        FormData data = event.getFormData();
        try {
            if (this.m_newUser) {
                String password = (String)this.m_password.getValue(state);
                String confirm = (String)this.m_confirm.getValue(state);
                if (password != null && confirm != null && !password.equals(confirm)) {
                    data.addError("password_confirmation", (String)LoginConstants.ERROR_MISMATCH_PASSWORD.localize(state.getRequest()));
                }
            }
            DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.UserPrimaryEmail");
            String email = null;
            String lowerEmail = null;
            if (this.m_email.getValue(state) != null) {
                InternetAddress address = (InternetAddress)this.m_email.getValue(state);
                email = address.getAddress();
                lowerEmail = email.toLowerCase();
            }
            String lowerScreenName = null;
            String screenName = null;
            screenName = (String)this.m_screenName.getValue(state);
            lowerScreenName = screenName.toLowerCase();
            String oldEmail = null;
            String oldScreenName = null;
            try {
                User user = this.getUser(state);
                if (user != null) {
                    oldEmail = user.getPrimaryEmail().toString();
                    oldScreenName = user.getScreenName();
                    if (null != oldScreenName) {
                        oldScreenName = oldScreenName.toLowerCase();
                    }
                }
            }
            catch (DataObjectNotFoundException e) {
                throw new UncheckedWrapperException(e);
            }
            boolean checkPrimaryEmail = KernelHelper.emailIsPrimaryIdentifier();
            Filter filter = null;
            if (checkPrimaryEmail) {
                filter = query.addFilter("lowerPrimaryEmailAddress = :email or lowerScreenName = :sn");
                filter.set("email", lowerEmail);
            } else {
                filter = query.addFilter("lowerScreenName = :sn");
            }
            filter.set("sn", lowerScreenName);
            while (query.next()) {
                if (lowerScreenName != null && !lowerScreenName.equals(oldScreenName) && lowerScreenName.equals(query.get("lowerScreenName"))) {
                    data.addError("screenName", (String)LoginConstants.ERROR_DUPLICATE_SN.localize(state.getRequest()));
                }
                if (email == null || !checkPrimaryEmail || email.equals(oldEmail) || !lowerEmail.equals(query.get("lowerPrimaryEmailAddress"))) continue;
                data.addError("emailAddress", (String)LoginConstants.ERROR_DUPLICATE_EMAIL.localize(state.getRequest()));
            }
            query.close();
            Object var14_15 = null;
            if (!this.m_newUser) return;
            if (data.isValid()) return;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (!this.m_newUser || data.isValid()) throw throwable;
            this.m_password.setValue(state, "");
            this.m_confirm.setValue(state, "");
            throw throwable;
        }
        this.m_password.setValue(state, "");
        this.m_confirm.setValue(state, "");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

