/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.login;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.URLParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.ui.login.UserForm;
import com.arsdigita.web.ReturnSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import javax.mail.internet.InternetAddress;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class UserNewForm
extends UserForm
implements FormInitListener,
FormProcessListener,
FormValidationListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/login/UserNewForm.java#19 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$ui$login$UserNewForm == null ? (class$com$arsdigita$ui$login$UserNewForm = UserNewForm.class$("com.arsdigita.ui.login.UserNewForm")) : class$com$arsdigita$ui$login$UserNewForm));
    static final String FORM_NAME = "user-new";
    private Hidden m_loginName;
    private Hidden m_returnURL;
    private Hidden m_persistent;
    static /* synthetic */ Class class$com$arsdigita$ui$login$UserNewForm;

    public UserNewForm() {
        this(new ColumnPanel(2));
    }

    protected User getUser(PageState state) throws DataObjectNotFoundException {
        return null;
    }

    public UserNewForm(Container panel) {
        super(FORM_NAME, panel, true);
        this.addInitListener(this);
        this.addValidationListener(this);
        this.addProcessListener(this);
        this.m_returnURL = new Hidden(new URLParameter("return_url"));
        this.m_returnURL.setPassIn(true);
        this.add(this.m_returnURL);
        this.m_loginName = new Hidden(new StringParameter("email"));
        this.m_loginName.setPassIn(true);
        this.add(this.m_loginName);
        ArrayParameter cookieP = new ArrayParameter("persistentCookieP");
        this.m_persistent = new Hidden(cookieP);
        this.m_persistent.setPassIn(true);
        this.add(this.m_persistent);
    }

    public void init(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        this.m_password.setValue(state, "");
        this.m_confirm.setValue(state, "");
        String loginName = (String)this.m_loginName.getValue(state);
        if (loginName != null) {
            if (KernelHelper.emailIsPrimaryIdentifier()) {
                this.m_email.setValue(state, loginName);
            } else {
                this.m_screenName.setValue(state, loginName);
            }
        }
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        InternetAddress address = (InternetAddress)this.m_email.getValue(state);
        final String email = address.getAddress();
        final String password = (String)this.m_password.getValue(state);
        final String question = (String)this.m_question.getValue(state);
        final String answer = (String)this.m_answer.getValue(state);
        final String firstName = (String)this.m_firstName.getValue(state);
        final String lastName = (String)this.m_lastName.getValue(state);
        String sn = null;
        if (!KernelHelper.emailIsPrimaryIdentifier()) {
            sn = (String)this.m_screenName.getValue(state);
        }
        final String screenName = sn;
        String url = (String)this.m_url.getValue(state);
        if ("http://".equals(url)) {
            url = null;
        }
        final String urlFinal = url;
        final Exception[] formExceptions = new Exception[]{null};
        KernelExcursion rootExcursion = new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                try {
                    User user = new User();
                    user.getPersonName().setGivenName(firstName);
                    user.getPersonName().setFamilyName(lastName);
                    user.setPrimaryEmail(new EmailAddress(email));
                    if (!KernelHelper.emailIsPrimaryIdentifier()) {
                        user.setScreenName(screenName);
                    }
                    user.setURI(urlFinal);
                    user.save();
                    PermissionService.grantPermission(new PermissionDescriptor(PrivilegeDescriptor.ADMIN, user, user));
                    UserAuthentication auth = null;
                    auth = UserAuthentication.createForUser(user);
                    auth.setPassword(password);
                    auth.setPasswordQuestion(question);
                    auth.setPasswordAnswer(answer);
                    auth.save();
                }
                catch (PersistenceException e) {
                    formExceptions[0] = e;
                }
            }
        };
        rootExcursion.run();
        if (formExceptions[0] != null) {
            throw new FormProcessException(formExceptions[0]);
        }
        try {
            String loginName = email;
            if (!KernelHelper.emailIsPrimaryIdentifier()) {
                loginName = screenName;
            }
            Web.getUserContext().login(email, password.toCharArray(), this.getPersistentLoginValue(state, false));
        }
        catch (LoginException e) {
            s_log.error((Object)"login failed for new user", (Throwable)e);
            throw new FormProcessException(e);
        }
        HttpServletRequest req = state.getRequest();
        url = Initializer.getFullURL(Initializer.WORKSPACE_PAGE_KEY, req);
        URL fallback = URL.there(req, url);
        throw new ReturnSignal(req, fallback);
    }

    protected boolean getPersistentLoginValue(PageState state, boolean defaultValue) {
        String[] values = (String[])this.m_persistent.getValue(state);
        if (values == null) {
            return defaultValue;
        }
        String persistentLoginValue = values[0];
        return "1".equals(persistentLoginValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

