/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.ObjectPermissionCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.ui.permissions.PermissionStatus;
import com.arsdigita.ui.permissions.PermissionsConstants;
import com.arsdigita.ui.permissions.PermissionsPane;
import com.arsdigita.ui.permissions.UserObjectStruct;
import com.arsdigita.ui.permissions.UserPrivilegeKey;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class PermissionsTables
implements PermissionsConstants {
    private static ParameterModel s_object_id_param = new BigDecimalParameter("po_id");
    private PermissionsPane m_parent;
    private PrivilegeDescriptor[] m_privileges;
    private SegmentedPanel[] m_permPanel = new SegmentedPanel[2];
    private int[] m_tableColumns = new int[2];
    private ActionLink m_contextLink;
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$ui$permissions$PermissionsTables == null ? (class$com$arsdigita$ui$permissions$PermissionsTables = PermissionsTables.class$("com.arsdigita.ui.permissions.PermissionsTables")) : class$com$arsdigita$ui$permissions$PermissionsTables));
    static /* synthetic */ Class class$com$arsdigita$ui$permissions$PermissionsTables;

    PermissionsTables(PermissionsPane parent) {
        this(PermissionsConstants.DEFAULT_PRIVILEGES, parent);
    }

    PermissionsTables(PrivilegeDescriptor[] privs, PermissionsPane parent) {
        this.m_parent = parent;
        this.m_privileges = privs;
        this.m_tableColumns[0] = this.m_privileges.length + 2;
        this.m_tableColumns[1] = this.m_privileges.length + 1;
        this.m_permPanel[0] = new SegmentedPanel();
        Table table = new Table((TableModelBuilder)new PermissionsTableModelBuilder(0), (Object[])this.getHeaders(0));
        table.setClassAttr("dataTable");
        this.setCellRenderers(table, 0);
        table.addTableActionListener(new DirectPermissionsTableActionListener());
        BoxPanel boxpanel = new BoxPanel();
        boxpanel.add(new Label(PermissionsConstants.PERM_TABLE_DIRECT_EXPLANATION));
        boxpanel.add(table);
        this.m_permPanel[0].addSegment(new Label(PermissionsConstants.PERM_TABLE_DIRECT_HEADING), (Component)boxpanel);
        this.m_permPanel[1] = new SegmentedPanel();
        table = new Table((TableModelBuilder)new PermissionsTableModelBuilder(1), (Object[])this.getHeaders(1));
        table.setClassAttr("dataTable");
        this.setCellRenderers(table, 1);
        boxpanel = new BoxPanel();
        boxpanel.add(new Label(PermissionsConstants.PERM_TABLE_INDIRECT_EXPLANATION));
        boxpanel.add(table);
        this.m_permPanel[1].addSegment(new Label(PermissionsConstants.PERM_TABLE_INDIRECT_HEADING), (Component)boxpanel);
    }

    SegmentedPanel getPermissions(int type) {
        return this.m_permPanel[type];
    }

    String[] getPrivileges() {
        String[] privs = new String[this.m_privileges.length];
        for (int i = 0; i < this.m_privileges.length; ++i) {
            privs[i] = this.m_privileges[i].getName();
        }
        return privs;
    }

    SimpleComponent makeContextPanel() {
        SimpleContainer contextPanel = new SimpleContainer();
        Label contextLabel = new Label();
        contextLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState s = e.getPageState();
                Label l = (Label)e.getTarget();
                ACSObject context = PermissionsTables.this.getContext(s);
                if (context != null) {
                    l.setLabel(PermissionsConstants.PERM_TABLE_INDIRECT_CONTEXT.localize(s.getRequest()) + "");
                    PermissionsTables.this.m_contextLink.setVisible(s, true);
                } else {
                    l.setLabel(PermissionsConstants.PERM_TABLE_NO_PARENT_CONTEXT.localize(s.getRequest()) + "");
                    PermissionsTables.this.m_contextLink.setVisible(s, false);
                }
            }
        });
        Label linkLabel = new Label();
        linkLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState s = e.getPageState();
                Label l = (Label)e.getTarget();
                ACSObject context = PermissionsTables.this.getContext(s);
                if (context != null) {
                    l.setLabel(context.getDisplayName());
                }
            }
        });
        this.m_contextLink = new ActionLink(linkLabel);
        this.m_contextLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
                ACSObject context = PermissionsTables.this.getContext(s);
                if (context != null) {
                    s.setValue(s_object_id_param, context.getID());
                }
            }
        });
        contextPanel.add(contextLabel);
        contextPanel.add(this.m_contextLink);
        return contextPanel;
    }

    ACSObject getContext(PageState s) {
        ACSObject obj = this.m_parent.getObject(s);
        DataObject dobj = PermissionService.getContext(obj);
        if (dobj != null) {
            OID oid = dobj.getOID();
            ACSObject context = UserObjectStruct.loadObject(oid);
            return context;
        }
        return null;
    }

    private String[] getHeaders(int type) {
        String[] headers = new String[this.m_tableColumns[type]];
        headers[0] = PermissionsConstants.PERM_TABLE_GRANTEE.localize() + "";
        for (int j = 0; j < this.m_privileges.length; ++j) {
            headers[j + 1] = this.m_privileges[j].getDisplayName();
        }
        if (type == 0) {
            headers[this.m_privileges.length + 1] = PermissionsConstants.PERM_TABLE_ACTIONS.localize() + "";
        }
        return headers;
    }

    private void setCellRenderers(Table t, int type) {
        if (type == 0) {
            int j;
            for (j = 1; j < t.getColumnModel().size() - 1; ++j) {
                t.getColumn(j).setCellRenderer(new PermissionToggleRenderer());
            }
            t.getColumn(j).setCellRenderer(new LinkRenderer());
        } else {
            for (int j = 1; j < t.getColumnModel().size(); ++j) {
                t.getColumn(j).setCellRenderer(new PermissionStatusRenderer());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class LinkRenderer
    implements TableCellRenderer {
        private LinkRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ControlLink cl = new ControlLink((String)value);
            cl.setConfirmation((String)PermissionsConstants.REMOVE_ALL_CONFIRM.localize());
            return cl;
        }
    }

    private final class PermissionStatusRenderer
    implements TableCellRenderer {
        private PermissionStatusRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Label link = new Label();
            if (((Boolean)value).booleanValue()) {
                link.setClassAttr("checkBoxGreyChecked");
            } else {
                link.setClassAttr("checkBoxGreyUnchecked");
            }
            return link;
        }
    }

    private final class PermissionToggleRenderer
    implements TableCellRenderer {
        private PermissionToggleRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ControlLink link = new ControlLink("");
            if (((Boolean)value).booleanValue()) {
                link.setClassAttr("checkBoxChecked");
            } else {
                link.setClassAttr("checkBoxUnchecked");
            }
            return link;
        }
    }

    private final class InheritedPermissionsTableModel
    extends DirectPermissionsTableModel {
        public InheritedPermissionsTableModel(ObjectPermissionCollection perm, BigDecimal id) {
            this.m_objectID = id;
            this.m_perm = perm;
            while ((this.m_more = this.m_perm.next()) && !this.m_perm.isInherited()) {
            }
        }

        public int getColumnCount() {
            return PermissionsTables.this.m_tableColumns[1];
        }

        public Object getElementAt(int columnIndex) {
            if (columnIndex == 0) {
                return this.m_currentGrantee;
            }
            if (this.userHasPermission(columnIndex - 1)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object getKeyAt(int columnIndex) {
            if (columnIndex == 0) {
                return this.m_currentGrantee;
            }
            return null;
        }

        public boolean nextRow() {
            if (this.getGranteeInfo()) {
                return true;
            }
            this.m_perm.close();
            return false;
        }

        private boolean getGranteeInfo() {
            if (!this.m_more) {
                return false;
            }
            this.m_currentGrantee = this.m_perm.getGranteeName();
            this.m_currentGranteeID = this.m_perm.getGranteeID();
            this.m_userPrivs.clear();
            while (this.m_more && this.m_perm.getGranteeName().compareTo(this.m_currentGrantee) == 0) {
                this.addPrivilege(this.m_perm.getPrivilege());
                this.m_more = this.m_perm.next();
            }
            if (this.m_userPrivs.size() > 0) {
                return true;
            }
            this.getGranteeInfo();
            return false;
        }
    }

    private class DirectPermissionsTableModel
    implements TableModel {
        ObjectPermissionCollection m_perm;
        String m_currentGrantee;
        BigDecimal m_currentGranteeID;
        BigDecimal m_objectID;
        boolean m_more;
        ArrayList m_userPrivs = new ArrayList();

        public DirectPermissionsTableModel() {
        }

        public DirectPermissionsTableModel(ObjectPermissionCollection perm, BigDecimal id) {
            this.m_objectID = id;
            this.m_perm = perm;
            this.m_more = this.m_perm.next();
        }

        public int getColumnCount() {
            return PermissionsTables.this.m_tableColumns[0];
        }

        public Object getElementAt(int columnIndex) {
            if (columnIndex == 0) {
                return this.m_currentGrantee;
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return "Remove All";
            }
            if (this.userHasPermission(columnIndex - 1)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object getKeyAt(int columnIndex) {
            if (columnIndex == 0) {
                return this.m_currentGrantee;
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return this.makeRemoveAllKey();
            }
            return new UserPrivilegeKey(this.m_objectID, this.m_currentGranteeID, PermissionsTables.this.m_privileges[columnIndex - 1].getName(), this.userHasPermission(columnIndex - 1)).toString();
        }

        public boolean nextRow() {
            if (this.getGranteeInfo()) {
                return true;
            }
            this.m_perm.close();
            return false;
        }

        boolean userHasPermission(int idx) {
            return this.m_userPrivs.contains(PermissionsTables.this.m_privileges[idx]);
        }

        private String makeRemoveAllKey() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.m_currentGranteeID.toString());
            for (int i = 0; i < PermissionsTables.this.m_privileges.length; ++i) {
                if (!this.userHasPermission(i)) continue;
                sb.append("." + PermissionsTables.this.m_privileges[i].getName());
            }
            return sb.toString();
        }

        private boolean getGranteeInfo() {
            if (!this.m_more || this.m_perm.isInherited()) {
                return false;
            }
            this.m_currentGrantee = this.m_perm.getGranteeName();
            this.m_currentGranteeID = this.m_perm.getGranteeID();
            this.m_userPrivs.clear();
            while (this.m_more && this.m_perm.getGranteeName().compareTo(this.m_currentGrantee) == 0) {
                this.addPrivilege(this.m_perm.getPrivilege());
                this.m_more = this.m_perm.next();
            }
            if (this.m_userPrivs.size() > 0) {
                return true;
            }
            this.getGranteeInfo();
            return false;
        }

        void addPrivilege(PrivilegeDescriptor priv) {
            for (int i = 0; i < PermissionsTables.this.m_privileges.length; ++i) {
                if (!PermissionsTables.this.m_privileges[i].equals(priv)) continue;
                this.m_userPrivs.add(priv);
                break;
            }
        }
    }

    private final class PermissionsTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        int m_type;

        PermissionsTableModelBuilder(int type) {
            this.m_type = type;
        }

        public TableModel makeModel(Table t, PageState s) {
            BigDecimal id = PermissionsTables.this.m_parent.getObject(s).getID();
            ObjectPermissionCollection m_perm = PermissionService.getGrantedPermissions(new OID("com.arsdigita.kernel.ACSObject", (Object)id));
            if (this.m_type == 0) {
                return new DirectPermissionsTableModel(m_perm, id);
            }
            if (this.m_type == 1) {
                return new InheritedPermissionsTableModel(m_perm, id);
            }
            return null;
        }
    }

    private class DirectPermissionsTableActionListener
    implements TableActionListener {
        private DirectPermissionsTableActionListener() {
        }

        public void cellSelected(TableActionEvent e) {
            PageState state = e.getPageState();
            int col = e.getColumn();
            String rowkey = (String)e.getRowKey();
            if (rowkey == null) {
                return;
            }
            Table table = (Table)e.getSource();
            int no_cols = table.getColumnModel().size();
            int lastCol = no_cols - 1;
            if (col > 0 && col < lastCol) {
                PermissionStatus pmds = UserPrivilegeKey.undescribe(rowkey);
                if (pmds.isGranted()) {
                    PermissionService.revokePermission(pmds.getPermissionDescriptor());
                    if (PermissionService.checkPermission(pmds.getPermissionDescriptor())) {
                        s_log.warn((Object)"Warning: Permission revoked,  but Party has still Permission through inheritance");
                    }
                } else {
                    PermissionService.grantPermission(pmds.getPermissionDescriptor());
                }
            } else if (col == lastCol) {
                String[] tokens = StringUtils.split(rowkey, '.');
                BigDecimal pID = new BigDecimal(tokens[0]);
                ACSObject obj = PermissionsTables.this.m_parent.getObject(state);
                Party party = UserObjectStruct.loadParty(pID);
                PermissionDescriptor pmd = null;
                for (int j = 1; j < tokens.length; ++j) {
                    pmd = new PermissionDescriptor(PrivilegeDescriptor.get(tokens[j]), obj, party);
                    PermissionService.revokePermission(pmd);
                }
            }
        }

        public void headSelected(TableActionEvent e) {
            throw new UnsupportedOperationException();
        }
    }
}

