/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.OID;
import com.arsdigita.ui.permissions.PermissionsConstants;
import java.math.BigDecimal;

class UserObjectStruct
implements PermissionsConstants {
    private static ParameterModel s_object_id_param = new BigDecimalParameter("po_id");
    private Party m_party;
    private ACSObject m_object;

    UserObjectStruct(PageState s) {
        this(UserObjectStruct.getParty(s), UserObjectStruct.getObject(s));
    }

    UserObjectStruct(BigDecimal partyID, BigDecimal objectID) {
        this(UserObjectStruct.loadParty(partyID), UserObjectStruct.loadObject(objectID));
    }

    UserObjectStruct(Party p, ACSObject o) {
        this.m_party = p;
        this.m_object = o;
    }

    Party getParty() {
        return this.m_party;
    }

    ACSObject getObject() {
        return this.m_object;
    }

    static ACSObject loadObject(BigDecimal id) {
        ACSObject obj = null;
        obj = (ACSObject)DomainObjectFactory.newInstance(new OID("com.arsdigita.kernel.ACSObject", (Object)id));
        return obj;
    }

    static ACSObject loadObject(OID oid) {
        ACSObject obj = null;
        obj = (ACSObject)DomainObjectFactory.newInstance(oid);
        return obj;
    }

    static Party loadParty(BigDecimal id) {
        Party party = null;
        try {
            party = User.retrieve(id);
        }
        catch (DataObjectNotFoundException e1) {
            party = new Group(id);
        }
        return party;
    }

    public static Party getParty(PageState s) {
        return Kernel.getContext().getParty();
    }

    public static ACSObject getObject(PageState s) {
        BigDecimal id = (BigDecimal)s.getValue(s_object_id_param);
        return UserObjectStruct.loadObject(id);
    }
}

