/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.sitemap;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.PackageTypeCollection;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.SiteNodeCollection;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.ui.util.GlobalizationUtil;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class DisplayActions
extends BoxPanel
implements ActionListener,
ChangeListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/sitemap/DisplayActions.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$ui$sitemap$DisplayActions == null ? (class$com$arsdigita$ui$sitemap$DisplayActions = DisplayActions.class$("com.arsdigita.ui.sitemap.DisplayActions")) : class$com$arsdigita$ui$sitemap$DisplayActions));
    private final SingleSelectionModel m_sitenodeselectionmodel;
    BoxPanel m_nodeMaintenancePanel;
    BoxPanel m_pkgMaintenancePanel;
    BoxPanel m_linkcontainer;
    private Label m_nodetitle;
    private Label m_pkgtitle;
    private String m_nodetitleString;
    private String m_pkgtitleString;
    private ToggleLink m_addSubNodeLink;
    private ToggleLink m_setPermissionsLink;
    private ToggleLink m_removeNodeLink;
    private ToggleLink m_unmountPackageLink;
    private ToggleLink m_mountPackageLink;
    private RadioGroup m_grp;
    AddSubnodeForm m_addSubnodeForm;
    RemoveNodeForm m_removeNodeForm;
    UnmountInstanceForm m_unmountInstanceForm;
    MountInstanceForm m_mountInstanceForm;
    static /* synthetic */ Class class$com$arsdigita$ui$sitemap$DisplayActions;

    public DisplayActions(SingleSelectionModel m) {
        super(2, false);
        this.m_sitenodeselectionmodel = m;
        this.m_sitenodeselectionmodel.addChangeListener(this);
        this.m_nodeMaintenancePanel = new BoxPanel(2, true);
        this.m_pkgMaintenancePanel = new BoxPanel(2, true);
        this.m_nodetitle = new Label(GlobalizationUtil.globalize("ui.sitemap.site_node"));
        this.m_nodetitle.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                Label t = (Label)e.getTarget();
                t.setLabel("Site Node: " + DisplayActions.this.m_nodetitleString);
            }
        });
        this.m_pkgtitle = new Label(GlobalizationUtil.globalize("ui.sitemap.mounted_instance"));
        this.m_pkgtitle.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                Label t = (Label)e.getTarget();
                t.setLabel("Mounted Instance: " + DisplayActions.this.m_pkgtitleString);
            }
        });
        this.m_linkcontainer = new BoxPanel(1, false);
        this.m_nodeMaintenancePanel.add(this.m_nodetitle);
        this.m_nodeMaintenancePanel.add(this.m_linkcontainer);
        this.m_pkgMaintenancePanel.add(this.m_pkgtitle);
        this.m_addSubNodeLink = new ToggleLink("[Add New Subnode]");
        this.m_setPermissionsLink = new ToggleLink("[Set Permissions]");
        this.m_removeNodeLink = new ToggleLink("[Remove This Node]");
        this.m_unmountPackageLink = new ToggleLink("[Unmount This Package Instance]");
        this.m_mountPackageLink = new ToggleLink("[Mount a new Package Instance]");
        this.m_grp = new RadioGroup("instancegroup");
        this.m_grp.setClassAttr("vertical");
        this.populateRadioGroup(this.m_grp);
        this.m_addSubNodeLink.addActionListener(new addSubnodeListener());
        this.m_removeNodeLink.addActionListener(new removeNodeListener());
        this.m_unmountPackageLink.addActionListener(new unmountPackageListener());
        this.m_mountPackageLink.addActionListener(new mountPackageListener());
        this.m_addSubnodeForm = new AddSubnodeForm();
        this.m_removeNodeForm = new RemoveNodeForm();
        this.m_unmountInstanceForm = new UnmountInstanceForm();
        this.m_mountInstanceForm = new MountInstanceForm();
        this.m_nodeMaintenancePanel.add(this.m_addSubnodeForm);
        this.m_nodeMaintenancePanel.add(this.m_removeNodeForm);
        this.m_pkgMaintenancePanel.add(this.m_unmountInstanceForm);
        this.m_pkgMaintenancePanel.add(this.m_mountInstanceForm);
        this.m_pkgMaintenancePanel.add(this.m_unmountPackageLink);
        this.m_pkgMaintenancePanel.add(this.m_mountPackageLink);
        this.m_linkcontainer.add(this.m_addSubNodeLink);
        this.m_linkcontainer.add(this.m_setPermissionsLink);
        this.m_linkcontainer.add(this.m_removeNodeLink);
        this.add(this.m_nodeMaintenancePanel);
        this.add(this.m_pkgMaintenancePanel);
    }

    public void actionPerformed(ActionEvent e) {
        s_log.debug((Object)"In actionPerformed listener method.");
    }

    public NodeState computeDefaultState(PageState p) {
        BigDecimal bd = new BigDecimal((String)this.m_sitenodeselectionmodel.getSelectedKey(p));
        try {
            SiteNode sn = new SiteNode(bd);
            this.m_nodetitleString = "Site Node: " + sn.getName();
            boolean hasChildren = false;
            boolean hasInstance = false;
            SiteNodeCollection snc = null;
            snc = sn.getChildren();
            if (!snc.isEmpty()) {
                hasChildren = true;
            }
            snc.close();
            PackageInstance pi = null;
            pi = sn.getPackageInstance();
            if (pi != null) {
                hasInstance = true;
                this.m_pkgtitleString = "Package Instance: " + pi.getName();
            } else {
                this.m_pkgtitleString = "Package Instance: None Mounted";
            }
            NodeState n = new NodeState(p, hasChildren, hasInstance);
            return n;
        }
        catch (DataObjectNotFoundException ed) {
            s_log.warn((Object)"Problem in ComputeDefaultState");
            return null;
        }
    }

    public void stateChanged(ChangeEvent e) {
        PageState s = e.getPageState();
        if (e.getSource() == this.m_sitenodeselectionmodel && this.m_sitenodeselectionmodel.isSelected(s)) {
            NodeState n = this.computeDefaultState(s);
            this.showActions(n);
        }
    }

    private void resetDefaults(PageState p) {
        this.m_addSubNodeLink.setVisible(p, false);
        this.m_addSubNodeLink.setSelected(p, false);
        this.m_setPermissionsLink.setVisible(p, false);
        this.m_setPermissionsLink.setSelected(p, false);
        this.m_unmountPackageLink.setVisible(p, false);
        this.m_unmountPackageLink.setSelected(p, false);
        this.m_mountPackageLink.setVisible(p, false);
        this.m_mountPackageLink.setSelected(p, false);
        this.m_removeNodeLink.setVisible(p, false);
        this.m_removeNodeLink.setSelected(p, false);
        this.m_mountInstanceForm.setVisible(p, false);
        this.m_unmountInstanceForm.setVisible(p, false);
        this.m_addSubnodeForm.setVisible(p, false);
        this.m_removeNodeForm.setVisible(p, false);
    }

    private void showActions(NodeState n) {
        boolean hasChildren = n.getHasChildren();
        boolean hasInstance = n.getHasInstance();
        PageState p = n.getPageState();
        this.resetDefaults(p);
        if (!hasChildren && !hasInstance) {
            this.m_addSubNodeLink.setVisible(p, true);
            this.m_setPermissionsLink.setVisible(p, true);
            this.m_removeNodeLink.setVisible(p, true);
            this.m_mountPackageLink.setVisible(p, true);
        } else if (hasChildren && !hasInstance) {
            this.m_addSubNodeLink.setVisible(p, true);
            this.m_setPermissionsLink.setVisible(p, true);
            this.m_mountPackageLink.setVisible(p, true);
        } else if (!hasChildren && hasInstance) {
            this.m_addSubNodeLink.setVisible(p, true);
            this.m_setPermissionsLink.setVisible(p, true);
            this.m_unmountPackageLink.setVisible(p, true);
        } else {
            this.m_addSubNodeLink.setVisible(p, true);
            this.m_setPermissionsLink.setVisible(p, true);
            this.m_unmountPackageLink.setVisible(p, true);
        }
    }

    private void populateRadioGroup(RadioGroup grp) {
        grp.clearOptions();
        PackageTypeCollection collection = PackageType.retrieveAll();
        while (collection.next()) {
            grp.addOption(new Option(collection.getPackageType().getKey(), collection.getPackageType().getPrettyName()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class unmountPackageListener
    implements ActionListener {
        unmountPackageListener() {
        }

        public void actionPerformed(ActionEvent event) {
            PageState p = event.getPageState();
            DisplayActions.this.m_removeNodeForm.setVisible(p, false);
            DisplayActions.this.m_setPermissionsLink.setVisible(p, false);
            DisplayActions.this.m_addSubNodeLink.setVisible(p, false);
            DisplayActions.this.m_removeNodeLink.setVisible(p, false);
            DisplayActions.this.m_unmountPackageLink.setVisible(p, false);
            DisplayActions.this.m_unmountInstanceForm.setVisible(p, true);
            DisplayActions.this.m_mountInstanceForm.setVisible(p, false);
        }
    }

    class mountPackageListener
    implements ActionListener {
        mountPackageListener() {
        }

        public void actionPerformed(ActionEvent event) {
            PageState p = event.getPageState();
            DisplayActions.this.m_removeNodeForm.setVisible(p, false);
            DisplayActions.this.m_setPermissionsLink.setVisible(p, false);
            DisplayActions.this.m_addSubNodeLink.setVisible(p, false);
            DisplayActions.this.m_removeNodeLink.setVisible(p, false);
            DisplayActions.this.m_unmountPackageLink.setVisible(p, false);
            DisplayActions.this.m_unmountInstanceForm.setVisible(p, false);
            DisplayActions.this.m_mountInstanceForm.setVisible(p, true);
        }
    }

    class removeNodeListener
    implements ActionListener {
        removeNodeListener() {
        }

        public void actionPerformed(ActionEvent event) {
            PageState p = event.getPageState();
            DisplayActions.this.m_removeNodeForm.setVisible(p, true);
            DisplayActions.this.m_setPermissionsLink.setVisible(p, false);
            DisplayActions.this.m_addSubNodeLink.setVisible(p, false);
            DisplayActions.this.m_unmountPackageLink.setVisible(p, false);
            DisplayActions.this.m_unmountInstanceForm.setVisible(p, false);
        }
    }

    class addSubnodeListener
    implements ActionListener {
        addSubnodeListener() {
        }

        public void actionPerformed(ActionEvent event) {
            PageState p = event.getPageState();
            DisplayActions.this.m_addSubnodeForm.setVisible(p, true);
            DisplayActions.this.m_setPermissionsLink.setVisible(p, false);
            DisplayActions.this.m_removeNodeLink.setVisible(p, false);
            DisplayActions.this.m_unmountPackageLink.setVisible(p, false);
            DisplayActions.this.m_unmountInstanceForm.setVisible(p, false);
        }
    }

    public class MountInstanceForm
    extends Form
    implements FormProcessListener {
        private Label instruction = new Label(GlobalizationUtil.globalize("ui.sitemap.enter_name_for_new_package_instance_in_text_field_then_select_a_package_to_mount_from_list"));
        private Submit button;
        private TextField instanceName = new TextField("instanceName");

        public MountInstanceForm() {
            super("mountinstanveform");
            this.instanceName.setDefaultValue("New Instance");
            this.instanceName.addValidationListener(new NotNullValidationListener("Choose a name for the new package instance"));
            this.button = new Submit("Mount Package");
            this.button.setButtonLabel("Mount Package");
            this.add(this.instanceName);
            this.add(this.instruction);
            this.add(this.button);
            DisplayActions.this.m_grp.addValidationListener(new NotNullValidationListener("Selecting an Instance to mount"));
            this.add(DisplayActions.this.m_grp);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            BigDecimal bd = new BigDecimal((String)DisplayActions.this.m_sitenodeselectionmodel.getSelectedKey(s));
            try {
                SiteNode sn = new SiteNode(bd);
                sn.getParent();
                String keyresult = (String)DisplayActions.this.m_grp.getValue(s);
                PackageType pt = PackageType.findByKey(keyresult);
                PackageInstance pi = pt.createInstance(this.instanceName.getValue(s).toString());
                sn.mountPackage(pi);
                sn.save();
            }
            catch (DataObjectNotFoundException ed) {
                s_log.warn((Object)"Problem in MountInstanceForm");
            }
            NodeState n = DisplayActions.this.computeDefaultState(s);
            DisplayActions.this.showActions(n);
        }
    }

    public class UnmountInstanceForm
    extends Form
    implements FormProcessListener {
        private Label instruction = new Label(GlobalizationUtil.globalize("ui.sitemap.are_you_sure_you_want_to_umount_this_instance"));
        private Submit button = new Submit("Unmount");

        public UnmountInstanceForm() {
            super("unmountinstanceform");
            this.button.setButtonLabel("Unmount");
            this.add(this.instruction);
            this.add(this.button);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            BigDecimal bd = new BigDecimal((String)DisplayActions.this.m_sitenodeselectionmodel.getSelectedKey(s));
            try {
                SiteNode sn = new SiteNode(bd);
                sn.getParent();
                sn.unMountPackage();
                sn.save();
            }
            catch (DataObjectNotFoundException ed) {
                s_log.warn((Object)"Problem in UnmountInstanceForm");
            }
            NodeState n = DisplayActions.this.computeDefaultState(s);
            DisplayActions.this.showActions(n);
        }
    }

    public class RemoveNodeForm
    extends Form
    implements FormProcessListener {
        private Label instruction = new Label(GlobalizationUtil.globalize("ui.sitemap.are_you_sure_you_want_to_remove_this_node"));
        private Submit button = new Submit("Remove Subnode");

        public RemoveNodeForm() {
            super("removenodeform");
            this.button.setButtonLabel("Remove Subnode");
            this.add(this.instruction);
            this.add(this.button);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            BigDecimal bd = new BigDecimal((String)DisplayActions.this.m_sitenodeselectionmodel.getSelectedKey(s));
            try {
                SiteNode sn = new SiteNode(bd);
                try {
                    sn.delete();
                }
                catch (PersistenceException pe) {
                    s_log.warn((Object)"Something in the DisplayAction code has gone horribly wrong...");
                }
            }
            catch (DataObjectNotFoundException ed) {
                s_log.warn((Object)"Problem in RemoveInstanceForm");
            }
            DisplayActions.this.m_sitenodeselectionmodel.clearSelection(s);
            DisplayActions.this.resetDefaults(s);
        }
    }

    public class AddSubnodeForm
    extends Form
    implements FormProcessListener {
        private TextField nodeName;
        private Label instruction = new Label(GlobalizationUtil.globalize("ui.sitemap.enter_new_node_name_in_text_field"));
        private Submit button;

        public AddSubnodeForm() {
            super("addsubnodeform");
            this.nodeName = new TextField("nodeName");
            this.nodeName.setDefaultValue("New Node");
            this.nodeName.addValidationListener(new NotNullValidationListener("Choose a name for the new site node"));
            this.button = new Submit("Create Subnode");
            this.button.setButtonLabel("Create Subnode");
            this.add(this.instruction);
            this.add(this.nodeName);
            this.add(this.button);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            BigDecimal bd = new BigDecimal((String)DisplayActions.this.m_sitenodeselectionmodel.getSelectedKey(s));
            try {
                SiteNode sn = new SiteNode(bd);
                SiteNode newnode = SiteNode.createSiteNode(this.nodeName.getValue(s).toString(), sn);
                newnode.save();
            }
            catch (DataObjectNotFoundException ed) {
                s_log.warn((Object)"Problem in AddSubnodeForm");
            }
            NodeState n = DisplayActions.this.computeDefaultState(s);
            DisplayActions.this.showActions(n);
        }
    }

    public class NodeState {
        public boolean hasChildren = false;
        public boolean hasInstance = false;
        public PageState ps;

        public NodeState(PageState s, boolean children, boolean instance) {
            this.ps = s;
            this.hasChildren = children;
            this.hasInstance = instance;
        }

        public void setHasChildren(boolean val) {
            this.hasChildren = val;
        }

        public void setHasInstance(boolean val) {
            this.hasInstance = val;
        }

        public void setPageState(PageState s) {
            this.ps = s;
        }

        public boolean getHasChildren() {
            return this.hasChildren;
        }

        public boolean getHasInstance() {
            return this.hasInstance;
        }

        public PageState getPageState() {
            return this.ps;
        }
    }
}

