/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class ConcurrentDict {
    private static final int N_BUCKETS = 64;
    private static final int BITMASK = 63;
    private static final Map[] BUCKETS = new Map[64];
    private final EntrySupplier m_supplier;

    public ConcurrentDict(EntrySupplier supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier");
        }
        this.m_supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Map dict;
        if (key == null) {
            return null;
        }
        Map map = dict = BUCKETS[key.hashCode() & 0x3F];
        synchronized (map) {
            Object value = dict.get(key);
            if (value != null) {
                return value;
            }
            if (dict.containsKey(key)) {
                return value;
            }
            Object newEntry = this.m_supplier.supply(key);
            dict.put(key, newEntry);
            return newEntry;
        }
    }

    String debugStats() {
        DecimalFormat fmt = new DecimalFormat("0.00%");
        Object[] buckets = new Pair[64];
        int total = 0;
        for (int ii = 0; ii < 64; ++ii) {
            int size = BUCKETS[ii].size();
            buckets[ii] = new Pair(ii, size);
            total += size;
        }
        Arrays.sort(buckets);
        StringBuffer sb = new StringBuffer();
        sb.append("Total size: ").append(total).append("\n");
        for (int ii = 0; ii < 64; ++ii) {
            Object pair = buckets[ii];
            sb.append(pair).append(" (");
            sb.append(fmt.format((float)((Pair)pair).size() / (float)total));
            sb.append(")\n");
        }
        return sb.toString();
    }

    static {
        for (int ii = 0; ii < 64; ++ii) {
            ConcurrentDict.BUCKETS[ii] = new HashMap();
        }
    }

    private static class Pair
    implements Comparable {
        private static final int IDX_WIDTH = Integer.toHexString(63).length();
        private static final String ZERO_PADDING = "00000000";
        private static final String SPACE_PADDING = "        ";
        private final int m_idx;
        private final int m_size;

        Pair(int idx, int size) {
            this.m_idx = idx;
            this.m_size = size;
        }

        public int compareTo(Object obj) {
            Pair other = (Pair)obj;
            if (this.m_size < other.m_size) {
                return -1;
            }
            if (this.m_size == other.m_size) {
                return 0;
            }
            return 1;
        }

        int size() {
            return this.m_size;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String hex = Integer.toHexString(this.m_idx);
            sb.append(ZERO_PADDING.substring(0, IDX_WIDTH - hex.length()));
            sb.append(hex);
            sb.append(": ");
            String size = String.valueOf(this.m_size);
            int padLength = SPACE_PADDING.length() - size.length();
            sb.append(SPACE_PADDING.substring(0, padLength));
            sb.append(size);
            return sb.toString();
        }
    }

    public static interface EntrySupplier {
        public Object supply(Object var1);
    }
}

