/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class StringUtils {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$StringUtils == null ? (class$com$arsdigita$util$StringUtils = StringUtils.class$("com.arsdigita.util.StringUtils")) : class$com$arsdigita$util$StringUtils));
    private static Perl5Util s_re = new Perl5Util();
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static Map s_entities = new HashMap();
    static /* synthetic */ Class class$com$arsdigita$util$StringUtils;
    static /* synthetic */ Class class$java$lang$String;

    private StringUtils() {
    }

    public static final boolean emptyString(String s) {
        boolean expr = s == null || s.length() == 0;
        return expr;
    }

    public static final boolean emptyString(Object o) {
        boolean expr = o == null || o instanceof String && ((String)o).length() == 0;
        return expr;
    }

    public static final String nullToEmptyString(String s) {
        return s == null ? "" : s;
    }

    public static final String quoteHtml(String s) {
        if (s != null) {
            StringBuffer result = new StringBuffer(s.length() + 10);
            block6: for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '&': {
                        result.append("&amp;");
                        continue block6;
                    }
                    case '\"': {
                        result.append("&quot;");
                        continue block6;
                    }
                    case '<': {
                        result.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        result.append("&gt;");
                        continue block6;
                    }
                    default: {
                        result.append(ch);
                    }
                }
            }
            return result.toString();
        }
        return "";
    }

    public static final String textToHtml(String s) {
        s = StringUtils.quoteHtml(s);
        s = s_re.substitute("s/\r\n\r\n/<p>/g", s);
        s = s_re.substitute("s/\n\n/<p>/g", s);
        s = s_re.substitute("s/\r\r/<p>/g", s);
        s = s_re.substitute("s/\r\n/<br>/g", s);
        s = s_re.substitute("s/\n/<br>/g", s);
        s = s_re.substitute("s/\r/<br>/g", s);
        return s;
    }

    public static final String htmlToText(String s) {
        if (s != null) {
            s = s_re.substitute("s/\n//g", s);
            s = s_re.substitute("s/\r//g", s);
            s = s_re.substitute("s/<[Pp]>/\n\n/g", s);
            s = s_re.substitute("s/<br>/\n/ig", s);
            s = s_re.substitute("s/<([^>]*)>//g", s);
            return s;
        }
        return "";
    }

    public static final String smartTextToHtml(String s) {
        ArrayList blocks = new ArrayList();
        s_re.split(blocks, "/\\r?\\n(\\r?\\n)+/", s);
        StringBuffer html = new StringBuffer("");
        Iterator i = blocks.iterator();
        while (i.hasNext()) {
            String block = (String)i.next();
            if (s_re.match("/^\\s*(___+|---+)\\s*$/", block)) {
                html.append("<hr/>");
            } else if (s_re.match("/^\\*\\s/", block)) {
                html.append(StringUtils.smartTextList("/^\\*\\s+/m", "ul", block));
            } else if (s_re.match("/^\\+\\s/", block)) {
                html.append(StringUtils.smartTextList("/^\\+\\s+/m", "ol", block));
            } else if (s_re.match("/\\w/", block)) {
                html.append("<div>\n" + StringUtils.smartTextInline(block) + "\n</div>");
            }
            html.append("\n");
        }
        return html.toString();
    }

    private static String smartTextList(String match, String type, String s) {
        ArrayList blocks = new ArrayList();
        s_re.split(blocks, match, s);
        StringBuffer list = new StringBuffer("<" + type + ">\n");
        Iterator i = blocks.iterator();
        while (i.hasNext()) {
            String block = (String)i.next();
            if ("".equals(block)) continue;
            list.append("<li>\n");
            list.append(StringUtils.smartTextInline(block));
            list.append("</li>\n");
        }
        list.append("</" + type + ">");
        return list.toString();
    }

    private static String smartTextInline(String s) {
        HashMap links = new HashMap();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Input {" + s + "}"));
        }
        s = s_re.substitute("s/\u0001|\u0002|\u0003//g", s);
        s = s_re.substitute("s|\\b1/4\\b|\u0003fraction14\u0003|gx", s);
        s = s_re.substitute("s|\\b1/2\\b|\u0003fraction12\u0003|gx", s);
        s = s_re.substitute("s|\\b3/4\\b|\u0003fraction34\u0003|gx", s);
        s = s_re.substitute("s|\\(C\\)|\u0003copyright\u0003|gx", s);
        s = s_re.substitute("s|\\(R\\)|\u0003registered\u0003|gx", s);
        s = s_re.substitute("s|\\(TM\\)|\u0003trademark\u0003|gx", s);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("After entities {" + s + "}"));
        }
        s = s_re.substitute("s|@@|\u0001|gx", s);
        s = StringUtils.smartTextReplace(new TitledLinkSubstitution(links), "@([^\\(@]+)\\(([^\\)]+)\\)", s);
        s = StringUtils.smartTextReplace(new UntitledLinkSubstitution(links), "([a-z]+:\\/\\/[^\\s,\\(\\)><]*)", s);
        s = StringUtils.smartTextReplace(new UntitledLinkSubstitution(links), "(mailto:[^\\s,\\(\\)><]*)", s);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("After links {" + s + "}"));
        }
        s = s_re.substitute("s|//|\u0001|gx", s);
        s = s_re.substitute("s|(\\W)/([^/]+)/(?!\\w)|$1<em>$2</em>|gx", s);
        s = s_re.substitute("s|\u0001|/|gx", s);
        s = s_re.substitute("s|\\*\\*|\u0001|gx", s);
        s = s_re.substitute("s|(\\W)\\*([^\\*]+)\\*(?!\\w)|$1<strong>$2</strong>|gx", s);
        s = s_re.substitute("s|\u0001|*|gx", s);
        s = s_re.substitute("s|==|\u0001|gx", s);
        s = s_re.substitute("s|(\\W)=([^=]+)=(?!\\w)|$1<code>$2</code>|gx", s);
        s = s_re.substitute("s|\u0001|=|gx", s);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("After styles {" + s + "}"));
        }
        s = s_re.substitute("s|@@|\u0001|gx", s);
        s = s_re.substitute("s|@([^\\(@]+)\\(([^\\)]+)\\)|<a href=\"$2\">$1</a>|gx", s);
        s = s_re.substitute("s|\u0001|@|gx", s);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("After links pass two {" + s + "}"));
        }
        s = StringUtils.smartTextReplace(new UnobscureSubstitution(links), "\u0002([^\u0002]+)\u0002", s);
        s = s_re.substitute("s|\u0001|@|gx", s);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("After links pass three {" + s + "}"));
        }
        s = StringUtils.smartTextReplace(new EntitySubstitution(), "\u0003([^\u0003]+)\u0003", s);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("After entities (complete) {" + s + "}"));
        }
        return s;
    }

    private static String smartTextReplace(Substitution subst, String pattern, String s) {
        Perl5Matcher matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        StringBuffer result = new StringBuffer();
        PatternMatcherInput input = new PatternMatcherInput(s);
        try {
            Util.substitute((StringBuffer)result, (PatternMatcher)matcher, (Pattern)compiler.compile(pattern), (Substitution)subst, (PatternMatcherInput)input, (int)-1);
        }
        catch (MalformedPatternException e) {
            throw new UncheckedWrapperException("cannot perform substitution", e);
        }
        return result.toString();
    }

    public static String[] split(String s, char sep) {
        ArrayList<String> al = new ArrayList<String>();
        int start_pos = 0;
        while (start_pos < s.length()) {
            int end_pos = s.indexOf(sep, start_pos);
            if (end_pos == -1) {
                end_pos = s.length();
            }
            String found_item = s.substring(start_pos, end_pos);
            al.add(found_item);
            start_pos = end_pos + 1;
        }
        if (s.length() > 0 && s.charAt(s.length() - 1) == sep) {
            al.add("");
        }
        String[] returned_array = new String[al.size()];
        al.toArray(returned_array);
        return returned_array;
    }

    public static List splitUp(String s, String re) {
        Perl5Util p5 = new Perl5Util();
        ArrayList<String> list = new ArrayList<String>();
        while (s != null && s.length() > 0) {
            if (p5.match(re, s)) {
                MatchResult result = p5.getMatch();
                if (result.beginOffset(0) > 0) {
                    list.add(s.substring(0, result.beginOffset(0)));
                }
                list.add(result.toString());
                s = s.substring(result.endOffset(0));
                continue;
            }
            list.add(s);
            s = null;
        }
        return list;
    }

    public static String join(String[] strings, char joinChar) {
        StringBuffer result = new StringBuffer();
        int lastIdx = strings.length - 1;
        for (int idx = 0; idx < strings.length; ++idx) {
            result.append(strings[idx]);
            if (idx >= lastIdx) continue;
            result.append(joinChar);
        }
        return result.toString();
    }

    public static String join(String[] strings, String joinStr) {
        StringBuffer result = new StringBuffer();
        int lastIdx = strings.length - 1;
        for (int idx = 0; idx < strings.length; ++idx) {
            result.append(strings[idx]);
            if (idx >= lastIdx) continue;
            result.append(joinStr);
        }
        return result.toString();
    }

    public static String getParameter(String key, String plist, char sep) {
        for (int key_start = 0; key_start < plist.length(); ++key_start) {
            if ((key_start = plist.indexOf(key, key_start)) == -1) {
                return null;
            }
            int key_end = key_start + key.length();
            if (plist.charAt(key_end) != '=' || key_start != 0 && plist.charAt(key_start - 1) != sep) continue;
            int value_end = plist.indexOf(sep, key_end);
            String found_value = value_end == -1 ? plist.substring(key_end + 1) : plist.substring(key_end + 1, value_end);
            return found_value;
        }
        return null;
    }

    public static String stripWhiteSpace(String s) {
        StringBuffer to = new StringBuffer();
        boolean inSpace = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean isSpace = Character.isWhitespace(c);
            if (!isSpace) {
                to.append(c);
                inSpace = false;
                continue;
            }
            if (inSpace) continue;
            to.append(' ');
            inSpace = true;
        }
        return to.toString().trim();
    }

    public static String toString(Object o) {
        try {
            return (String)o.getClass().getMethod("asString", null).invoke(o, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return o.toString();
        }
        catch (Exception e) {
            throw new UncheckedWrapperException("Invoking asString() on an " + o.getClass(), e);
        }
    }

    public static String toString(Map m) {
        StringBuffer to = new StringBuffer();
        if (m == null) {
            to.append("null");
        } else {
            to.append(m.getClass().getName());
            Set entrySet = m.entrySet();
            if (entrySet == null) {
                to.append("[null entrySet]");
            } else {
                Iterator entries = entrySet.iterator();
                if (entries == null) {
                    to.append("[null iterator]");
                } else {
                    to.append("{");
                    String comma = NEW_LINE;
                    while (entries.hasNext()) {
                        to.append(comma);
                        comma = "," + NEW_LINE;
                        Map.Entry e = entries.next();
                        to.append(StringUtils.toString(e.getKey())).append(" => ").append(StringUtils.toString(e.getValue()));
                    }
                    to.append(NEW_LINE).append("}");
                }
            }
        }
        String result = to.toString();
        return result;
    }

    public static String stripNewLines(String str) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\r' || ch == '\n') continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String addNewline(String s) {
        int n = s.length() - 1;
        if (n == -1) {
            return s;
        }
        if (Character.isWhitespace(s.charAt(n))) {
            return s;
        }
        return s.concat(NEW_LINE);
    }

    public static String truncateString(String s, int length) {
        return StringUtils.truncateString(s, length, true);
    }

    public static String truncateString(String s, int length, boolean removeHTML) {
        if (s == null) {
            return "";
        }
        String string = s;
        if (removeHTML) {
            string = StringUtils.htmlToText(string);
        }
        if (string.length() <= length) {
            return string;
        }
        return string.substring(0, string.lastIndexOf(" ", length));
    }

    public static String join(List elements, String sep) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            if (!first) {
                sb.append(sep);
            } else {
                first = false;
            }
            sb.append(element);
        }
        return sb.toString();
    }

    public static final String trimleft(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return s.substring(i);
        }
        return "";
    }

    public static final String repeat(String pattern, int repeatCount) {
        StringBuffer sb = new StringBuffer(repeatCount * pattern.length());
        for (int i = 0; i < repeatCount; ++i) {
            sb.append(pattern);
        }
        return sb.toString();
    }

    public static final String repeat(char pattern, int repeatCount) {
        return StringUtils.repeat(String.valueOf(pattern), repeatCount);
    }

    public static final String wrap(String input) {
        return StringUtils.wrap(input, 80);
    }

    public static final String wrap(String input, int maxLength) {
        String line;
        int SPACE = 32;
        int ENDL = 10;
        if (StringUtils.emptyString(input)) {
            return String.valueOf('\n');
        }
        input = input.trim() + String.valueOf('\n');
        StringBuffer output = new StringBuffer();
        int startOfLine = 0;
        while (startOfLine < input.length() && !(line = input.substring(startOfLine, Math.min(input.length(), startOfLine + maxLength))).equals("")) {
            int firstNewLine = line.indexOf(10);
            if (firstNewLine != -1) {
                output.append(input.substring(startOfLine, startOfLine + firstNewLine));
                output.append('\n');
                startOfLine += firstNewLine + 1;
                continue;
            }
            if (startOfLine + maxLength > input.length()) {
                output.append(line);
                break;
            }
            int lastSpace = line.lastIndexOf(32);
            if (lastSpace == -1) {
                int nextSpace = input.indexOf(32, startOfLine);
                int nextNewLine = input.indexOf(10, startOfLine);
                lastSpace = nextSpace == -1 ? nextNewLine : Math.min(nextSpace, nextNewLine);
                if (lastSpace == -1) {
                    output.append(input.substring(startOfLine));
                    break;
                }
                lastSpace -= startOfLine;
            }
            output.append(input.substring(startOfLine, startOfLine + lastSpace));
            output.append('\n');
            startOfLine += lastSpace + 1;
        }
        return output.toString();
    }

    public static boolean isAlphaNumeric(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static String interpolate(String text, Map vars) {
        HashSubstitution subst = new HashSubstitution(vars);
        Perl5Matcher matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        StringBuffer result = new StringBuffer();
        PatternMatcherInput input = new PatternMatcherInput(text);
        try {
            Util.substitute((StringBuffer)result, (PatternMatcher)matcher, (Pattern)compiler.compile("(::(?:\\w+(?:\\.\\w+)*)::)"), (Substitution)subst, (PatternMatcherInput)input, (int)-1);
        }
        catch (MalformedPatternException e) {
            throw new UncheckedWrapperException("cannot perform substitution", e);
        }
        return result.toString();
    }

    public static String interpolate(String text, String key, String value) {
        String pattern = "s/::" + key + "::/" + value + "/";
        return s_re.substitute(pattern, text);
    }

    public static String replace(String str, String find, String replace) {
        Assert.exists(find, class$java$lang$String == null ? (class$java$lang$String = StringUtils.class$("java.lang.String")) : class$java$lang$String);
        Assert.exists(replace, class$java$lang$String == null ? (class$java$lang$String = StringUtils.class$("java.lang.String")) : class$java$lang$String);
        if (str == null) {
            return null;
        }
        int cur = str.indexOf(find);
        if (cur < 0) {
            return str;
        }
        int findLength = find.length();
        int bufferLength = replace.length() > findLength ? (int)((double)str.length() * 1.1) : str.length();
        StringBuffer sb = new StringBuffer(bufferLength);
        int last = 0;
        if (cur == 0) {
            sb.append(replace);
            cur = str.indexOf(find, cur + findLength);
            last = findLength;
        }
        while (cur > 0) {
            sb.append(str.substring(last, cur));
            sb.append(replace);
            last = cur + findLength;
            cur = str.indexOf(find, cur + findLength);
        }
        if (last < str.length() - 1) {
            sb.append(str.substring(last));
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable");
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static List getStackList(Throwable throwable) {
        StringTokenizer tkn = new StringTokenizer(StringUtils.getStackTrace(throwable), System.getProperty("line.separator"));
        LinkedList<String> list = new LinkedList<String>();
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken().trim();
            if ("".equals(token)) continue;
            if (token.startsWith("at ")) {
                list.add(token.substring(3));
                continue;
            }
            list.add(token);
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_entities.put("fraction12", "&frac12;");
        s_entities.put("fraction14", "&frac14;");
        s_entities.put("fraction34", "&frac34;");
        s_entities.put("copyright", "&copy;");
        s_entities.put("registered", "&reg;");
        s_entities.put("trademark", "<sup>TM</sup>");
    }

    private static class HashSubstitution
    implements Substitution {
        private Map m_hash;

        public HashSubstitution(Map hash) {
            this.m_hash = hash;
        }

        public void appendSubstitution(StringBuffer appendBuffer, MatchResult match, int substitutionCount, PatternMatcherInput originalInput, PatternMatcher matcher, Pattern pattern) {
            String val;
            String placeholder = match.toString();
            String key = placeholder.substring(2, placeholder.length() - 2);
            String value = this.m_hash.containsKey(key) ? this.m_hash.get(key) : placeholder;
            try {
                PlaceholderValueGenerator gen = (PlaceholderValueGenerator)((Object)value);
                val = gen.generate(key);
            }
            catch (ClassCastException ex) {
                val = value;
            }
            appendBuffer.append(val);
        }
    }

    public static interface PlaceholderValueGenerator {
        public String generate(String var1);
    }

    private static class EntitySubstitution
    implements Substitution {
        private EntitySubstitution() {
        }

        public void appendSubstitution(StringBuffer appendBuffer, MatchResult match, int substitutionCount, PatternMatcherInput originalInput, PatternMatcher matcher, Pattern pattern) {
            String s = match.group(1);
            s_log.debug((Object)("Key: " + s));
            appendBuffer.append((String)s_entities.get(s));
            s_log.debug((Object)("Entity: " + s_entities.get(s)));
        }
    }

    private static class UnobscureSubstitution
    implements Substitution {
        private Map m_hash;

        public UnobscureSubstitution(Map hash) {
            this.m_hash = hash;
        }

        public void appendSubstitution(StringBuffer appendBuffer, MatchResult match, int substitutionCount, PatternMatcherInput originalInput, PatternMatcher matcher, Pattern pattern) {
            String s = match.group(1);
            s_log.debug((Object)("Key: " + s));
            Integer i = new Integer(s);
            appendBuffer.append((String)this.m_hash.get(i));
            s_log.debug((Object)("Link: " + this.m_hash.get(i)));
        }
    }

    private static class UntitledLinkSubstitution
    implements Substitution {
        private Map m_hash;

        public UntitledLinkSubstitution(Map hash) {
            this.m_hash = hash;
        }

        public void appendSubstitution(StringBuffer appendBuffer, MatchResult match, int substitutionCount, PatternMatcherInput originalInput, PatternMatcher matcher, Pattern pattern) {
            String link = match.group(1);
            s_log.debug((Object)("Link: " + link));
            Integer i = new Integer(this.m_hash.size());
            s_log.debug((Object)("Key: " + i));
            this.m_hash.put(i, link);
            String dst = "@\u0002" + i.toString() + "\u0002(\u0002" + i.toString() + "\u0002)";
            appendBuffer.append(dst);
            s_log.debug((Object)("Encoded Link: " + dst));
        }
    }

    private static class TitledLinkSubstitution
    implements Substitution {
        private Map m_hash;

        public TitledLinkSubstitution(Map hash) {
            this.m_hash = hash;
        }

        public void appendSubstitution(StringBuffer appendBuffer, MatchResult match, int substitutionCount, PatternMatcherInput originalInput, PatternMatcher matcher, Pattern pattern) {
            String title = match.group(1);
            String link = match.group(2);
            s_log.debug((Object)("Link: " + link));
            Integer i = new Integer(this.m_hash.size());
            s_log.debug((Object)("Key: " + i));
            this.m_hash.put(i, link);
            String dst = "@" + title + "(\u0002" + i.toString() + "\u0002)";
            appendBuffer.append(dst);
            s_log.debug((Object)("Encoded Link: " + dst));
        }
    }
}

