/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.util.ParameterProvider;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.apache.log4j.Logger;

public class URLRewriter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/URLRewriter.java#15 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$URLRewriter == null ? (class$com$arsdigita$util$URLRewriter = URLRewriter.class$("com.arsdigita.util.URLRewriter")) : class$com$arsdigita$util$URLRewriter));
    private static LinkedList s_providers = new LinkedList();
    static /* synthetic */ Class class$com$arsdigita$util$URLRewriter;

    public static void addParameterProvider(ParameterProvider provider) {
        s_log.debug((Object)("addParameterProvider: " + provider.getClass().getName()));
        s_providers.add(provider);
    }

    public static void clearParameterProviders() {
        s_providers = new LinkedList();
    }

    public static Set getGlobalModels() {
        if (s_providers.isEmpty()) {
            s_log.debug((Object)"getGlobalModels: no providers set");
            return Collections.EMPTY_SET;
        }
        HashSet rs = new HashSet();
        Iterator i = s_providers.iterator();
        while (i.hasNext()) {
            rs.addAll(((ParameterProvider)i.next()).getModels());
        }
        return rs;
    }

    public static Set getGlobalParams(HttpServletRequest req) {
        if (s_providers.isEmpty()) {
            s_log.debug((Object)"getGlobalParams: no providers set");
            return Collections.EMPTY_SET;
        }
        HashSet rs = new HashSet();
        Iterator i = s_providers.iterator();
        while (i.hasNext()) {
            rs.addAll(((ParameterProvider)i.next()).getParams(req));
        }
        return rs;
    }

    public static String encodeRedirectURL(HttpServletRequest req, HttpServletResponse resp, String url) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("encodeRedirectURL: before: " + url));
        }
        url = resp.encodeRedirectURL(URLRewriter.encodeParams(req, url));
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("encodeRedirectURL:  after: " + url));
        }
        return url;
    }

    public static String prepareURL(String url, HttpServletRequest req) {
        return URLRewriter.encodeParams(req, url);
    }

    public static String encodeURL(HttpServletRequest req, HttpServletResponse resp, String url) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("encodeURL: before: " + url));
        }
        url = resp.encodeURL(URLRewriter.encodeParams(req, url));
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("encodeURL:  after: " + url));
        }
        return url;
    }

    private static String encodeParams(HttpServletRequest req, String url) {
        if (s_providers.isEmpty()) {
            s_log.debug((Object)"encodeParams: no providers set");
            return url;
        }
        HashMap params = new HashMap();
        String base = URLRewriter.parseQueryString(url, params);
        URLRewriter.merge(URLRewriter.getGlobalParams(req), params);
        url = base + URLRewriter.unparseQueryString(params);
        return url;
    }

    private static void merge(Set data, Map params) {
        Iterator values = data.iterator();
        while (values.hasNext()) {
            Map.Entry value = (Map.Entry)values.next();
            if (value == null) continue;
            params.put(value.getKey(), value.getValue());
        }
    }

    private static String parseQueryString(String url, Map params) {
        int qmark = url.indexOf(63);
        if (qmark < 0) {
            return url;
        }
        String base = url.substring(0, qmark);
        String query = url.substring(qmark + 1);
        params.putAll(HttpUtils.parseQueryString((String)query));
        return base;
    }

    private static String unparseQueryString(Map params) {
        StringBuffer buf = new StringBuffer(128);
        int sep = 63;
        Iterator keys = params.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = params.get(key);
            if (value instanceof String[]) {
                String[] values = (String[])value;
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null) continue;
                    URLRewriter.appendParam(buf, (char)sep, key, values[i]);
                    sep = 38;
                }
                continue;
            }
            if (value == null) continue;
            URLRewriter.appendParam(buf, (char)sep, key, value.toString());
            sep = 38;
        }
        return buf.toString();
    }

    private static void appendParam(StringBuffer buf, char sep, String key, String value) {
        buf.append(sep).append(URLEncoder.encode(key)).append('=').append(URLEncoder.encode(value));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

