/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.csv;

import com.arsdigita.util.csv.CSVParameterLoader;
import com.arsdigita.util.parameter.EmailParameter;
import com.arsdigita.util.parameter.IntegerParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterValue;
import com.arsdigita.util.parameter.StringParameter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.mail.internet.InternetAddress;

public final class CSV {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/csv/CSV.java#6 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";

    public static final Object[][] load(Reader reader, Parameter[] params) {
        CSVParameterLoader loader = new CSVParameterLoader(reader, params);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (loader.next()) {
            Object[] row = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                ParameterValue value = loader.load(params[i]);
                value.getErrors().check();
                row[i] = value.getObject();
            }
            rows.add(row);
        }
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    private void example() {
        String csv = "\"Justin Ross\",8,jross@redhat.com\nRafi,999,\"rafaels@redhat.com\"\nArchit,-80,ashah@redhat.com";
        Parameter[] params = new Parameter[]{new StringParameter("name"), new IntegerParameter("number"), new EmailParameter("email")};
        Object[][] rows = CSV.load(new StringReader("\"Justin Ross\",8,jross@redhat.com\nRafi,999,\"rafaels@redhat.com\"\nArchit,-80,ashah@redhat.com"), params);
        for (int i = 0; i < rows.length; ++i) {
            Object[] row = rows[i];
            System.out.print((String)row[0]);
            System.out.print(" ");
            System.out.print((Integer)row[1]);
            System.out.print(" ");
            System.out.print((InternetAddress)row[2]);
            System.out.print("\n");
        }
    }
}

