/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.parameter;

import com.arsdigita.templating.XSLTemplate;
import com.arsdigita.util.Classes;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterContext;
import com.arsdigita.util.parameter.ParameterInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

final class ParameterPrinter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/parameter/ParameterPrinter.java#12 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$parameter$ParameterPrinter == null ? (class$com$arsdigita$util$parameter$ParameterPrinter = ParameterPrinter.class$("com.arsdigita.util.parameter.ParameterPrinter")) : class$com$arsdigita$util$parameter$ParameterPrinter));
    private static final ArrayList s_records = new ArrayList();
    private static final Options OPTIONS = new Options();
    static /* synthetic */ Class class$com$arsdigita$util$parameter$ParameterPrinter;

    ParameterPrinter() {
    }

    private static void writeXML(PrintWriter out) {
        out.write("<?xml version=\"1.0\"?>");
        out.write("<records>");
        Iterator records = s_records.iterator();
        while (records.hasNext()) {
            ParameterPrinter.writeRecord((ParameterContext)records.next(), out);
        }
        out.write("</records>");
        out.close();
    }

    private static void writeRecord(ParameterContext record, PrintWriter out) {
        out.write("<record>");
        Parameter[] params = record.getParameters();
        for (int i = 0; i < params.length; ++i) {
            ParameterPrinter.writeParameter(params[i], out);
        }
        out.write("</record>");
    }

    private static void writeParameter(Parameter param, PrintWriter out) {
        ParameterInfo info;
        out.write("<parameter>");
        ParameterPrinter.field(out, "name", param.getName());
        if (param.isRequired()) {
            out.write("<required/>");
        }
        if ((info = param.getInfo()) != null) {
            ParameterPrinter.field(out, "title", info.getTitle());
            ParameterPrinter.field(out, "purpose", info.getPurpose());
            ParameterPrinter.field(out, "example", info.getExample());
            ParameterPrinter.field(out, "format", info.getFormat());
        }
        out.write("</parameter>");
    }

    private static void field(PrintWriter out, String name, String value) {
        if (value != null) {
            out.write("<");
            out.write(name);
            out.write("><![CDATA[");
            out.write(value);
            out.write("]]></");
            out.write(name);
            out.write(">");
        }
    }

    private static void register(String classname) {
        s_records.add((ParameterContext)Classes.newInstance(classname));
    }

    public static final void main(String[] args) throws IOException {
        CommandLine line = null;
        try {
            line = new PosixParser().parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        String[] outFile = line.getArgs();
        if (outFile.length != 1) {
            System.out.println("Usage: ParameterPrinter [--html] [--file config-list-file] output-file");
            System.exit(1);
        }
        if (line.hasOption("usage")) {
            System.out.println("Usage: ParameterPrinter [--html] [--file config-list-file] output-file");
            System.exit(0);
        }
        if (line.hasOption("file")) {
            String file = line.getOptionValue("file");
            try {
                String configClass;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((configClass = reader.readLine()) != null) {
                    ParameterPrinter.register(configClass);
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
        } else {
            ParameterPrinter.register("com.arsdigita.runtime.RuntimeConfig");
            ParameterPrinter.register("com.arsdigita.web.WebConfig");
            ParameterPrinter.register("com.arsdigita.templating.TemplatingConfig");
            ParameterPrinter.register("com.arsdigita.kernel.KernelConfig");
            ParameterPrinter.register("com.arsdigita.kernel.security.SecurityConfig");
            ParameterPrinter.register("com.arsdigita.mail.MailConfig");
            ParameterPrinter.register("com.arsdigita.versioning.VersioningConfig");
            ParameterPrinter.register("com.arsdigita.search.SearchConfig");
            ParameterPrinter.register("com.arsdigita.search.lucene.LuceneConfig");
            ParameterPrinter.register("com.arsdigita.kernel.security.SecurityConfig");
            ParameterPrinter.register("com.arsdigita.bebop.BebopConfig");
            ParameterPrinter.register("com.arsdigita.dispatcher.DispatcherConfig");
            ParameterPrinter.register("com.arsdigita.workflow.simple.WorkflowConfig");
            ParameterPrinter.register("com.arsdigita.cms.ContentSectionConfig");
        }
        if (line.hasOption("html")) {
            StringWriter sout = new StringWriter();
            PrintWriter out = new PrintWriter(sout);
            ParameterPrinter.writeXML(out);
            XSLTemplate template = new XSLTemplate((class$com$arsdigita$util$parameter$ParameterPrinter == null ? (class$com$arsdigita$util$parameter$ParameterPrinter = ParameterPrinter.class$("com.arsdigita.util.parameter.ParameterPrinter")) : class$com$arsdigita$util$parameter$ParameterPrinter).getResource("ParameterPrinter_html.xsl"));
            StreamSource source = new StreamSource(new StringReader(sout.toString()));
            StreamResult result = new StreamResult(new File(outFile[0]));
            template.transform(source, result);
        } else {
            PrintWriter out = new PrintWriter(new FileWriter(outFile[0]));
            ParameterPrinter.writeXML(out);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"usage");
        OptionBuilder.withDescription((String)"Print this message");
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"html");
        OptionBuilder.withDescription((String)"Generate HTML");
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.withArgName((String)"FILE");
        OptionBuilder.withDescription((String)"Use list of additional Config classes from FILE");
        OPTIONS.addOption(OptionBuilder.create());
    }
}

