/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.servlet;

import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.servlet.HttpHost;
import com.arsdigita.util.servlet.HttpParameterMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class HttpResourceLocator {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/servlet/HttpResourceLocator.java#7 $$Author: dan $$DateTime: 2004/05/10 10:24:39 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$servlet$HttpResourceLocator == null ? (class$com$arsdigita$util$servlet$HttpResourceLocator = HttpResourceLocator.class$("com.arsdigita.util.servlet.HttpResourceLocator")) : class$com$arsdigita$util$servlet$HttpResourceLocator));
    private final HttpHost m_host;
    private final String m_contextPath;
    private final String m_servletPath;
    private final String m_pathInfo;
    private final HttpParameterMap m_params;
    static /* synthetic */ Class class$com$arsdigita$util$servlet$HttpResourceLocator;
    static /* synthetic */ Class class$com$arsdigita$util$servlet$HttpHost;
    static /* synthetic */ Class class$java$lang$String;

    public HttpResourceLocator(HttpHost host, String contextPath, String servletPath, String pathInfo, HttpParameterMap params) {
        if (Assert.isAssertEnabled()) {
            Assert.exists(host, class$com$arsdigita$util$servlet$HttpHost == null ? (class$com$arsdigita$util$servlet$HttpHost = HttpResourceLocator.class$("com.arsdigita.util.servlet.HttpHost")) : class$com$arsdigita$util$servlet$HttpHost);
            Assert.exists(contextPath, class$java$lang$String == null ? (class$java$lang$String = HttpResourceLocator.class$("java.lang.String")) : class$java$lang$String);
            Assert.exists(servletPath, class$java$lang$String == null ? (class$java$lang$String = HttpResourceLocator.class$("java.lang.String")) : class$java$lang$String);
            if (contextPath.startsWith("/")) {
                Assert.truth(!contextPath.endsWith("/"), "A contextPath starting with '/' must not end in '/'; I got '" + contextPath + "'");
            }
            if (pathInfo != null) {
                Assert.truth(pathInfo.startsWith("/"), "I expected a pathInfo starting with '/' and got '" + pathInfo + "' instead");
            }
        }
        this.m_host = host;
        this.m_contextPath = contextPath;
        this.m_servletPath = servletPath;
        this.m_pathInfo = pathInfo;
        this.m_params = params;
    }

    public HttpResourceLocator(HttpHost host, HttpServletRequest sreq, HttpParameterMap params) {
        this(host, sreq.getContextPath(), sreq.getServletPath(), sreq.getPathInfo(), params);
    }

    public HttpResourceLocator(HttpServletRequest sreq) {
        this(new HttpHost(sreq), sreq, new HttpParameterMap(sreq));
    }

    public final String toDebugString() {
        return super.toString() + " " + "[" + this.m_host + "," + this.getContextPath() + "," + this.getServletPath() + "," + this.getPathInfo() + "," + this.m_params + "]";
    }

    public final URL toURL() {
        try {
            return new URL(this.toString());
        }
        catch (MalformedURLException murle) {
            throw new UncheckedWrapperException(murle);
        }
    }

    public final HttpHost getHost() {
        return this.m_host;
    }

    public final String getContextPath() {
        return this.m_contextPath;
    }

    public final String getServletPath() {
        return this.m_servletPath;
    }

    public final String getPathInfo() {
        return this.m_pathInfo;
    }

    public final Map getParameterMap() {
        if (this.m_params == null) {
            return null;
        }
        return this.m_params.getParameterMap();
    }

    final void toString(StringBuffer buffer) {
        buffer.append("http://");
        this.m_host.toString(buffer);
        buffer.append(this.m_contextPath);
        buffer.append(this.m_servletPath);
        if (this.m_pathInfo != null) {
            buffer.append(this.m_pathInfo);
        }
        if (this.m_params != null) {
            buffer.append("?");
            this.m_params.toString(buffer);
        }
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer(96);
        this.toString(buffer);
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

