/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.url;

import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.url.URLCache;
import com.arsdigita.util.url.URLData;
import com.arsdigita.util.url.URLPool;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class URLFetcher {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$url$URLFetcher == null ? (class$com$arsdigita$util$url$URLFetcher = URLFetcher.class$("com.arsdigita.util.url.URLFetcher")) : class$com$arsdigita$util$url$URLFetcher));
    private static HashMap s_services = new HashMap();
    static /* synthetic */ Class class$com$arsdigita$util$url$URLFetcher;

    public static void registerService(String key, URLPool pool, URLCache cache) {
        URLFetcher.registerService(key, pool, cache, true);
    }

    public static void registerService(String key, URLPool pool, URLCache cache, boolean cacheFailedRetrievals) {
        Assert.assertTrue(!StringUtils.emptyString(key), "Key must not be empty!");
        CacheService cs = new CacheService(pool, cache, cacheFailedRetrievals);
        s_services.put(key, cs);
    }

    public static String fetchURL(String url, String key) {
        URLData data = URLFetcher.fetchURLData(url, key);
        if (data != null) {
            return data.getContentAsString();
        }
        return null;
    }

    public static URLData fetchURLData(String url, String key) {
        Assert.assertTrue(!StringUtils.emptyString(url), "URL must not be empty!");
        CacheService cs = URLFetcher.getService(key);
        URLData urlData = cs.cache.retrieveData(url);
        if (urlData == null) {
            urlData = cs.pool.fetchURLData(url);
            if (urlData != null && urlData.getContent() != null && urlData.getContent().length > 0) {
                cs.cache.store(url, urlData);
            } else if (cs.cacheFailedRetrievals) {
                cs.cache.store(url, urlData);
            }
            return urlData;
        }
        return urlData;
    }

    public static void purgeURL(String url, String key) {
        Assert.assertTrue(!StringUtils.emptyString(url), "URL must not be null!");
        CacheService cs = URLFetcher.getService(key);
        cs.cache.purge(url);
    }

    public boolean hasService(String key) {
        return URLFetcher.getService(key) != null;
    }

    private static CacheService getService(String key) {
        Assert.assertTrue(!StringUtils.emptyString(key), "Key must not be empty!");
        CacheService cs = (CacheService)s_services.get(key);
        return cs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class CacheService {
        final URLPool pool;
        final URLCache cache;
        final boolean cacheFailedRetrievals;

        CacheService(URLPool pool, URLCache cache, boolean cacheFailedRetrievals) {
            Assert.assertNotNull(pool, "URLPool cannot be null!");
            Assert.assertNotNull(cache, "URLCache cannot be null!");
            this.pool = pool;
            this.cache = cache;
            this.cacheFailedRetrievals = cacheFailedRetrievals;
        }
    }
}

