/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.util.AssertionError;
import com.arsdigita.versioning.Adapter;
import com.arsdigita.versioning.Constants;
import com.arsdigita.versioning.DiffSet;
import com.arsdigita.versioning.Difference;
import com.arsdigita.versioning.EventType;
import com.arsdigita.versioning.RollbackAdapter;
import com.arsdigita.versioning.RollbackListener;
import com.arsdigita.versioning.Types;
import com.arsdigita.versioning.VersioningException;
import com.arsdigita.versioning.functions;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

final class DataObjectDiff
implements Constants {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$versioning$DataObjectDiff == null ? (class$com$arsdigita$versioning$DataObjectDiff = DataObjectDiff.class$("com.arsdigita.versioning.DataObjectDiff")) : class$com$arsdigita$versioning$DataObjectDiff));
    private OID m_oid;
    private DataObject m_dataObject;
    private Map m_properties;
    private Map m_collections;
    private State m_state;
    private State m_postEnqueued;
    private RollbackListener m_listener;
    static /* synthetic */ Class class$com$arsdigita$versioning$DataObjectDiff;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$persistence$DataObject;

    public DataObjectDiff(OID oid) {
        this(oid, new RollbackAdapter());
    }

    public DataObjectDiff(OID oid, RollbackListener listener) {
        this.m_oid = oid;
        this.m_properties = new HashMap();
        this.m_state = State.ENQUEUED;
        this.m_dataObject = null;
        this.m_postEnqueued = null;
        this.m_listener = listener;
    }

    public OID getOID() {
        return this.m_oid;
    }

    public DataObject getDataObject() {
        if (this.m_dataObject == null) {
            throw new UnreifiedDataObjectException(this);
        }
        return this.m_dataObject;
    }

    public String getState() {
        return this.m_state.toString();
    }

    private Object get(String propertyName) {
        Attribute attr = (Attribute)this.m_properties.get(propertyName);
        if (attr == null) {
            throw new IllegalArgumentException("no property named " + propertyName);
        }
        return attr.getValue();
    }

    private void set(String propertyName, Object value, Types type) {
        Assert.exists(propertyName, class$java$lang$String == null ? (class$java$lang$String = DataObjectDiff.class$("java.lang.String")) : class$java$lang$String);
        this.m_listener.onUndoSet(this.m_oid, propertyName, value);
        this.m_properties.put(propertyName, new Attribute(value, type));
    }

    private Collection collection(String propertyName) {
        Collection coll;
        if (this.m_collections == null) {
            this.m_collections = new HashMap();
        }
        if ((coll = (Collection)this.m_collections.get(propertyName)) == null) {
            coll = new Collection();
            this.m_collections.put(propertyName, coll);
        }
        return coll;
    }

    private void add(String propertyName, String strValue) throws CollectionAttributeException {
        Assert.exists(propertyName, class$java$lang$String == null ? (class$java$lang$String = DataObjectDiff.class$("java.lang.String")) : class$java$lang$String);
        this.m_listener.onUndoRemove(this.m_oid, propertyName, strValue);
        try {
            this.collection(propertyName).add(new Attribute(strValue, Types.OID));
        }
        catch (CollectionAttributeException ex) {
            ex.setAttrName(propertyName);
            throw ex;
        }
    }

    private void remove(String propertyName, String strValue) throws CollectionAttributeException {
        Assert.exists(propertyName, class$java$lang$String == null ? (class$java$lang$String = DataObjectDiff.class$("java.lang.String")) : class$java$lang$String);
        this.m_listener.onUndoAdd(this.m_oid, propertyName, strValue);
        try {
            this.collection(propertyName).remove(new Attribute(strValue, Types.OID));
        }
        catch (CollectionAttributeException ex) {
            ex.setAttrName(propertyName);
            throw ex;
        }
    }

    public void reify() {
        this.checkStateBeforeReifying();
        if (this.m_state == State.ENQUEUED) {
            this.retrieveDataObject();
            this.m_state = State.REIFIED;
        } else if (this.m_state == State.UNDEAD) {
            if (this.m_postEnqueued == State.UNBORN) {
                this.retrieveDataObject();
            } else if (this.m_postEnqueued == State.UNDEAD) {
                this.createDataObject();
            } else {
                throw new AssertionError("Can't possibly get here: " + this);
            }
            this.m_state = State.REIFIED;
        } else if (this.m_state == State.UNBORN) {
            if (this.m_postEnqueued == State.UNBORN) {
                this.retrieveDataObject();
            } else if (this.m_postEnqueued != State.UNDEAD) {
                throw new AssertionError("Can't possibly get here: " + this);
            }
            this.m_state = State.TERMINAL;
        } else {
            throw new AssertionError("Can't possibly happen: " + this);
        }
    }

    private void checkStateBeforeReifying() throws AssertionError {
        if (this.m_state == State.REIFIED || this.m_state == State.TERMINAL) {
            throw new AssertionError("Can't possibly happen: " + this);
        }
        if (this.m_state == State.ENQUEUED && this.m_postEnqueued != null) {
            throw new AssertionError("m_state is ENQUEUED and m_postEnqueued is not null. What gives? " + this);
        }
        if (this.m_state != State.ENQUEUED && this.m_postEnqueued != State.UNBORN && this.m_postEnqueued != State.UNDEAD) {
            throw new AssertionError("m_state is not ENQUEUED and m_postState is " + this.m_postEnqueued + "; this=" + this);
        }
    }

    private void retrieveDataObject() {
        this.m_dataObject = SessionManager.getSession().retrieve(this.getOID());
        Assert.exists(this.m_dataObject, class$com$arsdigita$persistence$DataObject == null ? (class$com$arsdigita$persistence$DataObject = DataObjectDiff.class$("com.arsdigita.persistence.DataObject")) : class$com$arsdigita$persistence$DataObject);
    }

    private void createDataObject() {
        this.m_listener.onCreate(this.getOID());
        this.m_dataObject = SessionManager.getSession().create(this.getOID());
        Assert.truth(this.m_dataObject.isNew(), this.getOID() + " is new");
    }

    public void reifyCompoundAttributes(DiffSet diffSet) {
        Iterator values = this.m_properties.values().iterator();
        while (values.hasNext()) {
            Attribute attr = (Attribute)values.next();
            if (!attr.isCompound()) continue;
            attr.reify(diffSet);
        }
        if (this.m_collections == null) {
            return;
        }
        Iterator colls = this.m_collections.values().iterator();
        while (colls.hasNext()) {
            Collection coll = (Collection)colls.next();
            Iterator attrs = coll.attributes();
            while (attrs.hasNext()) {
                Attribute attr = (Attribute)attrs.next();
                attr.reify(diffSet);
            }
        }
    }

    public Iterator compoundAttributes() {
        LinkedList<Object> li = new LinkedList<Object>();
        Iterator values = this.m_properties.values().iterator();
        while (values.hasNext()) {
            Attribute attr = (Attribute)values.next();
            if (!attr.isCompound()) continue;
            li.add(attr.getValue());
        }
        if (this.m_collections == null) {
            return li.iterator();
        }
        Iterator colls = this.m_collections.values().iterator();
        while (colls.hasNext()) {
            Collection coll = (Collection)colls.next();
            Iterator oids = coll.oids();
            while (oids.hasNext()) {
                li.add(oids.next());
            }
        }
        return li.iterator();
    }

    public void undoEvent(DataObject op) {
        BigInteger opID = (BigInteger)op.get("id");
        EventType ev = EventType.getEventType((DataObject)op.get("eventType"));
        switch (ev.intValue()) {
            case 1: {
                this.undoCreate(op);
                break;
            }
            case 2: {
                this.undoDelete(op);
                break;
            }
            case 3: {
                this.undoAdd(op);
                break;
            }
            case 4: {
                this.undoRemove(op);
                break;
            }
            case 5: {
                this.undoSet(op);
                break;
            }
            default: {
                throw new AssertionError("can't get here: " + this);
            }
        }
    }

    private void undoCreate(DataObject op) {
        if (this.m_state != State.ENQUEUED && this.m_state != State.UNDEAD) {
            throw new AssertionError("Can't possibly happen: " + this);
        }
        if (this.m_state == State.ENQUEUED) {
            this.m_postEnqueued = State.UNBORN;
        }
        this.m_state = State.UNBORN;
    }

    private void undoDelete(DataObject op) {
        if (this.m_state != State.ENQUEUED && this.m_state != State.UNBORN) {
            throw new AssertionError("Can't possibly happen: " + this);
        }
        if (this.m_state == State.ENQUEUED) {
            this.m_postEnqueued = State.UNDEAD;
        }
        this.m_state = State.UNDEAD;
    }

    private void undoAdd(DataObject op) {
        try {
            this.remove((String)op.get("attribute"), (String)op.get("value"));
        }
        catch (CollectionAttributeException ex) {
            ex.setOperation(op);
            throw ex;
        }
    }

    private void undoRemove(DataObject op) {
        try {
            this.add((String)op.get("attribute"), (String)op.get("value"));
        }
        catch (CollectionAttributeException ex) {
            ex.setOperation(op);
            throw ex;
        }
    }

    private void undoSet(DataObject op) {
        String attr = (String)op.get("attribute");
        Object value = op.get("value");
        Types type = Types.getType((DataObject)op.get("javaclass"));
        this.set(attr, value, type);
    }

    /*
     * WARNING - void declaration
     */
    void diff(DataObjectDiff dobjDiff, Difference diff) {
        void var4_4;
        String prop;
        Difference.Change change;
        State st = dobjDiff == null ? State.ENQUEUED : dobjDiff.m_state;
        if (this.m_state == State.UNBORN && st == State.UNDEAD) {
            change = diff.create(this.m_oid);
        } else {
            if (this.m_state == State.UNBORN && st == State.UNBORN) {
                return;
            }
            if (this.m_state == State.UNBORN && st == State.ENQUEUED) {
                change = diff.create(this.m_oid);
            } else if (this.m_state == State.UNDEAD && st == State.UNBORN) {
                change = diff.delete(this.m_oid);
            } else {
                if (this.m_state == State.UNDEAD && st == State.UNDEAD) {
                    return;
                }
                if (this.m_state == State.UNDEAD && st == State.ENQUEUED) {
                    change = diff.delete(this.m_oid);
                } else if (this.m_state == State.ENQUEUED && st == State.ENQUEUED) {
                    change = diff.modify(this.m_oid);
                } else {
                    throw new IllegalStateException("bad state old: " + this.m_state + ", new: " + st);
                }
            }
        }
        Iterator it = this.m_properties.keySet().iterator();
        while (it.hasNext()) {
            prop = (String)it.next();
            var4_4.setFrom(prop, this.get(prop));
        }
        if (dobjDiff != null) {
            it = dobjDiff.m_properties.keySet().iterator();
            while (it.hasNext()) {
                prop = (String)it.next();
                var4_4.setTo(prop, dobjDiff.get(prop));
            }
        }
        if (this.m_collections == null) {
            diff.addChange((Difference.Change)var4_4);
            return;
        }
        Iterator colls = this.m_collections.entrySet().iterator();
        while (colls.hasNext()) {
            Attribute attr;
            Attribute attr2;
            Map.Entry collEntry = colls.next();
            String propertyName = (String)collEntry.getKey();
            Collection coll = (Collection)collEntry.getValue();
            java.util.Collection added = var4_4.getAdded(propertyName);
            java.util.Collection removed = var4_4.getRemoved(propertyName);
            Iterator it2 = coll.added();
            while (it2.hasNext()) {
                attr2 = (Attribute)it2.next();
                added.add(attr2.getValue());
            }
            it2 = coll.removed();
            while (it2.hasNext()) {
                attr2 = (Attribute)it2.next();
                removed.add(attr2.getValue());
            }
            if (dobjDiff == null || dobjDiff.m_collections == null || !dobjDiff.m_collections.containsKey(propertyName)) continue;
            Collection dobjDiffColl = (Collection)dobjDiff.m_collections.get(propertyName);
            Iterator it3 = dobjDiffColl.added();
            while (it3.hasNext()) {
                attr = (Attribute)it3.next();
                added.remove(attr.getValue());
            }
            it3 = dobjDiffColl.removed();
            while (it3.hasNext()) {
                attr = (Attribute)it3.next();
                removed.remove(attr.getValue());
            }
        }
        diff.addChange((Difference.Change)var4_4);
    }

    public void apply() {
        if (this.m_state == State.UNBORN) {
            this.m_state = State.PROCESSED;
            return;
        }
        if (this.m_state == State.TERMINAL) {
            return;
        }
        DataObject dobj = this.getDataObject();
        Iterator props = this.m_properties.keySet().iterator();
        while (props.hasNext()) {
            String prop = (String)props.next();
            Object value = this.get(prop);
            dobj.set(prop, value);
        }
        if (this.m_collections == null) {
            this.m_state = State.PROCESSED;
            return;
        }
        Iterator colls = this.m_collections.entrySet().iterator();
        while (colls.hasNext()) {
            Attribute attr;
            Map.Entry collEntry = colls.next();
            String propertyName = (String)collEntry.getKey();
            Collection coll = (Collection)collEntry.getValue();
            if (coll.size() == 0) continue;
            DataAssociation da = (DataAssociation)dobj.get(propertyName);
            Iterator added = coll.added();
            while (added.hasNext()) {
                attr = (Attribute)added.next();
                da.add((DataObject)attr.getValue());
            }
            Iterator removed = coll.removed();
            while (removed.hasNext()) {
                attr = (Attribute)removed.next();
                da.remove((DataObject)attr.getValue());
            }
        }
        this.m_state = State.PROCESSED;
    }

    public void deleteIfTerminal() {
        if (this.m_state == State.TERMINAL) {
            this.m_listener.onDelete(this.getOID());
            this.m_dataObject.delete();
            this.m_state = State.PROCESSED;
            return;
        }
        if (this.m_state != State.PROCESSED) {
            throw new AssertionError("Can't possibly happen: " + this);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append(Constants.LINE_SEP);
        sb.append(this.getOID()).append(Constants.LINE_SEP);
        sb.append("properties=").append(Constants.LINE_SEP);
        sb.append(functions.prettyString(this.m_properties));
        sb.append(Constants.LINE_SEP);
        sb.append("collections=").append(Constants.LINE_SEP);
        sb.append(functions.prettyStringUnsorted(this.m_collections));
        sb.append(Constants.LINE_SEP);
        sb.append("state: ");
        sb.append(this.m_state);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        DataObjectDiff that = (DataObjectDiff)obj;
        return this.getOID().equals(that.getOID());
    }

    public int hashCode() {
        return this.getOID().hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class UnreifiedDataObjectException
    extends VersioningException {
        private DataObjectDiff m_dobjDiff;

        public UnreifiedDataObjectException(DataObjectDiff dobjDiff) {
            this.m_dobjDiff = dobjDiff;
        }

        public String getMessage() {
            return "Not reified: " + this.m_dobjDiff;
        }
    }

    private static class CollectionAttributeException
    extends VersioningException {
        private final Attribute m_attr;
        private String m_attrName;
        private DataObject m_op;

        public CollectionAttributeException(Attribute attr) {
            this.m_attr = attr;
        }

        public void setAttrName(String attrName) {
            this.m_attrName = attrName;
        }

        public void setOperation(DataObject op) {
            this.m_op = op;
        }

        public String getMessage() {
            StringBuffer sb = new StringBuffer(100);
            sb.append(this.m_attrName);
            sb.append(" has already been processed.");
            sb.append(Constants.LINE_SEP).append("attr: ").append(this.m_attr);
            sb.append(Constants.LINE_SEP).append("operation: ");
            sb.append(functions.prettyString(this.m_op));
            return sb.toString();
        }
    }

    private static class State {
        String m_name;
        public static final State ENQUEUED = new State("enqueued");
        public static final State UNBORN = new State("unborn");
        public static final State UNDEAD = new State("undead");
        public static final State REIFIED = new State("reified");
        public static final State TERMINAL = new State("terminal");
        public static final State PROCESSED = new State("processed");

        private State() {
        }

        private State(String name) {
            this.m_name = name;
        }

        public String toString() {
            return this.m_name;
        }
    }

    private static class Collection {
        Map m_added = new HashMap();
        Map m_removed = new HashMap();

        public void add(Attribute attr) throws CollectionAttributeException {
            Assert.truth(attr.isCompound(), "attr.isCompound(): " + attr);
            OID oid = (OID)attr.getValue();
            if (this.m_added.containsKey(oid)) {
                throw new CollectionAttributeException(attr);
            }
            if (this.m_removed.containsKey(oid)) {
                this.m_removed.remove(oid);
            } else {
                this.m_added.put(oid, attr);
            }
        }

        public Iterator added() {
            return this.m_added.values().iterator();
        }

        public void remove(Attribute attr) throws CollectionAttributeException {
            Assert.truth(attr.isCompound(), "attr.isCompound(): " + attr);
            OID oid = (OID)attr.getValue();
            if (this.m_removed.containsKey(oid)) {
                throw new CollectionAttributeException(attr);
            }
            if (this.m_added.containsKey(oid)) {
                this.m_added.remove(oid);
            } else {
                this.m_removed.put(oid, attr);
            }
        }

        public Iterator removed() {
            return this.m_removed.values().iterator();
        }

        public Iterator oids() {
            LinkedList result = new LinkedList();
            result.addAll(this.m_added.keySet());
            result.addAll(this.m_removed.keySet());
            return result.iterator();
        }

        public Iterator attributes() {
            LinkedList result = new LinkedList();
            result.addAll(this.m_added.values());
            result.addAll(this.m_removed.values());
            return result.iterator();
        }

        public int size() {
            return this.m_added.size() + this.m_removed.size();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("added=").append(Constants.LINE_SEP);
            sb.append(functions.prettyStringUnsorted(this.m_added));
            sb.append("removed=").append(Constants.LINE_SEP);
            sb.append(functions.prettyStringUnsorted(this.m_removed));
            return sb.toString();
        }
    }

    private static class Attribute {
        private Types m_type;
        private Object m_serializedValue;
        private Object m_deserializedValue;

        public Attribute(Object serValue, Types type) {
            this.m_serializedValue = serValue;
            this.m_type = type;
        }

        public Object getValue() {
            if (Types.VOID.equals(this.m_type)) {
                return null;
            }
            if (Types.BLOB.equals(this.m_type)) {
                return this.m_serializedValue;
            }
            if (this.m_deserializedValue == null) {
                this.m_deserializedValue = Adapter.deserialize((String)this.m_serializedValue, this.m_type);
            }
            return this.m_deserializedValue;
        }

        public void reify(DiffSet diffSet) {
            this.m_deserializedValue = diffSet.get((OID)this.getValue()).getDataObject();
        }

        public boolean isCompound() {
            return Types.OID.equals(this.m_type);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.m_type).append(":").append(Constants.LINE_SEP);
            sb.append("serialized=").append(this.m_serializedValue).append(Constants.LINE_SEP);
            sb.append("deserialized=").append(this.getValue());
            return sb.toString();
        }
    }
}

