/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.Initializer;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class EventType {
    private static final Map s_types = new HashMap(5);
    private DataObject m_dobj;
    public static final int CREATE_SWITCH = 1;
    public static final EventType CREATE = EventType.newEventType(1, "create");
    public static final int DELETE_SWITCH = 2;
    public static final EventType DELETE = EventType.newEventType(2, "delete");
    public static final int ADD_SWITCH = 3;
    public static final EventType ADD = EventType.newEventType(3, "add");
    public static final int REMOVE_SWITCH = 4;
    public static final EventType REMOVE = EventType.newEventType(4, "remove");
    public static final int SET_SWITCH = 5;
    public static final EventType SET = EventType.newEventType(5, "set");
    private static final String DATA_TYPE = "com.arsdigita.versioning.EventType";
    private final BigInteger m_id;
    private final String m_name;

    private EventType(BigInteger id, String name) {
        this.m_id = id;
        this.m_name = name;
    }

    private static EventType newEventType(int id, String name) {
        BigInteger iid = new BigInteger(String.valueOf(id));
        EventType result = new EventType(iid, name);
        s_types.put(iid, result);
        return result;
    }

    static void initialize() {
        if (Initializer.hasRun()) {
            throw new IllegalStateException("can't be called more than once");
        }
        Iterator ii = s_types.values().iterator();
        while (ii.hasNext()) {
            EventType type = (EventType)ii.next();
            type.getDataObject();
        }
    }

    synchronized DataObject getDataObject() {
        if (this.m_dobj == null) {
            this.m_dobj = SessionManager.getSession().retrieve(new OID(DATA_TYPE, (Object)this.m_id));
            this.m_dobj.disconnect();
        }
        return this.m_dobj;
    }

    static EventType getEventType(DataObject ev) {
        BigInteger id = (BigInteger)ev.get("id");
        Assert.truth(s_types.containsKey(id), "s_types.contains(id)");
        return (EventType)s_types.get(id);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    int intValue() {
        return this.m_id.intValue();
    }

    public int hashCode() {
        return this.intValue();
    }

    public String toString() {
        return this.m_name;
    }
}

