/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

final class QueueMap {
    private List m_list = new ArrayList();
    private Map m_map = new HashMap();
    private int m_next = 0;

    public void enqueue(Object key, Object value) throws AlreadyEnqueuedException {
        if (this.m_map.containsKey(key)) {
            throw new AlreadyEnqueuedException(key);
        }
        this.m_map.put(key, value);
        this.m_list.add(value);
    }

    public Object dequeue() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_list.get(this.m_next++);
    }

    public Object get(Object key) {
        return this.m_map.get(key);
    }

    public boolean hasNext() {
        return this.m_next < this.m_list.size();
    }

    public void rewind() {
        this.m_next = 0;
    }

    public boolean contains(Object key) {
        return this.m_map.containsKey(key);
    }

    static class AlreadyEnqueuedException
    extends IllegalArgumentException {
        private String m_msg;

        public AlreadyEnqueuedException(Object key) {
            StringBuffer sb = new StringBuffer();
            sb.append("The key ").append(key);
            sb.append(" has already been enqueued.");
            this.m_msg = sb.toString();
        }

        public String getMessage() {
            return this.m_msg;
        }
    }
}

