/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.versioning.RollbackListener;
import com.arsdigita.versioning.VersioningServlet;
import com.arsdigita.versioning.Versions;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigInteger;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

final class RollerBacker
implements VersioningServlet.RollbackLogger {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$versioning$RollerBacker == null ? (class$com$arsdigita$versioning$RollerBacker = RollerBacker.class$("com.arsdigita.versioning.RollerBacker")) : class$com$arsdigita$versioning$RollerBacker));
    private final OID m_oid;
    private final BigInteger m_txnID;
    private final RLImpl m_rbl;
    static /* synthetic */ Class class$com$arsdigita$versioning$RollerBacker;

    RollerBacker(OID oid, BigInteger txnID) {
        this.m_oid = oid;
        this.m_txnID = txnID;
        this.m_rbl = new RLImpl();
    }

    public OID getOID() {
        return this.m_oid;
    }

    public BigInteger getTxnID() {
        return this.m_txnID;
    }

    public void setWriter(Writer writer) {
        this.m_rbl.setWriter(writer);
    }

    public void rollback() {
        if (this.m_rbl.getWriter() == null) {
            throw new IllegalStateException("no writer");
        }
        Versions.rollback(this.m_oid, this.m_txnID, this.m_rbl);
    }

    public void printException(Throwable throwable) throws ServletException {
        PrintWriter writer = new PrintWriter(this.m_rbl.getWriter(), true);
        writer.println("");
        writer.println("-----====== EXCEPTION RAISED ======------");
        writer.println("");
        writer.println("Last event logged at at:");
        this.m_rbl.getLastStack().printStackTrace(writer);
        writer.println("");
        writer.println("Exception raised:");
        throwable.printStackTrace(writer);
        writer.close();
        throw new ServletException(throwable);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RLImpl
    implements RollbackListener {
        static final String LINESEP = System.getProperty("line.separator");
        static final String INDENT = "  ";
        private final Throwable m_throwable = new Throwable();
        private int m_level = 0;
        private Writer m_writer;

        public void setWriter(Writer writer) {
            this.m_writer = writer;
        }

        public Writer getWriter() {
            return this.m_writer;
        }

        private RLImpl indent(Object msg) {
            if (s_log.isDebugEnabled()) {
                s_log.debug(msg);
            }
            try {
                for (int ii = 0; ii < this.m_level; ++ii) {
                    this.m_writer.write(INDENT);
                }
                this.m_writer.write(String.valueOf(msg));
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("can't write", ex);
            }
            return this;
        }

        private RLImpl indentln(Object msg) {
            if (s_log.isDebugEnabled()) {
                s_log.debug(msg);
            }
            return this.indent(msg).writeln("");
        }

        private RLImpl deeperIndent(Object msg) {
            return this.write(INDENT).indent(msg);
        }

        private RLImpl write(Object msg) {
            try {
                this.m_writer.write(String.valueOf(msg));
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("can't write", ex);
            }
            return this;
        }

        private RLImpl writeln(Object msg) {
            try {
                this.m_writer.write(String.valueOf(msg));
                this.m_writer.write(LINESEP);
                this.m_throwable.fillInStackTrace();
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("Can't write", ex);
            }
            return this;
        }

        public Throwable getLastStack() {
            return this.m_throwable;
        }

        public void onStart() {
            this.indentln("onStart");
            ++this.m_level;
        }

        public void onFinish() {
            --this.m_level;
            this.indentln("onFinish: ");
        }

        public void onEnqueue(OID oid) {
            this.indent("onEnqueue: ").writeln(oid);
        }

        public void onDequeue(OID oid) {
            this.indent("onDequeue: ").writeln(oid);
        }

        public void onUndoSet(OID oid, String property, Object value) {
            this.deeperIndent("onUndoSet: oid=").write(oid);
            this.write(", property=").write(property);
            this.write(", value=").writeln(value);
        }

        public void onUndoAdd(OID oid, String property, Object value) {
            this.deeperIndent("onUndoAdd: oid=").write(oid);
            this.write(", property=").write(property);
            this.write(", value=").writeln(value);
        }

        public void onUndoRemove(OID oid, String property, Object value) {
            this.indent("onUndoRemove: oid=").write(oid).write(", property=");
            this.write(property).writeln(", value=" + value);
        }

        public void onDiffStart() {
            this.indentln("onDiffStart");
            ++this.m_level;
        }

        public void onDiffFinish() {
            --this.m_level;
            this.indentln("onDiffFinish");
        }

        public void onReifyStart() {
            this.indentln("onReifyStart");
            ++this.m_level;
        }

        public void onReifyFinish() {
            --this.m_level;
            this.indentln("onReifyFinish");
        }

        public void onReifyStart(OID oid, String state) {
            this.indent("onReifyStart: oid=").write(oid).write(", state=");
            this.writeln(state);
        }

        public void onReifyFinish(OID oid, String state) {
            this.indent("onReifyFinish: oid=").write(oid).write(", state=");
            this.writeln(state);
        }

        public void onApplyStart() {
            this.indentln("onApplyStart");
            ++this.m_level;
        }

        public void onApplyFinish() {
            --this.m_level;
            this.indentln("onApplyFinish");
        }

        public void onApplyStart(OID oid, String state) {
            this.indent("onApplyStart, oid=").write(oid).write(", state=");
            this.writeln(state);
        }

        public void onApplyFinish(OID oid) {
            this.indent("onApplyFinish, oid=").writeln(oid);
        }

        public void onSet(OID oid, String property, Object value) {
            this.deeperIndent("onSet: oid=").write(oid).write(", property=");
            this.write(property).write(", value=").writeln(value);
        }

        public void onAdd(OID oid, String property, Object value) {
            this.deeperIndent("onAdd: oid=").write(oid).write(", property=");
            this.write(property).write(", value=").writeln(value);
        }

        public void onRemove(OID oid, String property, Object value) {
            this.deeperIndent("onRemove: oid=").write(oid).write(", property=");
            this.write(property).write(", value=").writeln(value);
        }

        public void onTerminalStart() {
            this.indentln("onTerminalStart");
            ++this.m_level;
        }

        public void onTerminalFinish() {
            --this.m_level;
            this.indentln("onTerminalFinish");
        }

        public void onDelete(OID oid) {
            this.deeperIndent("onDelete: oid=").writeln(oid);
        }

        public void onCreate(OID oid) {
            this.deeperIndent("onCreate: oid=").writeln(oid);
        }
    }
}

