/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.versioning.TagCollection;
import java.math.BigInteger;
import java.util.Date;

public class Transaction {
    private DataObject m_txn;
    private DataAssociation m_tags;

    public static Transaction retrieve(BigInteger id) {
        Session ssn = SessionManager.getSession();
        return new Transaction(ssn.retrieve(new OID("com.arsdigita.versioning.Txn", (Object)id)));
    }

    Transaction(DataObject txn) {
        this.m_txn = txn;
        this.m_tags = (DataAssociation)this.m_txn.get("tags");
    }

    public BigInteger getID() {
        return (BigInteger)this.m_txn.get("id");
    }

    public TagCollection getTags() {
        return new TagCollection(this.m_tags.cursor());
    }

    public User getUser() {
        DataObject user = (DataObject)this.m_txn.get("modUser");
        return (User)DomainObjectFactory.newInstance(user);
    }

    public Date getTimestamp() {
        return (Date)this.m_txn.get("timestamp");
    }

    public String getIP() {
        return (String)this.m_txn.get("modifyingIP");
    }

    public String toString() {
        return this.m_txn.toString();
    }
}

