/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.SimpleType;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.Initializer;
import com.arsdigita.versioning.UnknownTypeException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class Types {
    private static final String DATA_TYPE = "com.arsdigita.versioning.JavaClass";
    private static final Map s_typesByName = new HashMap();
    private static final Map s_typesByID = new HashMap();
    public static final Types VOID = Types.newType(0, "java.lang.Void");
    public static final Types BIG_DECIMAL = Types.newType(1, "java.math.BigDecimal");
    public static final Types BIG_INTEGER = Types.newType(2, "java.math.BigInteger");
    public static final Types BLOB = Types.newType(3, "byte[]");
    public static final Types BOOLEAN = Types.newType(4, "java.lang.Boolean");
    public static final Types BYTE = Types.newType(5, "java.lang.Byte");
    public static final Types CHARACTER = Types.newType(6, "java.lang.Character");
    public static final Types DATE = Types.newType(7, "java.util.Date");
    public static final Types DOUBLE = Types.newType(8, "java.lang.Double");
    public static final Types FLOAT = Types.newType(9, "java.lang.Float");
    public static final Types INTEGER = Types.newType(10, "java.lang.Integer");
    public static final Types LONG = Types.newType(11, "java.lang.Long");
    public static final Types OID = Types.newType(12, "com.arsdigita.persistence.OID");
    public static final Types SHORT = Types.newType(13, "java.lang.Short");
    public static final Types STRING = Types.newType(14, "java.lang.String");
    public static final Types TIMESTAMP = Types.newType(15, "java.sql.Timestamp");
    private BigInteger m_id;
    private String m_name;
    private DataObject m_dobj;
    static /* synthetic */ Class class$java$lang$Class;

    private Types(BigInteger id, String name) {
        this.m_name = name;
        this.m_id = id;
    }

    public BigInteger getID() {
        return this.m_id;
    }

    public synchronized DataObject getDataObject() {
        if (this.m_dobj == null) {
            this.m_dobj = SessionManager.getSession().retrieve(new OID(DATA_TYPE, (Object)this.m_id));
            this.m_dobj.disconnect();
        }
        return this.m_dobj;
    }

    private static Types newType(int id, String name) {
        if (s_typesByName.containsKey(name)) {
            throw new IllegalArgumentException("s_typesByName already contains " + name);
        }
        BigInteger biID = new BigInteger(String.valueOf(id));
        if (s_typesByID.containsKey(biID)) {
            throw new IllegalArgumentException("s_typesByID already contains " + id);
        }
        Types result = new Types(biID, name);
        s_typesByName.put(name, result);
        s_typesByID.put(biID, result);
        return result;
    }

    static void initialize() {
        if (Initializer.hasRun()) {
            throw new IllegalStateException("can't be called more than once");
        }
        Iterator ii = s_typesByID.values().iterator();
        while (ii.hasNext()) {
            Types type = (Types)ii.next();
            type.getDataObject();
        }
    }

    public static Types getObjectType(Object obj) {
        if (obj == null) {
            return VOID;
        }
        if (obj instanceof byte[]) {
            return BLOB;
        }
        return Types.getType(obj.getClass());
    }

    static Types getType(Class klass) throws UnknownTypeException {
        Assert.exists(klass, class$java$lang$Class == null ? (class$java$lang$Class = Types.class$("java.lang.Class")) : class$java$lang$Class);
        Class superClass = klass;
        do {
            Types result;
            if ((result = Types.getTypeOrNull(superClass.getName())) == null) continue;
            return result;
        } while ((superClass = superClass.getSuperclass()) != null);
        throw new UnknownTypeException(klass + " is not a known type");
    }

    public static Types getType(SimpleType type) {
        return Types.getType(type.getJavaClass());
    }

    private static Types getTypeOrNull(String className) {
        return (Types)s_typesByName.get(className);
    }

    static Types getType(BigInteger id) {
        Types result = (Types)s_typesByID.get(id);
        if (result == null) {
            throw new UnknownTypeException(id + " is not a known type.");
        }
        return result;
    }

    public static Types getType(DataObject dobj) {
        return Types.getType((BigInteger)dobj.get("id"));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_name).append(":").append(this.m_id);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.m_id.intValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

