/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.auditing.Audited;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.Transaction;
import com.arsdigita.versioning.TransactionCollection;
import com.arsdigita.versioning.VersionController;
import com.arsdigita.versioning.Versions;
import java.math.BigInteger;
import java.util.Date;
import org.apache.log4j.Logger;

public class VersionedACSObject
extends ACSObject
implements Audited {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$versioning$VersionedACSObject == null ? (class$com$arsdigita$versioning$VersionedACSObject = VersionedACSObject.class$("com.arsdigita.versioning.VersionedACSObject")) : class$com$arsdigita$versioning$VersionedACSObject));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.versioning.VersionedACSObject";
    public static final String MASTER = "master";
    public static final String IS_DELETED = "isDeleted";
    private static ObjectType s_properType = null;
    private VersionedACSObject m_master;
    private static final Audited NULL = new Audited(){

        public User getCreationUser() {
            return null;
        }

        public Date getCreationDate() {
            return null;
        }

        public String getCreationIP() {
            return null;
        }

        public User getLastModifiedUser() {
            return null;
        }

        public Date getLastModifiedDate() {
            return null;
        }

        public String getLastModifiedIP() {
            return null;
        }
    };
    static /* synthetic */ Class class$com$arsdigita$versioning$VersionedACSObject;

    protected VersionedACSObject(DataObject data) {
        super(data);
    }

    public VersionedACSObject(String typeName) {
        super(typeName);
    }

    public VersionedACSObject(ObjectType type) {
        super(type);
    }

    protected VersionedACSObject(OID oid, boolean checkDeleted) {
        super(oid);
        if (!checkDeleted) {
            throw new Error("not implemented");
        }
    }

    public VersionedACSObject(OID oid) {
        this(oid, true);
    }

    protected void beforeSave() {
        super.beforeSave();
        if (this.get(IS_DELETED) == null) {
            this.set(IS_DELETED, Boolean.FALSE);
        }
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public boolean recordAttributeChange(String action, String attr, Object oldValue, Object newValue) {
        return false;
    }

    public boolean trackChanges() {
        return true;
    }

    protected void propagateMaster(VersionedACSObject master) {
    }

    private Audited getAuditInfo() {
        Audited result = Versions.getAuditInfo(this.getOID());
        if (result == null) {
            result = NULL;
        }
        return result;
    }

    public User getCreationUser() {
        return this.getAuditInfo().getCreationUser();
    }

    public Date getCreationDate() {
        return this.getAuditInfo().getCreationDate();
    }

    public String getCreationIP() {
        return this.getAuditInfo().getCreationIP();
    }

    public User getLastModifiedUser() {
        return this.getAuditInfo().getLastModifiedUser();
    }

    public Date getLastModifiedDate() {
        return this.getAuditInfo().getLastModifiedDate();
    }

    public String getLastModifiedIP() {
        return this.getAuditInfo().getLastModifiedIP();
    }

    public VersionedACSObject getMaster() {
        if (this.m_master == null) {
            DataObject d = (DataObject)super.get(MASTER);
            this.m_master = d != null ? (VersionedACSObject)DomainObjectFactory.newInstance(d) : this;
        }
        if (this.m_master != this) {
            this.m_master = this.m_master.getMaster();
        }
        return this.m_master;
    }

    public void setMaster(VersionedACSObject master) {
        Assert.assertNotNull(master, "master object");
        Assert.assertTrue(!this.isRolledBack(), "Object " + this.getID() + " is rolled back");
        Assert.assertTrue(!master.isRolledBack(), "Master Object " + master.getID() + " is rolled back");
        this.m_master = master;
        if (master.equals(this)) {
            this.setAssociation(MASTER, null);
        } else {
            this.setAssociation(MASTER, master);
        }
    }

    public boolean isMaster() {
        return this.equals(this.getMaster());
    }

    public String applyUniqueTag(String prefix) {
        throw new Error("not implemented");
    }

    public void applyTag(String tag) {
        Versions.tag(this.getOID(), tag);
    }

    public void rollBackTo(String tag) {
        BigInteger id = Versions.getMostRecentTxnID(this.getOID(), tag);
        Versions.rollback(this.getOID(), id);
    }

    public void rollBackTo(Transaction trans) {
        throw new Error("not implemented");
    }

    public boolean isRolledBack() {
        return false;
    }

    public Transaction getRolledBackTo() {
        throw new Error("not implemented");
    }

    public void rollForward() {
        throw new Error("not implemented");
    }

    public TransactionCollection getTransactions(boolean descending) {
        return Versions.getTaggedTransactions(this.getOID(), descending);
    }

    public TransactionCollection getTransactions() {
        return Versions.getTaggedTransactions(this.getOID(), true);
    }

    public void autoPropagateMaster(VersionedACSObject master) {
        VersionController.autoPropagateMaster(this, master);
    }

    public void permanentlyDelete() {
        throw new Error("not implemented");
    }

    public void save(String tag) {
        this.applyTag(tag);
        this.save();
    }

    protected static boolean isSubtype(ObjectType subType) {
        if (subType == null) {
            return false;
        }
        if (s_properType == null) {
            s_properType = SessionManager.getSession().getMetadataRoot().getObjectType(BASE_DATA_OBJECT_TYPE);
            Assert.assertNotNull(s_properType, "Object type com.arsdigita.versioning.VersionedACSObject");
        }
        return subType.isSubtypeOf(s_properType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

