/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.auditing.Audited;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.FlushException;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.Adapter;
import com.arsdigita.versioning.DiffSet;
import com.arsdigita.versioning.Difference;
import com.arsdigita.versioning.GraphNode;
import com.arsdigita.versioning.ObjectTypeMetadata;
import com.arsdigita.versioning.RollbackListener;
import com.arsdigita.versioning.Transaction;
import com.arsdigita.versioning.TransactionCollection;
import com.arsdigita.versioning.VersioningException;
import com.arsdigita.versioning.VersioningProcessorManager;
import com.redhat.persistence.EventProcessorManager;
import com.redhat.persistence.pdl.VersioningMetadata;
import java.math.BigInteger;
import java.util.Date;
import org.apache.log4j.Logger;

public final class Versions {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$versioning$Versions == null ? (class$com$arsdigita$versioning$Versions = Versions.class$("com.arsdigita.versioning.Versions")) : class$com$arsdigita$versioning$Versions));
    private static final String SORT_KEY_DESC = "id desc";
    public static final VersioningMetadata.NodeVisitor NODE_VISITOR = new NodeVisitorImpl();
    public static final EventProcessorManager EPM = new VersioningProcessorManager();
    static /* synthetic */ Class class$com$arsdigita$versioning$Versions;
    static /* synthetic */ Class class$com$arsdigita$persistence$OID;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$com$arsdigita$versioning$RollbackListener;
    static /* synthetic */ Class class$com$arsdigita$persistence$DataObject;

    private Versions() {
    }

    public static void tag(OID oid, String tag) {
        VersioningProcessorManager.getVersioningEventProcessor().tag(oid, tag);
    }

    private static void flushPendingEvents() throws VersioningException {
        try {
            SessionManager.getSession().flushAll();
        }
        catch (FlushException ex) {
            throw new VersioningException("Session not flushable", ex);
        }
    }

    public static void suspendVersioning() throws VersioningException {
        Versions.flushPendingEvents();
        VersioningProcessorManager.getVersioningEventProcessor().suspendVersioning();
    }

    public static void resumeVersioning() throws VersioningException {
        Versions.flushPendingEvents();
        VersioningProcessorManager.getVersioningEventProcessor().resumeVersioning();
    }

    public static BigInteger getMostRecentTxnID(OID oid, String tag) {
        DataCollection dc = Versions.getTaggedTxns(oid, SORT_KEY_DESC);
        dc.addEqualsFilter("tags.tag", tag);
        BigInteger txnID = null;
        if (dc.next()) {
            txnID = (BigInteger)dc.get("id");
        }
        dc.close();
        return txnID;
    }

    public static TransactionCollection getTaggedTransactions(OID oid, boolean down) {
        if (down) {
            return new TransactionCollection(Versions.getTaggedTxns(oid, SORT_KEY_DESC));
        }
        return new TransactionCollection(Versions.getTaggedTxns(oid, "id"));
    }

    public static TransactionCollection getTaggedTransactions(OID oid) {
        return Versions.getTaggedTransactions(oid, true);
    }

    private static DataCollection getTaggedTxns(OID oid, String order) {
        DataCollection dc = SessionManager.getSession().retrieve("com.arsdigita.versioning.Txn");
        dc.addOrder(order);
        dc.addEqualsFilter("tags.taggedOID", Adapter.serialize(oid));
        return dc;
    }

    private static DataCollection getTxns(OID oid) {
        DataCollection dc = SessionManager.getSession().retrieve("com.arsdigita.versioning.Txn");
        dc.addEqualsFilter("changes.oid", Adapter.serialize(oid));
        return dc;
    }

    static TransactionCollection getTransactions(OID oid) {
        return new TransactionCollection(Versions.getTxns(oid));
    }

    public static Difference diff(OID oid, BigInteger fromID, BigInteger toID) {
        Assert.exists(oid, class$com$arsdigita$persistence$OID == null ? (class$com$arsdigita$persistence$OID = Versions.class$("com.arsdigita.persistence.OID")) : class$com$arsdigita$persistence$OID);
        DiffSet from = new DiffSet(oid, fromID);
        return from.diff(toID);
    }

    public static Difference diff(OID oid, Transaction from, Transaction to) {
        return Versions.diff(oid, from == null ? null : from.getID(), to == null ? null : to.getID());
    }

    public static DataObject rollback(OID oid, BigInteger txnID) {
        Assert.exists(oid, class$com$arsdigita$persistence$OID == null ? (class$com$arsdigita$persistence$OID = Versions.class$("com.arsdigita.persistence.OID")) : class$com$arsdigita$persistence$OID);
        Assert.exists(txnID, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Versions.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        return new DiffSet(oid, txnID).rollback();
    }

    static DataObject rollback(OID oid, BigInteger txnID, RollbackListener rl) {
        rl.onStart();
        DataObject result = new DiffSet(oid, txnID, rl).rollback();
        rl.onFinish();
        return result;
    }

    static void computeDifferences(OID oid, BigInteger txnID, RollbackListener rl) {
        Assert.exists(oid, class$com$arsdigita$persistence$OID == null ? (class$com$arsdigita$persistence$OID = Versions.class$("com.arsdigita.persistence.OID")) : class$com$arsdigita$persistence$OID);
        Assert.exists(txnID, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Versions.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        Assert.exists(rl, class$com$arsdigita$versioning$RollbackListener == null ? (class$com$arsdigita$versioning$RollbackListener = Versions.class$("com.arsdigita.versioning.RollbackListener")) : class$com$arsdigita$versioning$RollbackListener);
        rl.onStart();
        new DiffSet(oid, txnID, rl).computeDifferences();
        rl.onFinish();
    }

    public static Audited getAuditInfo(OID oid) {
        DataObject creationTxn = Versions.getCreationTxn(oid);
        if (creationTxn == null) {
            return null;
        }
        DataObject lastTxn = Versions.getLastTxn(oid);
        Assert.exists(lastTxn, class$com$arsdigita$persistence$DataObject == null ? (class$com$arsdigita$persistence$DataObject = Versions.class$("com.arsdigita.persistence.DataObject")) : class$com$arsdigita$persistence$DataObject);
        return new FullAuditInfo(creationTxn, lastTxn);
    }

    private static DataObject getCreationTxn(OID oid) {
        DataCollection dc = Versions.getTxns(oid);
        dc.addOrder("id asc");
        DataObject txn = null;
        if (dc.next()) {
            txn = dc.getDataObject();
        }
        dc.close();
        return txn;
    }

    private static DataObject getLastTxn(OID oid) {
        DataCollection dc = Versions.getTxns(oid);
        dc.addOrder(SORT_KEY_DESC);
        DataObject txn = null;
        if (dc.next()) {
            txn = dc.getDataObject();
        }
        dc.close();
        return txn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class NodeVisitorImpl
    implements VersioningMetadata.NodeVisitor {
        private NodeVisitorImpl() {
        }

        public void onObjectType(ObjectType objType, boolean isMarked) {
            ObjectTypeMetadata.getInstance().addGraphNode(GraphNode.getInstance(objType), isMarked);
        }

        public void onVersionedProperty(Property property) {
            ObjectTypeMetadata.getInstance().addVersionedProperty(property);
        }

        public void onUnversionedProperty(Property property) {
            ObjectTypeMetadata.getInstance().markEdgeUnversioned(property);
        }

        public void onFinish() {
            ObjectTypeMetadata.getInstance().initialize();
        }
    }

    private static class FullAuditInfo
    implements Audited {
        private final AuditInfo m_creationInfo;
        private final AuditInfo m_lastInfo;

        public FullAuditInfo(DataObject creationTxn, DataObject lastTxn) {
            this.m_creationInfo = new AuditInfo(creationTxn);
            this.m_lastInfo = new AuditInfo(lastTxn);
        }

        public Date getCreationDate() {
            return this.m_creationInfo.getDate();
        }

        public String getCreationIP() {
            return this.m_creationInfo.getIP();
        }

        public User getCreationUser() {
            return this.m_creationInfo.getUser();
        }

        public Date getLastModifiedDate() {
            return this.m_lastInfo.getDate();
        }

        public String getLastModifiedIP() {
            return this.m_lastInfo.getIP();
        }

        public User getLastModifiedUser() {
            return this.m_lastInfo.getUser();
        }
    }

    private static class AuditInfo {
        private final Date m_date;
        private final String m_ip;
        private final User m_user;

        public AuditInfo(DataObject txn) {
            this.m_date = (Date)txn.get("timestamp");
            this.m_ip = (String)txn.get("modifyingIP");
            DataObject userDobj = (DataObject)txn.get("modUser");
            this.m_user = (User)DomainObjectFactory.newInstance(userDobj);
        }

        public Date getDate() {
            return this.m_date;
        }

        public String getIP() {
            return this.m_ip;
        }

        public User getUser() {
            return this.m_user;
        }
    }
}

