/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.web.ApplicationTypeCollection;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ApplicationType
extends ResourceType {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/web/ApplicationType.java#8 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$ApplicationType == null ? (class$com$arsdigita$web$ApplicationType = ApplicationType.class$("com.arsdigita.web.ApplicationType")) : class$com$arsdigita$web$ApplicationType));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.web.ApplicationType";
    private PackageType m_packageType;
    boolean m_legacyFree = false;
    static /* synthetic */ Class class$com$arsdigita$web$ApplicationType;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public ApplicationType(DataObject dataObject) {
        super(dataObject);
    }

    protected ApplicationType(String dataObjectType) {
        super(dataObjectType);
    }

    protected ApplicationType(String objectType, String title, String applicationObjectType) {
        this(objectType);
        Assert.assertNotNull(title, "String title");
        Assert.assertNotNull(applicationObjectType, "String applicationObjectType");
        this.setTitle(title);
        this.setApplicationObjectType(applicationObjectType);
        this.setDefaults();
        this.m_legacyFree = true;
    }

    private void setDefaults() {
        this.setFullPageView(true);
        this.setEmbeddedView(false);
        this.setWorkspaceApplication(true);
        this.setSingleton(false);
    }

    public ApplicationType(String title, String applicationObjectType) {
        this(BASE_DATA_OBJECT_TYPE, title, applicationObjectType);
    }

    protected ApplicationType(String dataObjectType, PackageType packageType, String title, String applicationObjectType) {
        this(dataObjectType);
        Assert.assertNotNull(title, "title");
        Assert.assertNotNull(applicationObjectType, "applicationObjectType");
        Assert.assertNotNull(packageType, "packageType");
        this.m_packageType = packageType;
        this.setPackageType(this.m_packageType);
        this.setTitle(title);
        this.setApplicationObjectType(applicationObjectType);
        this.setDefaults();
    }

    public static ApplicationType createApplicationType(PackageType packageType, String title, String applicationObjectType) {
        return new ApplicationType(BASE_DATA_OBJECT_TYPE, packageType, title, applicationObjectType);
    }

    protected ApplicationType(String dataObjectType, String key, String title, String applicationObjectType) {
        this(dataObjectType, ApplicationType.makePackageType(key, title), title, applicationObjectType);
    }

    private static final PackageType makePackageType(String key, String title) {
        PackageType packageType = new PackageType();
        Assert.assertNotNull(key, "key");
        Assert.assertNotNull(title, "title");
        packageType.setKey(key);
        packageType.setDisplayName(title);
        packageType.setURI("http://arsdigita.com/" + key);
        return packageType;
    }

    public static ApplicationType createApplicationType(String key, String title, String applicationObjectType) {
        PackageType packageType = null;
        try {
            packageType = PackageType.findByKey(key);
            return new ApplicationType(BASE_DATA_OBJECT_TYPE, packageType, title, applicationObjectType);
        }
        catch (DataObjectNotFoundException nfe) {
            return new ApplicationType(BASE_DATA_OBJECT_TYPE, key, title, applicationObjectType);
        }
    }

    public static ApplicationType retrieveApplicationType(BigDecimal id) {
        Assert.assertNotNull(id, "id");
        return ApplicationType.retrieveApplicationType(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public static ApplicationType retrieveApplicationType(OID oid) {
        Assert.assertNotNull(oid, "oid");
        DataObject dataObject = SessionManager.getSession().retrieve(oid);
        Assert.assertNotNull(dataObject);
        return ApplicationType.retrieveApplicationType(dataObject);
    }

    public static ApplicationType retrieveApplicationType(DataObject dataObject) {
        Assert.assertNotNull(dataObject, "dataObject");
        return new ApplicationType(dataObject);
    }

    public static ApplicationType retrieveApplicationTypeForApplication(String applicationObjectType) {
        Assert.assertNotNull(applicationObjectType, "applicationObjectType");
        DataCollection collection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        collection.addEqualsFilter("objectType", applicationObjectType);
        ApplicationType applicationType = null;
        if (collection.next()) {
            applicationType = ApplicationType.retrieveApplicationType(collection.getDataObject());
        }
        collection.close();
        return applicationType;
    }

    public static ApplicationTypeCollection retrieveAllApplicationTypes() {
        DataCollection collection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        Assert.assertNotNull(collection, "collection");
        collection.addEqualsFilter("hasFullPageView", Boolean.TRUE);
        return new ApplicationTypeCollection(collection);
    }

    public PackageType getPackageType() {
        if (this.m_legacyFree) {
            throw new UnsupportedOperationException("This method is only supported for legacy application types");
        }
        DataObject dataObject = (DataObject)this.get("packageType");
        if (dataObject == null) {
            return null;
        }
        return new PackageType(dataObject);
    }

    protected void setPackageType(PackageType packageType) {
        if (this.m_legacyFree) {
            throw new UnsupportedOperationException("This method is only supported for legacy application types");
        }
        Assert.assertNotNull(packageType, "packageType");
        this.setAssociation("packageType", packageType);
    }

    public void addStylesheet(Stylesheet stylesheet) {
        if (this.m_legacyFree) {
            throw new UnsupportedOperationException("This method is only supported for legacy application types");
        }
        if (this.m_packageType == null) {
            this.m_packageType = this.getPackageType();
        }
        this.m_packageType.addStylesheet(stylesheet);
    }

    public void setDispatcherClass(String className) {
        if (this.m_legacyFree) {
            throw new UnsupportedOperationException("This method is only supported for legacy application types");
        }
        if (this.m_packageType == null) {
            this.m_packageType = this.getPackageType();
        }
        this.m_packageType.setDispatcherClass(className);
    }

    public String getTitle() {
        String title = (String)this.get("title");
        Assert.assertNotNull(title, "title");
        return title;
    }

    public void setTitle(String title) {
        Assert.assertNotNull(title, "title");
        this.set("title", title);
    }

    public String getDescription() {
        String description = (String)this.get("description");
        return description;
    }

    public void setDescription(String description) {
        this.set("description", description);
    }

    public boolean isWorkspaceApplication() {
        Boolean result = (Boolean)this.get("isWorkspaceApplication");
        Assert.assertNotNull(result, "Boolean result");
        return result;
    }

    public void setWorkspaceApplication(boolean isWorkspaceApplication) {
        if (this.m_legacyFree) {
            throw new UnsupportedOperationException("This method is only supported for legacy application types");
        }
        this.set("isWorkspaceApplication", new Boolean(isWorkspaceApplication));
    }

    public boolean hasFullPageView() {
        Boolean result = (Boolean)this.get("hasFullPageView");
        Assert.assertNotNull(result, "Boolean result");
        return result;
    }

    protected void setFullPageView(boolean hasFullPageView) {
        if (this.m_legacyFree) {
            throw new UnsupportedOperationException("This method is only supported for legacy application types");
        }
        this.set("hasFullPageView", new Boolean(hasFullPageView));
    }

    public boolean hasEmbeddedView() {
        Boolean result = (Boolean)this.get("hasEmbeddedView");
        Assert.assertNotNull(result, "Boolean result");
        return result;
    }

    protected void setEmbeddedView(boolean hasEmbeddedView) {
        if (this.m_legacyFree) {
            throw new UnsupportedOperationException("This method is only supported for legacy application types");
        }
        this.set("hasEmbeddedView", new Boolean(hasEmbeddedView));
    }

    public String getProfile() {
        String profile = (String)this.get("profile");
        return profile;
    }

    protected void setProfile(String profile) {
        this.set("profile", profile);
    }

    public Collection getRelevantPrivileges() {
        LinkedList<PrivilegeDescriptor> result = new LinkedList<PrivilegeDescriptor>();
        DataAssociationCursor dac = ((DataAssociation)this.get("relevantPrivileges")).cursor();
        while (dac.next()) {
            PrivilegeDescriptor priv = PrivilegeDescriptor.get((String)dac.get("privilege"));
            result.add(priv);
        }
        return result;
    }

    public void addRelevantPrivilege(PrivilegeDescriptor privilege) {
        this.addRelevantPrivilege(privilege.getName());
    }

    public void addRelevantPrivilege(String privilegeName) {
        OID privOID = new OID("com.arsdigita.kernel.permissions.Privilege", (Object)privilegeName);
        DataObject privDO = SessionManager.getSession().retrieve(privOID);
        this.add("relevantPrivileges", privDO);
    }

    public void removeRelevantPrivilege(PrivilegeDescriptor privilege) {
        this.removeRelevantPrivilege(privilege.getName());
    }

    public void removeRelevantPrivilege(String privilegeName) {
        OID privOID = new OID("com.arsdigita.kernel.permissions.Privilege", (Object)privilegeName);
        DataObject privDO = SessionManager.getSession().retrieve(privOID);
        this.remove("relevantPrivileges", privDO);
    }

    public String getApplicationObjectType() {
        String objectType = (String)this.get("objectType");
        Assert.assertNotNull(objectType);
        return objectType;
    }

    protected void setApplicationObjectType(String objectType) {
        Assert.assertNotNull(objectType);
        this.set("objectType", objectType);
    }

    public void setSingleton(boolean isSingleton) {
        if (this.m_legacyFree) {
            throw new UnsupportedOperationException("This method is only supported for legacy application types");
        }
        this.set("isSingleton", new Boolean(isSingleton));
    }

    public boolean isSingleton() {
        Boolean result = (Boolean)this.get("isSingleton");
        Assert.assertNotNull(result, "Boolean result");
        return result;
    }

    public BigDecimal getID() {
        BigDecimal id = (BigDecimal)this.get("id");
        Assert.assertNotNull(id, "id");
        return id;
    }

    public String getStylesheet() {
        return "/__ccm__/xsl/default.xsl";
    }

    private BigDecimal generateID() throws PersistenceException {
        try {
            return Sequences.getNextValue();
        }
        catch (SQLException e) {
            String errorMsg = "Unable to generate a unique id.";
            s_log.error((Object)"Unable to generate a unique id.");
            throw new PersistenceException("Unable to generate a unique id.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

