/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.util.Assert;
import com.arsdigita.util.OrderedMap;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.ParameterListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.log4j.Logger;

public class ParameterMap
implements Cloneable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/web/ParameterMap.java#19 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$ParameterMap == null ? (class$com$arsdigita$web$ParameterMap = ParameterMap.class$("com.arsdigita.web.ParameterMap")) : class$com$arsdigita$web$ParameterMap));
    private static ArrayList s_listeners = new ArrayList();
    private OrderedMap m_params = new OrderedMap();
    static /* synthetic */ Class class$com$arsdigita$web$ParameterMap;

    public ParameterMap() {
    }

    private ParameterMap(String query) {
        this();
        if (query != null) {
            this.parseQueryString(query);
        }
    }

    public ParameterMap(HttpServletRequest sreq) {
        this();
        Enumeration keys = sreq.getParameterNames();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String[] values = sreq.getParameterValues(name);
            this.setParameterValues(name, values);
        }
    }

    public ParameterMap(Map params) {
        this();
        Set keySet;
        Set set = keySet = params == null ? null : params.keySet();
        if (keySet != null) {
            Iterator keys = keySet.iterator();
            while (keys.hasNext()) {
                String name = (String)keys.next();
                String[] values = (String[])params.get(name);
                this.setParameterValues(name, values);
            }
        }
    }

    public static final ParameterMap fromString(String query) {
        Assert.assertNotNull(query, "String query");
        if (query.startsWith("?")) {
            return new ParameterMap(query.substring(1));
        }
        return new ParameterMap(query);
    }

    public static final void registerListener(ParameterListener listener) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Registering parameter listener " + listener));
        }
        s_listeners.add(listener);
    }

    public Object clone() throws CloneNotSupportedException {
        ParameterMap result = (ParameterMap)super.clone();
        result.m_params = (OrderedMap)this.m_params.clone();
        return result;
    }

    private void parseQueryString(String query) {
        int len = query.length();
        int start = 0;
        while (true) {
            int end = -1;
            for (int i = start; i < len - 1; ++i) {
                if (query.charAt(i) != '&' && query.charAt(i) != ';') continue;
                end = i;
                break;
            }
            if (end == -1) {
                if (len <= start) break;
                try {
                    this.parseParameter(query, start, len);
                    break;
                }
                catch (DecoderException e) {
                    throw new UncheckedWrapperException(e);
                }
            }
            try {
                this.parseParameter(query, start, end);
            }
            catch (DecoderException e) {
                throw new UncheckedWrapperException(e);
            }
            start = end + 1;
        }
    }

    private void parseParameter(String query, int start, int end) throws DecoderException {
        int sep = query.indexOf(61, start);
        if (Assert.isAssertEnabled()) {
            Assert.assertTrue(start > -1);
            Assert.assertTrue(end > -1);
        }
        if (sep > -1) {
            String[] values;
            URLCodec codec = new URLCodec();
            String name = codec.decode(query.substring(start, sep));
            String value = codec.decode(query.substring(sep + 1, end));
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Parameter " + name + " = " + value));
            }
            if ((values = this.getParameterValues(name)) == null) {
                this.setParameter(name, value);
            } else {
                String[] newValues = new String[values.length + 1];
                for (int i = 0; i < values.length; ++i) {
                    newValues[i] = values[i];
                }
                newValues[values.length] = value;
                this.setParameterValues(name, newValues);
            }
        }
    }

    private void validateName(String name) {
        Assert.assertNotNull(name, "String name");
        Assert.assertTrue(!name.equals(""), "The name must not be the empty string");
        Assert.assertTrue(name.indexOf(" ") == -1, "The name must not contain any spaces: '" + name + "'");
    }

    public final void clear() {
        this.m_params.clear();
    }

    public final String getParameter(String name) {
        String[] values = (String[])this.m_params.get(name);
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public final void setParameter(String name, String value) {
        if (Assert.isAssertEnabled()) {
            this.validateName(name);
        }
        if (value == null) {
            this.m_params.put(name, new String[]{""});
        } else {
            this.m_params.put(name, new String[]{value});
        }
    }

    public final void setParameter(String name, Object value) {
        if (value == null) {
            this.setParameter(name, "");
        } else {
            this.setParameter(name, value.toString());
        }
    }

    public final String[] getParameterValues(String name) {
        return (String[])this.m_params.get(name);
    }

    public final void setParameterValues(String name, String[] values) {
        if (Assert.isAssertEnabled()) {
            this.validateName(name);
            Assert.assertNotNull(values, "String[] values");
            Assert.assertTrue(values.length > 0, "The values array must have at least one value");
        }
        this.m_params.put(name, values);
    }

    public final void clearParameter(String name) {
        if (Assert.isAssertEnabled()) {
            this.validateName(name);
        }
        this.m_params.remove(name);
    }

    public final Map getParameterMap() {
        if (this.m_params.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableMap(this.m_params);
    }

    public final String toString() {
        if (this.m_params.isEmpty()) {
            return "";
        }
        return "?" + this.makeQueryString();
    }

    public final String getQueryString() {
        return this.makeQueryString();
    }

    public final void runListeners(HttpServletRequest sreq) {
        Iterator iter = s_listeners.iterator();
        while (iter.hasNext()) {
            ParameterListener listener = (ParameterListener)iter.next();
            listener.run(sreq, this);
        }
    }

    final String makeQueryString() {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = this.m_params.entrySet().iterator();
        URLCodec codec = new URLCodec();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (Assert.isAssertEnabled()) {
                Assert.assertTrue(key.indexOf(37) == -1, "The key '" + key + "' has already been " + "encoded");
            }
            if (values == null) continue;
            if (Assert.isAssertEnabled()) {
                Assert.assertTrue(values.toString().indexOf(37) == -1, "One of the values " + Arrays.asList(values) + " has " + "already been encoded");
            }
            for (int i = 0; i < values.length; ++i) {
                try {
                    buffer.append(codec.encode(key));
                }
                catch (EncoderException e) {
                    throw new UncheckedWrapperException(e);
                }
                buffer.append('=');
                String value = values[i];
                if (value != null) {
                    try {
                        buffer.append(codec.encode(value));
                    }
                    catch (EncoderException e) {
                        throw new UncheckedWrapperException(e);
                    }
                }
                buffer.append('&');
            }
        }
        int last = buffer.length() - 1;
        if (last > -1 && buffer.charAt(last) == '&') {
            buffer.deleteCharAt(last);
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

