/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.parameter.EnumerationParameter;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterError;
import com.arsdigita.util.parameter.SingletonParameter;
import com.arsdigita.util.parameter.StringParameter;
import com.arsdigita.util.servlet.HttpHost;
import com.arsdigita.util.servlet.HttpHostParameter;
import com.arsdigita.web.ApplicationFileResolver;
import com.arsdigita.web.CachePolicy;
import com.arsdigita.web.DefaultApplicationFileResolver;
import com.arsdigita.web.Host;
import com.arsdigita.web.Web;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class WebConfig
extends AbstractConfig {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/web/WebConfig.java#15 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$WebConfig == null ? (class$com$arsdigita$web$WebConfig = WebConfig.class$("com.arsdigita.web.WebConfig")) : class$com$arsdigita$web$WebConfig));
    private final Parameter m_scheme = new DefaultSchemeParameter("waf.web.default_scheme", 1, "http");
    private final Parameter m_server = new HttpHostParameter("waf.web.server");
    private final Parameter m_host = new HttpHostParameter("waf.web.host", 0, null){

        public final Object getDefaultValue() {
            return WebConfig.this.getServer();
        }
    };
    private final Parameter m_site = new StringParameter("waf.web.site_name", 0, null){

        public final Object getDefaultValue() {
            HttpHost host = WebConfig.this.getServer();
            if (host == null) {
                return null;
            }
            return host.toString();
        }
    };
    private final Parameter m_context = new StringParameter("waf.web.dispatcher_context_path", 1, "");
    private final Parameter m_servlet = new StringParameter("waf.web.dispatcher_servlet_path", 1, "/ccm");
    private final Parameter m_policy = new CachePolicyParameter("waf.web.cache_policy", 0, null);
    private final Parameter m_resolver = new SingletonParameter("waf.web.application_file_resolver", 0, new DefaultApplicationFileResolver());
    static /* synthetic */ Class class$com$arsdigita$web$WebConfig;

    public WebConfig() {
        this.register(this.m_scheme);
        this.register(this.m_server);
        this.register(this.m_host);
        this.register(this.m_site);
        this.register(this.m_context);
        this.register(this.m_servlet);
        this.register(this.m_policy);
        this.register(this.m_resolver);
        this.loadInfo();
    }

    public final String getDefaultScheme() {
        return (String)this.get(this.m_scheme);
    }

    public final HttpHost getServer() {
        return (HttpHost)this.get(this.m_server);
    }

    public final HttpHost getHost() {
        return (HttpHost)this.get(this.m_host);
    }

    final void setHost(HttpHost host) {
        this.set(this.m_host, host);
    }

    public final String getSiteName() {
        return (String)this.get(this.m_site);
    }

    public final String getDispatcherContextPath() {
        return (String)this.get(this.m_context);
    }

    public final String getDispatcherServletPath() {
        return (String)this.get(this.m_servlet);
    }

    public final ApplicationFileResolver getApplicationFileResolver() {
        return (ApplicationFileResolver)this.get(this.m_resolver);
    }

    public final CachePolicy getCachePolicy() {
        return (CachePolicy)this.get(this.m_policy);
    }

    public final String getServerName() {
        return this.getServer().getName();
    }

    public final int getServerPort() {
        return this.getServer().getPort();
    }

    public final Host getCurrentHost() {
        return Host.retrieve(Web.getConfig().getHost());
    }

    public final Host[] getHosts() {
        ArrayList<Host> hosts = new ArrayList<Host>();
        DomainCollection coll = Host.retrieveAll();
        while (coll.next()) {
            hosts.add((Host)coll.getDomainObject());
        }
        coll.close();
        return hosts.toArray(new Host[hosts.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CachePolicyParameter
    extends EnumerationParameter {
        CachePolicyParameter(String name, int multiplicity, Object defaalt) {
            super(name, multiplicity, defaalt);
            this.put("none", null);
            this.put("disable", CachePolicy.DISABLE);
            this.put("user", CachePolicy.USER);
            this.put("world", CachePolicy.WORLD);
        }
    }

    private static class DefaultSchemeParameter
    extends EnumerationParameter {
        DefaultSchemeParameter(String name, int multiplicity, Object defaalt) {
            super(name, multiplicity, defaalt);
            this.put("http", "http");
            this.put("https", "https");
        }
    }

    private static class DispatcherServletPathParameter
    extends StringParameter {
        DispatcherServletPathParameter(String name) {
            super(name);
        }

        protected void doValidate(Object value, ErrorList errors) {
            String string = (String)value;
            if (string.endsWith("/")) {
                ParameterError error = new ParameterError((Parameter)this, "The value must not end in a '/'");
                errors.add(error);
            }
        }
    }
}

