/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.webdevsupport;

import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.caching.CacheTable;
import com.arsdigita.util.LockableImpl;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

final class CacheTableBrowser
extends SimpleContainer {
    private final Table m_listOfTables = new ListOfCacheTables();
    private final CacheTableContents m_tableContents = new CacheTableContents();
    static /* synthetic */ Class class$com$arsdigita$webdevsupport$CacheTableBrowser$CacheTableContents;

    CacheTableBrowser() {
        this.m_listOfTables.addTableActionListener(new TableActionListener(){

            public void cellSelected(TableActionEvent ev) {
                PageState state = ev.getPageState();
                CacheTableBrowser.this.m_tableContents.setTableID(state, (String)ev.getRowKey());
            }

            public void headSelected(TableActionEvent e) {
            }
        });
        this.add(this.m_listOfTables);
        this.add(this.m_tableContents);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CacheTableContents
    extends Table {
        private static final String TABLE_ID_ATTR = (class$com$arsdigita$webdevsupport$CacheTableBrowser$CacheTableContents == null ? (class$com$arsdigita$webdevsupport$CacheTableBrowser$CacheTableContents = CacheTableBrowser.class$("com.arsdigita.webdevsupport.CacheTableBrowser$CacheTableContents")) : class$com$arsdigita$webdevsupport$CacheTableBrowser$CacheTableContents).getName();
        private String m_tableID;

        public CacheTableContents() {
            super((TableModelBuilder)new ModelBuilder(), (Object[])new String[]{"Key", "Class", "Value", "Hash code", "Timestamp"});
        }

        public void setTableID(PageState state, String tableID) {
            state.getRequest().setAttribute(TABLE_ID_ATTR, (Object)tableID);
        }

        private static class Model
        implements TableModel {
            private static final DateFormat FORMATTER = new SimpleDateFormat("HH:mm:ss.S");
            private final Iterator m_entries;
            private CacheTable.TimestampedEntry m_entry;

            Model(String tableID) {
                if (tableID == null) {
                    this.m_entries = Collections.EMPTY_LIST.iterator();
                    return;
                }
                Set set = CacheTable.BROWSER.getEntrySet(tableID);
                if (set == null) {
                    this.m_entries = Collections.EMPTY_LIST.iterator();
                    return;
                }
                ArrayList list = new ArrayList(set);
                Collections.sort(list, new Comparator(this){
                    private final /* synthetic */ Model this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public int compare(Object o1, Object o2) {
                        if (o1 == null || o2 == null) {
                            throw new NullPointerException();
                        }
                        CacheTable.TimestampedEntry t1 = (CacheTable.TimestampedEntry)o1;
                        CacheTable.TimestampedEntry t2 = (CacheTable.TimestampedEntry)o2;
                        return t1.getKey().compareTo(t2.getKey());
                    }
                });
                this.m_entries = list.iterator();
            }

            public boolean nextRow() {
                if (this.m_entries.hasNext()) {
                    this.m_entry = (CacheTable.TimestampedEntry)this.m_entries.next();
                    return true;
                }
                this.m_entry = null;
                return false;
            }

            public int getColumnCount() {
                return 5;
            }

            private static String classname(Object obj) {
                if (obj == null) {
                    return null;
                }
                String cName = obj.getClass().getName();
                int dotIdx = cName.lastIndexOf(46);
                return dotIdx < 0 ? cName : cName.substring(dotIdx + 1);
            }

            public Object getElementAt(int columnIdx) {
                switch (columnIdx) {
                    case 0: {
                        return this.m_entry.getKey();
                    }
                    case 1: {
                        return Model.classname(this.m_entry.getValue());
                    }
                    case 2: {
                        return this.m_entry.getValue();
                    }
                    case 3: {
                        return this.m_entry.getValue() == null ? "null" : Model.toHex(this.m_entry.getValue().hashCode());
                    }
                    case 4: {
                        return FORMATTER.format(this.m_entry.getTimestamp());
                    }
                }
                throw new IllegalArgumentException("idx=" + columnIdx);
            }

            private static String toHex(int value) {
                String hex = Integer.toHexString(value).toUpperCase();
                return "00000000".substring(0, 8 - hex.length()) + hex;
            }

            public Object getKeyAt(int columnIndex) {
                return this.m_entry.getKey();
            }
        }

        private static class ModelBuilder
        extends LockableImpl
        implements TableModelBuilder {
            private ModelBuilder() {
            }

            public TableModel makeModel(Table table, PageState state) {
                String tableID = (String)state.getRequest().getAttribute(TABLE_ID_ATTR);
                return new Model(tableID);
            }
        }
    }

    private static class ListOfCacheTables
    extends Table {
        public ListOfCacheTables() {
            super((TableModelBuilder)new ModelBuilder(), (Object[])new String[]{"Cache table", "Max size", "Current size", "Max age, sec"});
        }

        private static class Model
        implements TableModel {
            private final Iterator m_keys;
            private String m_key;

            Model(Iterator keys) {
                this.m_keys = keys;
            }

            public boolean nextRow() {
                if (this.m_keys.hasNext()) {
                    this.m_key = (String)this.m_keys.next();
                    return true;
                }
                this.m_key = null;
                return false;
            }

            public int getColumnCount() {
                return 4;
            }

            public Object getElementAt(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        if ("0".equals(CacheTable.BROWSER.getCurrentSize(this.m_key))) {
                            return new Label(this.m_key);
                        }
                        return new ControlLink(new Label(this.m_key));
                    }
                    case 1: {
                        return CacheTable.BROWSER.getMaxSize(this.m_key);
                    }
                    case 2: {
                        return CacheTable.BROWSER.getCurrentSize(this.m_key);
                    }
                    case 3: {
                        return CacheTable.BROWSER.getMaxAge(this.m_key);
                    }
                }
                throw new IllegalArgumentException("columnIndex: " + columnIndex);
            }

            public Object getKeyAt(int columnIndex) {
                return this.m_key;
            }
        }

        private static class ModelBuilder
        extends LockableImpl
        implements TableModelBuilder {
            private ModelBuilder() {
            }

            public TableModel makeModel(Table table, PageState state) {
                ArrayList keys = new ArrayList(CacheTable.BROWSER.getTableIDs());
                Collections.sort(keys);
                return new Model(keys.iterator());
            }
        }
    }
}

