/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.webdevsupport;

import com.arsdigita.db.ConnectionManager;
import com.arsdigita.db.Sequences;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class QueryPlan {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/webdevsupport/QueryPlan.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$webdevsupport$QueryPlan == null ? (class$com$arsdigita$webdevsupport$QueryPlan = QueryPlan.class$("com.arsdigita.webdevsupport.QueryPlan")) : class$com$arsdigita$webdevsupport$QueryPlan));
    static /* synthetic */ Class class$com$arsdigita$webdevsupport$QueryPlan;

    public static boolean planTableExists() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.webdevsupport.planTableExists");
        return query.size() == 1L;
    }

    public static String getQueryPlanID(String sqlText) {
        String planID = QueryPlan.getNewQueryPlanID();
        QueryPlan.generateQueryPlan(sqlText, planID);
        return planID;
    }

    public static void deleteQueryPlan(String planID) {
        DataOperation operation = SessionManager.getSession().retrieveDataOperation("com.arsdigita.webdevsupport.deleteQueryPlan");
        operation.setParameter("planID", planID);
        operation.execute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void generateQueryPlan(String sqlText, String planID) {
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getCurrentThreadConnection();
                stmt = conn.createStatement();
                stmt.executeUpdate("explain plan set statement_id = '" + planID + "' for " + sqlText);
            }
            catch (SQLException e) {
                throw new UncheckedWrapperException(e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e2) {
                throw new UncheckedWrapperException(e2);
            }
        }
        try {}
        catch (SQLException e2) {
            throw new UncheckedWrapperException(e2);
        }
        if (stmt == null) return;
        stmt.close();
    }

    private static String getNewQueryPlanID() {
        try {
            return "ACS-query-" + Sequences.getNextValue();
        }
        catch (SQLException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

