/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.webdevsupport;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.db.ConnectionManager;
import com.arsdigita.db.DbHelper;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.webdevsupport.QueryInfo;
import com.arsdigita.webdevsupport.QueryLog;
import com.arsdigita.webdevsupport.QueryPlan;
import com.arsdigita.webdevsupport.RequestInfo;
import com.arsdigita.webdevsupport.WebDevSupport;
import com.arsdigita.xml.Element;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

class QueryPlanComponent
extends SimpleContainer {
    private ParameterModel m_query_id = new IntegerParameter("query_id");
    private ParameterModel m_request_id = new IntegerParameter("request_id");
    private static final Label NO_PLAN = new Label("You don't have the plan table installed. Please source $ORACLE_HOME/rdbms/admin/utlxplan.sql if you want to enable this functionality.");

    public QueryPlanComponent() {
        Label queryTextLabel = new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState s = e.getPageState();
                Label l = (Label)e.getTarget();
                l.setLabel("<h3>Query:</h3> <blockquote><pre>" + StringUtils.quoteHtml(QueryPlanComponent.this.getSQL(s)) + "</pre></blockquote>");
            }
        });
        queryTextLabel.setOutputEscaping(false);
        this.add(queryTextLabel);
        Label queryVarsLabel = new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState s = e.getPageState();
                Label l = (Label)e.getTarget();
                l.setLabel("<h3>Variables:</h3> " + QueryPlanComponent.this.getBindVars(s));
            }
        });
        queryVarsLabel.setOutputEscaping(false);
        this.add(queryVarsLabel);
        Label queryPlanLabel = new Label("<h3>Execution Plan</h3>");
        queryPlanLabel.setOutputEscaping(false);
        this.add(queryPlanLabel);
        Table table = null;
        if (DbHelper.getDatabase() == 1) {
            AbstractTableModelBuilder m_QueryPlanTableModelBuilder = new AbstractTableModelBuilder(){

                public TableModel makeModel(Table t, PageState pageState) {
                    return new OracleQueryPlanTableModel(pageState);
                }
            };
            Object[] headings = new String[]{"Step#", "Parent#", "Level", "Operation", "Options", "Object Name", "Rows", "Bytes", "Cost"};
            table = new Table(m_QueryPlanTableModelBuilder, headings){

                public void generateXML(PageState ps, Element parent) {
                    if (QueryPlan.planTableExists()) {
                        super.generateXML(ps, parent);
                    } else {
                        NO_PLAN.generateXML(ps, parent);
                    }
                }
            };
        } else {
            AbstractTableModelBuilder m_QueryPlanTableModelBuilder = new AbstractTableModelBuilder(){

                public TableModel makeModel(Table t, PageState pageState) {
                    return new PostgresQueryPlanTableModel(pageState);
                }
            };
            Object[] headings = new String[]{"Step"};
            table = new Table(m_QueryPlanTableModelBuilder, headings){

                public void generateXML(PageState ps, Element parent) {
                    super.generateXML(ps, parent);
                }
            };
            table.setDefaultCellRenderer(new TableCellRenderer(){

                public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
                    Label l = new Label("<pre>" + (String)value + "</pre>");
                    l.setOutputEscaping(false);
                    return l;
                }
            });
        }
        table.setWidth("100%");
        table.setBorder("1");
        this.add(table);
    }

    private String getSQL(PageState s) {
        QueryInfo qi;
        Integer request_id = (Integer)s.getValue(this.m_request_id);
        Integer query_id = (Integer)s.getValue(this.m_query_id);
        RequestInfo ri = WebDevSupport.getInstance().getRequest(request_id);
        if (ri != null && (qi = ri.getQuery(query_id)) != null) {
            return qi.getQuery();
        }
        return null;
    }

    private HashMap getBindVars(PageState s) {
        QueryInfo qi;
        Integer request_id = (Integer)s.getValue(this.m_request_id);
        Integer query_id = (Integer)s.getValue(this.m_query_id);
        RequestInfo ri = WebDevSupport.getInstance().getRequest(request_id);
        if (ri != null && (qi = ri.getQuery(query_id)) != null) {
            return qi.getBindvars();
        }
        return null;
    }

    private QueryInfo getQueryInfo(PageState s) {
        QueryInfo qi;
        Integer request_id = (Integer)s.getValue(this.m_request_id);
        Integer query_id = (Integer)s.getValue(this.m_query_id);
        RequestInfo ri = WebDevSupport.getInstance().getRequest(request_id);
        if (ri != null && (qi = ri.getQuery(query_id)) != null) {
            return qi;
        }
        return null;
    }

    private class PostgresQueryPlanTableModel
    implements TableModel {
        ResultSet m_query;
        Statement m_stmt = null;

        public PostgresQueryPlanTableModel(PageState pageState) {
            Connection conn = ConnectionManager.getCurrentThreadConnection();
            try {
                this.m_stmt = conn.createStatement();
                this.m_query = this.m_stmt.executeQuery("Explain " + QueryLog.substituteSQL(QueryPlanComponent.this.getQueryInfo(pageState)));
            }
            catch (SQLException e) {
                throw new UncheckedWrapperException(e);
            }
        }

        public int getColumnCount() {
            return 1;
        }

        public boolean nextRow() {
            try {
                boolean nRow = this.m_query.next();
                if (!nRow) {
                    this.m_query.close();
                    this.m_stmt.close();
                }
                return nRow;
            }
            catch (Exception e) {
                throw new UncheckedWrapperException(e);
            }
        }

        public Object getElementAt(int columnIndex) {
            try {
                switch (columnIndex) {
                    case 0: {
                        return this.m_query.getObject(1);
                    }
                }
                return null;
            }
            catch (Exception e) {
                throw new UncheckedWrapperException(e);
            }
        }

        public Object getKeyAt(int columnIndex) {
            try {
                return this.m_query.getObject(1);
            }
            catch (Exception e) {
                throw new UncheckedWrapperException(e);
            }
        }
    }

    private class OracleQueryPlanTableModel
    implements TableModel {
        DataQuery m_query;
        String m_planID;

        public OracleQueryPlanTableModel(PageState pageState) {
            this.m_planID = QueryPlan.getQueryPlanID(QueryPlanComponent.this.getSQL(pageState));
            this.m_query = SessionManager.getSession().retrieveQuery("com.arsdigita.webdevsupport.queryPlan");
            this.m_query.setParameter("plan_id", this.m_planID);
        }

        public int getColumnCount() {
            return 9;
        }

        public boolean nextRow() {
            boolean nRow = this.m_query.next();
            if (!nRow) {
                this.m_query.close();
                QueryPlan.deleteQueryPlan(this.m_planID);
            }
            return nRow;
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.m_query.get("id");
                }
                case 1: {
                    return this.m_query.get("parentID");
                }
                case 2: {
                    return this.m_query.get("level");
                }
                case 3: {
                    return this.m_query.get("operation");
                }
                case 4: {
                    return this.m_query.get("execOptions");
                }
                case 5: {
                    return this.m_query.get("objectName");
                }
                case 6: {
                    return this.m_query.get("cardinality");
                }
                case 7: {
                    return this.m_query.get("bytes");
                }
                case 8: {
                    return this.m_query.get("cost");
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_query.get("id");
        }
    }
}

