/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.webdevsupport;

import com.arsdigita.webdevsupport.QueryInfo;
import java.util.ListIterator;

public class StageInfo {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/webdevsupport/StageInfo.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private String m_name;
    private long m_start_time;
    private long m_end_time;
    private int m_depth;
    private int m_start_queries;
    private int m_end_queries;
    private boolean m_leaf = true;

    public StageInfo(String name, int depth, int start_queries) {
        this.m_name = name;
        this.m_depth = depth;
        this.m_start_time = System.currentTimeMillis();
        this.m_start_queries = start_queries;
    }

    public String getName() {
        return this.m_name;
    }

    public void end(int end_queries) {
        this.m_end_time = System.currentTimeMillis();
        this.m_end_queries = end_queries;
    }

    public long endTime() {
        return this.m_end_time;
    }

    public long startTime() {
        return this.m_start_time;
    }

    public long time() {
        return this.m_end_time - this.m_start_time;
    }

    public int depth() {
        return this.m_depth;
    }

    public void setLeaf(boolean leaf) {
        this.m_leaf = leaf;
    }

    public boolean leaf() {
        return this.m_leaf;
    }

    public int numQueries() {
        return this.m_end_queries - this.m_start_queries;
    }

    public long queryTime(ListIterator queries) {
        int i;
        long total_time = 0L;
        for (i = 0; queries.hasNext() && i != this.m_start_queries; ++i) {
            queries.next();
        }
        while (queries.hasNext() && i != this.m_end_queries) {
            QueryInfo qi = (QueryInfo)queries.next();
            total_time += qi.getTime();
            ++i;
        }
        return total_time;
    }
}

