/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.webdevsupport.config;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.packaging.ConfigRegistry;
import com.arsdigita.util.Classes;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterContext;
import com.arsdigita.util.parameter.ParameterInfo;
import com.arsdigita.util.parameter.ParameterWriter;
import com.arsdigita.xml.Element;
import com.arsdigita.xml.XML;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigList
extends SimpleContainer {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$webdevsupport$config$ConfigList == null ? (class$com$arsdigita$webdevsupport$config$ConfigList = ConfigList.class$("com.arsdigita.webdevsupport.config.ConfigList")) : class$com$arsdigita$webdevsupport$config$ConfigList));
    public static final String XML_NS = "http://xmlns.redhat.com/waf/webdevsupport/1.0";
    static /* synthetic */ Class class$com$arsdigita$webdevsupport$config$ConfigList;

    public ConfigList() {
        super("devsup:configList", XML_NS);
    }

    public void generateXML(PageState state, Element parent) {
        Element content = this.generateParent(parent);
        ConfigRegistry reg = new ConfigRegistry();
        Iterator packages = reg.getPackages().iterator();
        while (packages.hasNext()) {
            content.addContent(this.generateApplication(reg, (String)packages.next()));
        }
    }

    public Element generateApplication(ConfigRegistry reg, String key) {
        ArrayList ctxs = new ArrayList();
        XML.parseResource(key + ".config", new ConfigRegistryParser(ctxs));
        Element app = new Element("application");
        app.addAttribute("key", key);
        Iterator i = ctxs.iterator();
        while (i.hasNext()) {
            ParameterContext context = (ParameterContext)i.next();
            reg.load(context, new ErrorList());
            app.addContent(this.generateContext(context));
        }
        return app;
    }

    public Element generateContext(ParameterContext context) {
        Element ctx = new Element("context");
        ctx.addAttribute("class", context.getClass().getName());
        Parameter[] params = context.getParameters();
        for (int i = 0; i < params.length; ++i) {
            ctx.addContent(this.generateParameter(context, params[i]));
        }
        return ctx;
    }

    public Element generateParameter(ParameterContext context, Parameter param) {
        final Element p = new Element("param");
        p.addAttribute("name", param.getName());
        p.addAttribute("class", param.getClass().getName());
        p.addAttribute("isRequired", XML.format(new Boolean(param.isRequired())));
        param.write(new ParameterWriter(){

            public void write(Parameter param, String value) {
                if (value != null) {
                    p.addAttribute("value", value);
                }
            }
        }, context.get(param));
        ParameterInfo info = param.getInfo();
        if (info != null) {
            if (StringUtils.emptyString(info.getTitle()) || StringUtils.emptyString(info.getPurpose()) || StringUtils.emptyString(info.getExample()) || StringUtils.emptyString(info.getFormat())) {
                s_log.warn((Object)("Info for parameter " + param.getName() + " is incomplete"));
            }
            p.addAttribute("title", info.getTitle());
            p.addAttribute("purpose", info.getPurpose());
            p.addAttribute("example", info.getExample());
            p.addAttribute("format", info.getFormat());
        } else {
            s_log.warn((Object)("Parameter " + param.getName() + " has no info"));
        }
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConfigRegistryParser
    extends DefaultHandler {
        private List m_contexts;

        public ConfigRegistryParser(List contexts) {
            this.m_contexts = contexts;
        }

        public void startElement(String uri, String localName, String qn, Attributes attrs) {
            if (localName.equals("config")) {
                String klass = attrs.getValue(uri, "class");
                if (klass == null) {
                    throw new IllegalArgumentException("class and storage attributes are required");
                }
                ParameterContext context = (ParameterContext)Classes.newInstance(klass);
                this.m_contexts.add(context);
            }
        }
    }
}

