/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.webdevsupport.log4j;

import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.util.LockableImpl;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CategoryTable
extends Table {
    public CategoryTable() {
        super((TableModelBuilder)new CategoryTableModelBuilder(), (Object[])new String[]{"Logger", "Level"});
    }

    private static class LoggerComparator
    implements Comparator {
        private LoggerComparator() {
        }

        public int compare(Object o1, Object o2) {
            Logger c1 = (Logger)o1;
            Logger c2 = (Logger)o2;
            return c1.getName().compareTo(c2.getName());
        }
    }

    private static class CategoryTableModel
    implements TableModel {
        private Iterator m_cats;
        private Logger m_cat;

        public CategoryTableModel(Iterator cats) {
            this.m_cats = cats;
        }

        public boolean nextRow() {
            if (this.m_cats.hasNext()) {
                this.m_cat = (Logger)this.m_cats.next();
                return true;
            }
            this.m_cat = null;
            return false;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getElementAt(int columnIndex) {
            if (columnIndex == 0) {
                return new ControlLink(new Label(this.m_cat.getName()));
            }
            Level level = this.m_cat.getLevel();
            return new Label(level != null ? level.toString() : "none");
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_cat.getName();
        }
    }

    private static class CategoryTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private CategoryTableModelBuilder() {
        }

        public TableModel makeModel(Table table, PageState state) {
            Enumeration loggers = LogManager.getCurrentLoggers();
            TreeSet set = new TreeSet(new LoggerComparator());
            while (loggers.hasMoreElements()) {
                set.add(loggers.nextElement());
            }
            return new CategoryTableModel(set.iterator());
        }
    }
}

